/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CBlobAccessor
extends BlobAccessor {
    T4CMAREngine mare;
    final int[] meta;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    T4CBlobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$11, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.meta = new int[1];
            this.mare = _mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CBlobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$12, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.meta = new int[1];
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean isStream = false;
            if (!this.isUseless()) {
                if (this.isUnexpected()) {
                    long pos = this.rowData.getPosition();
                    this.unmarshalColumnMetadata();
                    this.unmarshalBytes();
                    this.rowData.setPosition(pos);
                    this.setNull(this.lastRowProcessed, true);
                } else if (this.isNullByDescribe()) {
                    this.setNull(this.lastRowProcessed, true);
                    this.unmarshalColumnMetadata();
                    if (this.statement.connection.versionNumber < 9200) {
                        this.processIndicator(0);
                    }
                } else {
                    this.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes();
                }
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            boolean bl2 = isStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            NoSuchMethodError noSuchMethodError = new NoSuchMethodError("oracle.jdbc.driver.T4C_lobAccessor.copyRow");
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$6, this, noSuchMethodError);
            }
            throw noSuchMethodError;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            if (this.isPrefetched()) {
                if (this.getPrefetchedLength((int)currentRow) > Integer.MAX_VALUE) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                if ((long)this.getPrefetchedDataLength((int)currentRow) == this.getPrefetchedLength((int)currentRow)) {
                    byte[] byArray = this.getPrefetchedData((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, null);
                    }
                    return byArray;
                }
                if (!$assertionsDisabled && (long)this.getPrefetchedDataLength((int)currentRow) > this.getPrefetchedLength((int)currentRow)) {
                    AssertionError assertionError = new AssertionError((Object)(" prefetchDataLength=" + this.getPrefetchedDataLength((int)currentRow) + " > length=" + this.getPrefetchedLength((int)currentRow)));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                BLOB blob = this.getBLOB((int)currentRow);
                if (blob == null) {
                    byte[] byArray = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, null);
                    }
                    return null;
                }
                byte[] byArray = blob.getBytes(1L, (int)this.getPrefetchedLength((int)currentRow));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, null);
                }
                return byArray;
            }
            byte[] byArray = super.getBytes((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if ((len = (int)this.mare.unmarshalUB4()) == 0) {
                this.setNull(this.lastRowProcessed, true);
                this.processIndicator(0);
            } else {
                if (this.isPrefetched()) {
                    this.unmarshalPrefetchData();
                }
                this.setOffset(this.lastRowProcessed);
                int actualLength = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
                this.setNull(this.lastRowProcessed, actualLength == 0);
                this.setLength(this.lastRowProcessed, actualLength);
                this.processIndicator(actualLength);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$8, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$9, this, new Object[0]);
            }
            this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
            this.setPrefetchedChunkSize(this.lastRowProcessed, (int)this.mare.unmarshalUB4());
            this.setPrefetchedDataOffset(this.lastRowProcessed);
            if (this.getPrefetchLength() > 0) {
                this.setPrefetchedDataLength(this.lastRowProcessed, ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare));
            } else {
                this.setPrefetchedDataLength(this.lastRowProcessed, 0);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, object);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, null);
                }
                return object;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            if (this.definedColumnType == 2004) {
                BLOB bLOB = this.getBLOB((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, bLOB);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, null);
                }
                return bLOB;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBlobAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = T4CBlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CBlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CBlobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CBlobAccessor.class.getDeclaredMethod("unmarshalPrefetchData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CBlobAccessor.class.getDeclaredMethod("unmarshalBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CBlobAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CBlobAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CBlobAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CBlobAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CBlobAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CBlobAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CBlobAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CBlobAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

