/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.MessageTemplate;
import org.firebirdsql.gds.OverriddenSqlStateMessageTemplate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class DefaultMessageTemplate
extends MessageTemplate {
    private static final int PARAM_SIZE_FACTOR = 20;
    private static final int COUNT_UNKNOWN = -1;
    private static final Pattern MESSAGE_PARAM_PATTERN = Pattern.compile("\\{(\\d+)}");
    private final int errorCode;
    private final String templateText;
    private final @Nullable String sqlState;
    private int parameterCount;

    DefaultMessageTemplate(int errorCode, String templateText) {
        this(errorCode, templateText, null, -1);
    }

    DefaultMessageTemplate(int errorCode, String templateText, @Nullable String sqlState) {
        this(errorCode, templateText, sqlState, -1);
    }

    private DefaultMessageTemplate(int errorCode, String templateText, @Nullable String sqlState, int parameterCount) {
        assert (parameterCount >= -1) : "parameterCount must be greater than or equal to -1";
        this.errorCode = errorCode;
        this.templateText = Objects.requireNonNull(templateText, "templateText");
        this.sqlState = sqlState != null ? MessageTemplate.validateSqlState(sqlState) : null;
        this.parameterCount = parameterCount;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public @Nullable String sqlState() {
        return this.sqlState;
    }

    String templateText() {
        return this.templateText;
    }

    int parameterCount() {
        if (this.parameterCount != -1) {
            return this.parameterCount;
        }
        this.parameterCount = this.getParamCountInternal();
        return this.parameterCount;
    }

    private int getParamCountInternal() {
        int maxIndex = -1;
        Matcher matcher = this.createParameterMatcher();
        while (matcher.find()) {
            int parameterIndex = Integer.parseInt(matcher.group(1));
            maxIndex = Math.max(maxIndex, parameterIndex);
        }
        return maxIndex + 1;
    }

    @Override
    public MessageTemplate withDefaultSqlState(String defaultSqlState) {
        if (this.sqlState != null) {
            return this;
        }
        return this.withSqlState(defaultSqlState);
    }

    @Override
    public MessageTemplate withSqlState(String sqlState) {
        if (Objects.requireNonNull(sqlState, "sqlState").equals(this.sqlState)) {
            return this;
        }
        return new OverriddenSqlStateMessageTemplate(this, sqlState);
    }

    private Matcher createParameterMatcher() {
        return MESSAGE_PARAM_PATTERN.matcher(this.templateText);
    }

    @Override
    public void appendMessage(StringBuilder messageBuffer, List<? extends @Nullable Object> parameters) {
        int templateParameterCount = this.parameterCount();
        int actualParameterCount = parameters.size();
        messageBuffer.ensureCapacity(messageBuffer.length() + this.estimateBufferCapacity(Math.max(templateParameterCount, actualParameterCount)));
        Matcher matcher = this.createParameterMatcher();
        while (matcher.find()) {
            int paramIndex = Integer.parseInt(matcher.group(1));
            Object object = paramIndex < actualParameterCount ? parameters.get(paramIndex) : null;
            matcher.appendReplacement(messageBuffer, "");
            messageBuffer.append(object != null ? object : "(null)");
        }
        matcher.appendTail(messageBuffer);
        if (this.errorCode != 335545016 && actualParameterCount > templateParameterCount) {
            for (Object object : parameters.subList(templateParameterCount, actualParameterCount)) {
                messageBuffer.append("; ").append(object != null ? object : "(null)");
            }
        }
    }

    private int estimateBufferCapacity(int parameterSize) {
        return this.templateText.length() + parameterSize * 20;
    }

    static MessageTemplate notFound(int errorCode) {
        return new DefaultMessageTemplate(errorCode, "No message for code " + errorCode + " found.", null, 0);
    }
}

