/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.AsPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.ToPrimitiveBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=AsPrimitiveNode.class)
final class AsPrimitiveNodeGen {
    private static final InlineSupport.StateField FOREIGN_OBJECT_AS_PRIMITIVE_NODE_FOREIGN_OBJECT_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ForeignObjectData.lookup_(), (String)"foreignObject_state_0_");
    private static final InlinedBranchProfile INLINED_FOREIGN_OBJECT_ERROR_BRANCH_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FOREIGN_OBJECT_AS_PRIMITIVE_NODE_FOREIGN_OBJECT_STATE_0_UPDATER.subUpdater(0, 1)}));
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    AsPrimitiveNodeGen() {
    }

    @NeverDefault
    public static AsPrimitiveNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static AsPrimitiveNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=16, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=AsPrimitiveNode.class)
    @DenyReplace
    private static final class Uncached
    extends AsPrimitiveNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Node arg0Value, Object arg1Value, JSToPrimitiveNode.Hint arg2Value) {
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger)arg1Value;
                return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
            }
            if (JSTypesGen.isImplicitDouble(arg1Value)) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(arg1Value);
                return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (Boolean)arg1Value;
                return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString)arg1Value;
                return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol)arg1Value;
                return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt)arg1Value;
                return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
            }
            if (JSGuards.isJSNull(arg1Value)) {
                return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
            }
            if (JSGuards.isUndefined(arg1Value)) {
                return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject)((Object)arg1Value);
                return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
            }
            if (JSGuards.isForeignObject(arg1Value)) {
                return AsPrimitiveNode.doForeignObject(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached(), TruffleString.SwitchEncodingNode.getUncached());
            }
            return this.doFallback(arg1Value, arg2Value, this);
        }
    }

    @GeneratedBy(value=AsPrimitiveNode.class)
    @DenyReplace
    private static final class Inlined
    extends AsPrimitiveNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;
        private final InlineSupport.ReferenceField<ForeignObjectData> foreignObject_cache;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(AsPrimitiveNode.class));
            this.state_0_ = target.getState(0, 16);
            this.foreignObject_cache = target.getReference(1, ForeignObjectData.class);
        }

        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, JSToPrimitiveNode.Hint arg2Value) {
            if ((state_0 & 4) == 0 && arg1Value instanceof Long) {
                return false;
            }
            if (((state_0 & 8) == 0 || (state_0 & 0xE000) != 57344) && JSTypesGen.isImplicitDouble(arg1Value)) {
                return false;
            }
            if ((state_0 & 0x10) == 0 && arg1Value instanceof Boolean) {
                return false;
            }
            if ((state_0 & 0x20) == 0 && arg1Value instanceof TruffleString) {
                return false;
            }
            if ((state_0 & 0x40) == 0 && arg1Value instanceof Symbol) {
                return false;
            }
            if ((state_0 & 0x80) == 0 && arg1Value instanceof BigInt) {
                return false;
            }
            if ((state_0 & 0x100) == 0 && JSGuards.isJSNull(arg1Value)) {
                return false;
            }
            if ((state_0 & 0x200) == 0 && JSGuards.isUndefined(arg1Value)) {
                return false;
            }
            if ((state_0 & 0x400) == 0 && arg1Value instanceof JSObject) {
                return false;
            }
            return (state_0 & 0x800) != 0 || !JSGuards.isForeignObject(arg1Value);
        }

        @Override
        public Object execute(Node arg0Value, Object arg1Value, JSToPrimitiveNode.Hint arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0x1FFF) != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof SafeInteger) {
                    SafeInteger arg1Value_ = (SafeInteger)arg1Value;
                    return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
                }
                if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE000) >>> 13, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0xE000) >>> 13, arg1Value);
                    return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x10) != 0 && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (Boolean)arg1Value;
                    return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x20) != 0 && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString)arg1Value;
                    return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x40) != 0 && arg1Value instanceof Symbol) {
                    Symbol arg1Value_ = (Symbol)arg1Value;
                    return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x80) != 0 && arg1Value instanceof BigInt) {
                    BigInt arg1Value_ = (BigInt)arg1Value;
                    return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x300) != 0) {
                    if ((state_0 & 0x100) != 0 && JSGuards.isJSNull(arg1Value)) {
                        return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
                    }
                    if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(arg1Value)) {
                        return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0x400) != 0 && arg1Value instanceof JSObject) {
                    JSObject arg1Value_ = (JSObject)((Object)arg1Value);
                    return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
                }
                if ((state_0 & 0x1800) != 0) {
                    ForeignObjectData s11_;
                    if ((state_0 & 0x800) != 0 && (s11_ = (ForeignObjectData)((Object)this.foreignObject_cache.get(arg0Value))) != null && JSGuards.isForeignObject(arg1Value)) {
                        return AsPrimitiveNode.doForeignObject(s11_, arg1Value, arg2Value, s11_.interop_, INLINED_FOREIGN_OBJECT_ERROR_BRANCH_, s11_.switchEncoding_);
                    }
                    if ((state_0 & 0x1000) != 0) {
                        Node node__ = arg0Value;
                        if (this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                            return this.doFallback(arg1Value, arg2Value, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Node arg0Value, Object arg1Value, JSToPrimitiveNode.Hint arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 4);
                return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value);
            if (doubleCast1 != 0) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                state_0 |= doubleCast1 << 13;
                this.state_0_.set(arg0Value, state_0 |= 8);
                return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (Boolean)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x10);
                return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x20);
                return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x40);
                return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x80);
                return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
            }
            if (JSGuards.isJSNull(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 0x100);
                return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
            }
            if (JSGuards.isUndefined(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 0x200);
                return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject)((Object)arg1Value);
                this.state_0_.set(arg0Value, state_0 |= 0x400);
                return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
            }
            if (JSGuards.isForeignObject(arg1Value)) {
                ForeignObjectData s11_ = (ForeignObjectData)arg0Value.insert((Node)new ForeignObjectData());
                InteropLibrary interop__ = (InteropLibrary)s11_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s11_.interop_ = interop__;
                TruffleString.SwitchEncodingNode switchEncoding__ = (TruffleString.SwitchEncodingNode)s11_.insert((Node)TruffleString.SwitchEncodingNode.create());
                Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s11_.switchEncoding_ = switchEncoding__;
                VarHandle.storeStoreFence();
                this.foreignObject_cache.set(arg0Value, (Object)s11_);
                this.state_0_.set(arg0Value, state_0 |= 0x800);
                return AsPrimitiveNode.doForeignObject(s11_, arg1Value, arg2Value, interop__, INLINED_FOREIGN_OBJECT_ERROR_BRANCH_, switchEncoding__);
            }
            Node node__ = null;
            node__ = arg0Value;
            this.state_0_.set(arg0Value, state_0 |= 0x1000);
            return this.doFallback(arg1Value, arg2Value, node__);
        }
    }

    @GeneratedBy(value=AsPrimitiveNode.class)
    @DenyReplace
    private static final class ForeignObjectData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int foreignObject_state_0_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        TruffleString.SwitchEncodingNode switchEncoding_;

        ForeignObjectData() {
        }

        private static MethodHandles.Lookup lookup_() {
            return MethodHandles.lookup();
        }
    }
}

