/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.OS;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SolrPaths {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Path ALL_PATH = Paths.get("_ALL_", new String[0]);
    private static final Set<Path> ALL_PATHS = Collections.singleton(ALL_PATH);

    private SolrPaths() {
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + File.separator : path;
    }

    public static void assertPathAllowed(Path pathToAssert, Set<Path> allowPaths) throws SolrException {
        if (ALL_PATHS.equals(allowPaths)) {
            return;
        }
        if (pathToAssert == null) {
            return;
        }
        SolrPaths.assertNotUnc(pathToAssert);
        Path path = Path.of(pathToAssert.toString(), new String[0]).normalize();
        SolrPaths.assertNoPathTraversal(path);
        if (!path.isAbsolute()) {
            return;
        }
        if (allowPaths.stream().noneMatch(p -> path.startsWith(Path.of(p.toString(), new String[0])))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + String.valueOf(path) + " must be relative to SOLR_HOME, SOLR_DATA_HOME coreRootDirectory. Set system property 'solr.allowPaths' to add other allowed paths.");
        }
    }

    public static void assertNoPathTraversal(Path pathToAssert) {
        if (pathToAssert.toString().contains("..")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + String.valueOf(pathToAssert) + " disallowed due to path traversal..");
        }
    }

    public static void assertNotUnc(Path pathToAssert) {
        if (OS.isFamilyWindows() && pathToAssert.toString().startsWith("\\\\")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + String.valueOf(pathToAssert) + " disallowed. UNC paths not supported.");
        }
    }

    public static class AllowPathBuilder {
        private static final String WILDCARD_PATH = "*";
        private Set<Path> paths;

        public AllowPathBuilder addPath(String path) {
            if (path.equals(WILDCARD_PATH)) {
                this.paths = ALL_PATHS;
            } else {
                this.addPath(Paths.get(path, new String[0]));
            }
            return this;
        }

        public AllowPathBuilder addPath(Path path) {
            if (path == null) {
                return this;
            }
            if (this.paths != ALL_PATHS) {
                if (path.equals(ALL_PATH)) {
                    this.paths = ALL_PATHS;
                } else {
                    if (this.paths == null) {
                        this.paths = new HashSet<Path>();
                    }
                    this.paths.add(path.normalize());
                }
            }
            return this;
        }

        public Set<Path> build() {
            return this.paths == null ? Collections.emptySet() : this.paths;
        }
    }
}

