/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingStatement;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;

public final class DelegatingResultSet
extends AbandonedTrace
implements ResultSet {
    private final ResultSet resultSet;
    private Statement statement;
    private Connection connection;

    public static ResultSet wrapResultSet(Connection connection, ResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        return new DelegatingResultSet(connection, resultSet);
    }

    public static ResultSet wrapResultSet(Statement statement, ResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        return new DelegatingResultSet(statement, resultSet);
    }

    private DelegatingResultSet(Connection connection, ResultSet resultSet) {
        super((AbandonedTrace)((Object)connection));
        this.connection = connection;
        this.resultSet = resultSet;
    }

    private DelegatingResultSet(Statement statement, ResultSet resultSet) {
        super((AbandonedTrace)((Object)statement));
        this.statement = statement;
        this.resultSet = resultSet;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        try {
            return this.resultSet.absolute(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.resultSet.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.resultSet.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.statement != null) {
                this.removeThisTrace(this.statement);
                this.statement = null;
            }
            if (this.connection != null) {
                this.removeThisTrace(this.connection);
                this.connection = null;
            }
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.resultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try {
            return this.resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            return this.resultSet.getArray(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        try {
            return this.resultSet.getArray(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this.resultSet.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.resultSet.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.resultSet.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.resultSet.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.resultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this.resultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this.resultSet.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.resultSet.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            return this.resultSet.getBlob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            return this.resultSet.getBlob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.resultSet.getBoolean(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.resultSet.getBoolean(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        try {
            return this.resultSet.getByte(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        try {
            return this.resultSet.getByte(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.resultSet.getBytes(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.resultSet.getBytes(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return this.resultSet.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.resultSet.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            return this.resultSet.getClob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            return this.resultSet.getClob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.resultSet.getConcurrency();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this.resultSet.getCursorName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        try {
            return this.resultSet.getDate(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        try {
            return this.resultSet.getDate(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public ResultSet getDelegate() {
        return this.resultSet;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        try {
            return this.resultSet.getDouble(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        try {
            return this.resultSet.getDouble(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.resultSet.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.resultSet.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        try {
            return this.resultSet.getFloat(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        try {
            return this.resultSet.getFloat(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.resultSet.getHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public ResultSet getInnermostDelegate() {
        ResultSet resultSet = this.resultSet;
        while (resultSet instanceof DelegatingResultSet) {
            if (this != (resultSet = ((DelegatingResultSet)resultSet).getDelegate())) continue;
            return null;
        }
        return resultSet;
    }

    @Override
    public int getInt(int n) throws SQLException {
        try {
            return this.resultSet.getInt(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        try {
            return this.resultSet.getInt(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        try {
            return this.resultSet.getLong(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        try {
            return this.resultSet.getLong(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        try {
            return this.resultSet.getNCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        try {
            return this.resultSet.getNCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        try {
            return this.resultSet.getNClob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        try {
            return this.resultSet.getNClob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public String getNString(int n) throws SQLException {
        try {
            return this.resultSet.getNString(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public String getNString(String string) throws SQLException {
        try {
            return this.resultSet.getNString(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            return this.resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            return Jdbc41Bridge.getObject(this.resultSet, n, clazz);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.resultSet.getObject(n, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        try {
            return this.resultSet.getObject(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        try {
            return Jdbc41Bridge.getObject(this.resultSet, string, clazz);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.resultSet.getObject(string, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        try {
            return this.resultSet.getRef(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        try {
            return this.resultSet.getRef(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        try {
            return this.resultSet.getRowId(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        try {
            return this.resultSet.getRowId(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        try {
            return this.resultSet.getShort(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        try {
            return this.resultSet.getShort(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        try {
            return this.resultSet.getSQLXML(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        try {
            return this.resultSet.getSQLXML(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            return this.resultSet.getString(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        try {
            return this.resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            return this.resultSet.getTime(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        try {
            return this.resultSet.getTime(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.resultSet.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.resultSet.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.resultSet.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this.resultSet.getType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this.resultSet.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.resultSet.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        try {
            return this.resultSet.getURL(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        try {
            return this.resultSet.getURL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.resultSet.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this.statement instanceof DelegatingStatement) {
            ((DelegatingStatement)this.statement).handleException(sQLException);
        } else if (this.connection instanceof DelegatingConnection) {
            ((DelegatingConnection)this.connection).handleException(sQLException);
        } else {
            throw sQLException;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.resultSet.insertRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.resultSet.isClosed();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this.resultSet.isFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (clazz.isAssignableFrom(this.resultSet.getClass())) {
            return true;
        }
        return this.resultSet.isWrapperFor(clazz);
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this.resultSet.last();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.resultSet.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.resultSet.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            return this.resultSet.previous();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.resultSet.refreshRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        try {
            return this.resultSet.relative(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this.resultSet.rowDeleted();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this.resultSet.rowInserted();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this.resultSet.rowUpdated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            this.resultSet.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            this.resultSet.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized String toString() {
        return super.toString() + "[resultSet=" + this.resultSet + ", statement=" + this.statement + ", connection=" + this.connection + "]";
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.resultSet.getClass())) {
            return clazz.cast(this.resultSet);
        }
        return this.resultSet.unwrap(clazz);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        try {
            this.resultSet.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.resultSet.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateAsciiStream(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.resultSet.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.resultSet.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateBinaryStream(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this.resultSet.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.resultSet.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        try {
            this.resultSet.updateBlob(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        try {
            this.resultSet.updateBlob(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.resultSet.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.resultSet.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        try {
            this.resultSet.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        try {
            this.resultSet.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.resultSet.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.resultSet.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(string, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateCharacterStream(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this.resultSet.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        try {
            this.resultSet.updateClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.resultSet.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        try {
            this.resultSet.updateClob(string, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateClob(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.resultSet.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        try {
            this.resultSet.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.resultSet.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        try {
            this.resultSet.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        try {
            this.resultSet.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        try {
            this.resultSet.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.resultSet.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        try {
            this.resultSet.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        try {
            this.resultSet.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        try {
            this.resultSet.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        try {
            this.resultSet.updateNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        try {
            this.resultSet.updateNCharacterStream(string, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateNCharacterStream(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        try {
            this.resultSet.updateNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        try {
            this.resultSet.updateNClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        try {
            this.resultSet.updateNClob(string, nClob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        try {
            this.resultSet.updateNClob(string, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        try {
            this.resultSet.updateNClob(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        try {
            this.resultSet.updateNString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        try {
            this.resultSet.updateNString(string, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNull(int n) throws SQLException {
        try {
            this.resultSet.updateNull(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        try {
            this.resultSet.updateNull(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        try {
            this.resultSet.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.resultSet.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            this.resultSet.updateObject(n, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            this.resultSet.updateObject(n, object, sQLType, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        try {
            this.resultSet.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this.resultSet.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        try {
            this.resultSet.updateObject(string, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        try {
            this.resultSet.updateObject(string, object, sQLType, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this.resultSet.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.resultSet.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.resultSet.updateRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        try {
            this.resultSet.updateRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        try {
            this.resultSet.updateRowId(string, rowId);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        try {
            this.resultSet.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        try {
            this.resultSet.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        try {
            this.resultSet.updateSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        try {
            this.resultSet.updateSQLXML(string, sQLXML);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        try {
            this.resultSet.updateString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        try {
            this.resultSet.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.resultSet.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        try {
            this.resultSet.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.resultSet.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.resultSet.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }
}

