/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering.awt;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.concurrent.locks.ReentrantLock;
import vtk.rendering.vtkComponent;
import vtk.rendering.vtkInteractorForwarder;
import vtk.vtkCamera;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorStyle;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkPanel;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public class vtkPanelComponent
implements vtkComponent<vtkPanel> {
    protected vtkPanel panel = new vtkPanel();
    protected ReentrantLock lock = new ReentrantLock();
    protected vtkGenericRenderWindowInteractor windowInteractor = new vtkGenericRenderWindowInteractor();
    protected vtkInteractorForwarder eventForwarder;

    public vtkPanelComponent() {
        this.windowInteractor.SetRenderWindow(this.panel.GetRenderWindow());
        this.windowInteractor.TimerEventResetsTimerOff();
        this.windowInteractor.SetSize(200, 200);
        this.windowInteractor.ConfigureEvent();
        vtkInteractorStyleTrackballCamera vtkInteractorStyleTrackballCamera2 = new vtkInteractorStyleTrackballCamera();
        this.windowInteractor.SetInteractorStyle(vtkInteractorStyleTrackballCamera2);
        this.eventForwarder = new vtkInteractorForwarder(this);
        this.windowInteractor.AddObserver("CreateTimerEvent", this.eventForwarder, "StartTimer");
        this.windowInteractor.AddObserver("DestroyTimerEvent", this.eventForwarder, "DestroyTimer");
        this.panel.removeKeyListener(this.panel);
        this.panel.removeMouseListener(this.panel);
        this.panel.removeMouseMotionListener(this.panel);
        this.panel.removeMouseWheelListener(this.panel);
        this.panel.addMouseListener(this.eventForwarder);
        this.panel.addMouseMotionListener(this.eventForwarder);
        this.panel.addMouseWheelListener(this.eventForwarder);
        this.panel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                vtkPanelComponent.this.panel.UpdateLight();
            }
        });
    }

    @Override
    public void resetCamera() {
        this.panel.resetCamera();
    }

    @Override
    public void resetCameraClippingRange() {
        this.panel.resetCameraClippingRange();
    }

    @Override
    public vtkCamera getActiveCamera() {
        return this.panel.GetRenderer().GetActiveCamera();
    }

    @Override
    public vtkRenderer getRenderer() {
        return this.panel.GetRenderer();
    }

    @Override
    public vtkRenderWindow getRenderWindow() {
        return this.panel.GetRenderWindow();
    }

    @Override
    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.windowInteractor;
    }

    @Override
    public void setInteractorStyle(vtkInteractorStyle vtkInteractorStyle2) {
        this.getRenderWindowInteractor().SetInteractorStyle(vtkInteractorStyle2);
    }

    @Override
    public void setSize(int n, int n2) {
        this.panel.setSize(n, n2);
        this.getRenderWindowInteractor().SetSize(n, n2);
    }

    @Override
    public vtkPanel getComponent() {
        return this.panel;
    }

    @Override
    public void Delete() {
        this.panel.Delete();
    }

    @Override
    public void Render() {
        this.panel.Render();
    }

    @Override
    public vtkInteractorForwarder getInteractorForwarder() {
        return this.eventForwarder;
    }

    @Override
    public ReentrantLock getVTKLock() {
        return this.lock;
    }
}

