/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.HyphenVsDash;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.PluralsInCompounds;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.Tautology;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.Tree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.languagetool.tools.StringTools;

class WordSeparation {
    private static final String HYPHEN_PARTICIPLES_MESSAGE = "Participles after modifying words are usually written with a hyphen";
    private static final String PHRASAL_VERB_GENERIC_MESSAGE = "Phrasal verbs are spelled with a space";
    private static final NodePattern concatWithPrev = NodePattern.custom((node, match) -> {
        Node num = Objects.requireNonNull(node.prevNode());
        if (num.hasForm("-")) {
            num = num.neighbor(-1);
        }
        String concat = num.lowForm() + node.lowForm();
        if (node.tree().treeSupport().tagToken(concat).hasPos(".*") && node.tree().treeSupport().isAcceptedBySpellchecker(concat)) {
            return match.withCorrector(NodeCorrector.replaceNodes(num, node, concat));
        }
        return match;
    });
    private static final NodePattern secondConjPart = NodePattern.or(NodePattern.N.withDependent("cc", NodePattern.N.directlyBeforeHead()), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("cc"))).withNeighbor(-2, NodePattern.N.noDependents(NodePattern.not(NodePattern.PUNCT).beforeHead()).markAs("Head")).andOr(NodePattern.N.withHead("conj|compound", NodePattern.N.pos("NNP?|IN|JJ.*").alreadyMarkedAs("Head")), EnglishTreePatterns.compound.withPrevSibling(NodePattern.N.alreadyMarkedAs("Head")).withHead(NodePattern.N.withDependent("compound", NodePattern.N.alreadyMarkedAs("Head"))), NodePattern.N.withHead("compound", NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("Head").withHeadRelation("conj"))), NodePattern.N.withHead("obl:npmod", NodePattern.or(NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("Head")), NodePattern.N.withHead("conj", EnglishTreePatterns.compound.alreadyMarkedAs("Head"))))).noDependents(NodePattern.N.afterHead());
    private static final NodePattern secondRangePart = NodePattern.N.directlyAfter(NodePattern.N.form("to").withHeadRelation("case")).withNeighbor(-2, NodePattern.N.markAs("From").withHeadRelation("compound|nmod")).andOr(NodePattern.N.withNeighbor(-2, NodePattern.N.beforeHead()), NodePattern.N.withHead("obl:npmod|compound", NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.withHead("nmod", NodePattern.N.alreadyMarkedAs("From")), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("From"))))));
    private static final NodePattern secondCompoundPart = NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen.directlyAfter(NodePattern.N));
    private static final NodePattern npModWithCompound = NodePattern.N.withHeadRelation("obl:npmod").markAs("Oblnpmod").directlyAfter(NodePattern.or(NodePattern.N.directlyBeforeHead(), NodePattern.N.beforeHead().withNextSibling(NodePattern.N.alreadyMarkedAs("Oblnpmod"))).withHeadRelation("compound").noDependents(".*").andNot(CommonPatterns.capitalizedMiddle)).andNot(CommonPatterns.capitalizedMiddle);
    private static final NodePattern compoundWithCompound = TreeMigration.revise("delete andNot", EnglishTreePatterns.compound.directlyAfter(EnglishTreePatterns.compound.noPos("NNP").directlyBeforeHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.potentialPos("VBG"))));
    private static final NodePattern hyphenateWithPrev = NodePattern.custom((node, match) -> {
        Node prev = Objects.requireNonNull(node.prevNode());
        if (secondConjPart.matches(prev) || secondRangePart.matches(prev)) {
            Node start = prev.neighbor(-2);
            return match.withReportedRange(start.startOffset(), node.endOffset(), node.tree()).withCorrector(NodeCorrector.replaceNodes(start, node, start.form() + "- " + prev.neighbor(-1).form() + " " + prev.form() + "-" + node.form()));
        }
        if (npModWithCompound.matches(prev) || compoundWithCompound.matches(prev)) {
            Node start = prev.neighbor(-1);
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, start.form() + "-" + prev.form() + "-" + node.form()));
        }
        if (secondCompoundPart.matches(prev)) {
            Node start = prev.neighbor(-2);
            match = match.withReportedRange(start.startOffset(), node.endOffset(), node.tree());
        }
        return match.withCorrector(CommonPatterns.hyphenateNeighbors(prev, node));
    });
    private static final NodePattern hyphenateWithPrevLetter = NodePattern.custom((node, match) -> {
        Node prev = Objects.requireNonNull(node.prevNode());
        return concatWithPrev.match(node, match.withCorrector(NodeCorrector.replaceNodes(prev, node, prev.form().toUpperCase(Locale.ROOT) + "-" + node.form())));
    });
    private static final NodePattern realCompound = NodePattern.N.withHead("compound", NodePattern.not(NodePattern.N.withHeadRelation("xcomp")).markAs("Head")).noMatchUntil("Head", EnglishTreePatterns.quotations);
    private static final NodePattern hyphenateWith2Next = NodePattern.custom((first, match) -> {
        Node second = first.neighbor(1);
        Node third = first.neighbor(2);
        return match.withCorrector(NodeCorrector.replaceNodes(first, third, first.form() + "-" + second.form() + "-" + third.form()));
    });
    static final NodePattern doItYourself = NodePattern.N.inFormSequence(0, "do", "it", "yourself");
    private static final NodePattern blackListAdj = NodePattern.N.form("black|white|block|ban|allow");
    private static final NodePattern blackList = NodePattern.N.lemma("list").directlyAfter(blackListAdj);
    private static final NodePattern couldBeImperative = EnglishTreePatterns.possiblyImperativeVB.andNot(CommonPatterns.firstWord.inPhrase(NodePattern.N.withHeadRelation("nsubj.*")));
    static final NodePattern mayBe = NodePattern.N.form("be").markAs("Be").directlyAfter(NodePattern.N.form("may").markAs("May")).andOr(NodePattern.markedNodeMatches("May", CommonPatterns.firstWord).andNot(NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.or(NodePattern.N.pos("VBN"), NodePattern.N.withDependent("advcl"), NodePattern.ROOT.withDependent("case")))).trace("first may"), NodePattern.N.beforeHead().withHead("cop|aux|aux:pass", NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.after("Be")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.before("Be")), NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.pos("VB[PDZ]|MD").andNot(NodePattern.N.alreadyMarkedAs("May")).andNot(NodePattern.N.alreadyMarkedAs("Be")).markAs("CopAux")).noDependents("punct", NodePattern.N.after("Be").before("CopAux")).noDependents("nsubj:outer"), NodePattern.N.withDependent(".*", NodePattern.N.lemma("be").pos("VB[PDZ]|MD").directlyBefore("May")))), NodePattern.N.withHeadRelation("ccomp|parataxis").directlyBefore(CommonPatterns.closingParen), NodePattern.N.withHeadRelation("goeswith").directlyAfterHead());
    private static final String COMPOUND_ADJ_MSG = "Compound adjectives are usually written with a hyphen";
    private static final List<String> phrasalVerbs = WordSet.loadLines("en/words/phrasal_verbs.txt");
    static final NodePattern phrasalVerbAsNoun = NodePattern.N.form("(" + StreamEx.of(phrasalVerbs).map(s -> s.replace(" ", "")).joining((CharSequence)"|") + ")s?");
    private static final Map<String, Set<String>> particle2PhrasalVerb = WordSeparation.verbsByParticle();
    static final NodePattern spacedPhrasalVerbParticle = WordSeparation.spacedPhrasalVerbParticle().trace("spacedPhrasalVerbParticle");
    private static final NodePattern vbYou = NodePattern.N.pos("VB").withHeadRelation("compound|i?obj|obl|amod").directlyBefore(NodePattern.N.form("you")).noPotentialPos("NN.*").andNot(CommonPatterns.hashtag);
    private static final NodePattern familyMember = NodePattern.N.lemma("mother|father|sister|brother").markAs("Mother");
    static final NodePattern hardcodedPhrasalParticle = NodePattern.or(NodePattern.N.inFormSequence(1, "sign|log", "in").directlyBefore(NodePattern.N.lemma("process|attempt")), NodePattern.or(NodePattern.N.inFormSequence(1, "carve", "outs?"), NodePattern.N.inFormSequence(1, "feed", "back?")).withNeighbor(-2, NodePattern.N.pos("DT|PRP\\$")));
    private static final NodePattern allHandsOnDeck = NodePattern.N.inFormSequence(1, "all", "hands", "on", "deck");
    private static final NodePattern simpleToUse = NodePattern.N.form("easy|simple").beforeHead().withHeadRelation("amod").directlyBefore(NodePattern.N.form("to").directlyBefore(NodePattern.N.pos("VB").noDependents("conj")));
    private static final NodePattern atYearsOld = NodePattern.or(NodePattern.N.form("old").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("years"))), NodePattern.N.form("years").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("old")))).andOr(NodePattern.N.withDependent("case", NodePattern.N.form("at")), NodePattern.N.directlyBefore(NodePattern.N.withDependent("case", NodePattern.N.form("at"))));
    private static final NodePattern needsSpaceInsteadOfHyphen = NodePattern.N.noSpaceAround().andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT));
    static final NodePattern nounLikeGerund = NodePattern.N.form("highlighting|provisioning");
    public static final NodePattern afterOne = NodePattern.N.directlyAfter(NodePattern.N.form("one"));
    private static final NodePattern readOnly = NodePattern.N.inFormSequence(1, "read|write", "only");
    static final NodePattern hyphPref = NodePattern.N.form("pre|pro|anti|non|post|ex|half|self|mid|semi|cross|counter|contra|inter|neo|meta");
    private static final String HYPHEN_WORD_MSG = "This word is usually spelled with a hyphen";
    private static final NodePattern mustX = NodePattern.or(NodePattern.N.potentialPos("VBZ?"), NodePattern.N.form("haves")).directlyAfter(NodePattern.N.form("must")).andOr(NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.pos("NN.*").withHeadRelation("compound"), NodePattern.N.pos("VB").withNeighbor(-2, NodePattern.N.lemma("a|the")), NodePattern.N.withNeighbor(-2, EnglishTreePatterns.number.noForm("one").withHeadRelation("nsubj.*")), NodePattern.N.inFormSequence(1, "must", "have").withNeighbor(-2, NodePattern.N.pos("JJ|NNS?").andNot(NodePattern.N.noForm("absolute").withHeadRelation("nsubj|obl")).directlyAfter(NodePattern.N.lemma("a"))), NodePattern.N.withHeadRelation("amod").beforeHead());
    private static final NodePattern nounNotAdj = NodePattern.or(NodePattern.N.pos("NNS?"), NodePattern.N.noPos()).noHeadRelation("acl").andNot(NodePattern.N.beforeHead().withHead("amod|compound|appos|nmod", NodePattern.or(NodePattern.N.pos("NNP?S?"), NodePattern.N.noPos()))).andNot(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("amod|compound")));
    private static final String ONE_WORD_MSG = "This word is normally written as one";
    private static final NodePattern upPossiblePrefix = NodePattern.N.form("up").andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(NodePattern.N.directlyAfterHead()).andNot(NodePattern.N.directlyAfter(NodePattern.N.lemma("head")));
    static final NodePattern soCalled = NodePattern.N.inFormSequence(1, "so", "called");
    private static final NodePattern concatWithPrevWord = NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen).correct(NodeCorrector.concatenate(-2).skipping(CommonPatterns.noSpaceHyphen)), NodePattern.N.correct(NodeCorrector.concatenate(-1)));
    static final NodePattern adjectiveWithNumber = WordSeparation.adjectiveWithNumber();

    WordSeparation() {
    }

    private static Map<String, Set<String>> verbsByParticle() {
        HashMap<String, Set<String>> particle2Verb = new HashMap<String, Set<String>>();
        for (String verb : phrasalVerbs) {
            String[] parts = verb.split(" ");
            particle2Verb.computeIfAbsent(parts[1], __ -> new HashSet()).add(parts[0]);
        }
        return particle2Verb;
    }

    private static NodePattern spacedPhrasalVerbParticle() {
        Pattern form = Pattern.compile("(" + String.join((CharSequence)"|", particle2PhrasalVerb.keySet()) + ")s?");
        return NodePattern.N.form(form.pattern()).directlyAfter(NodePattern.custom(n -> {
            Matcher matcher = form.matcher(n.neighbor(1).lowForm());
            return matcher.matches() && particle2PhrasalVerb.get(matcher.group(1)).contains(n.lowForm());
        }).markAs("Verb"));
    }

    static NodePattern pattern() {
        NodePattern missingHyphen = NodePattern.or(WordSeparation.nYearOld(), WordSeparation.upToDate(), WordSeparation.nFold(), adjectiveWithNumber, WordSeparation.twoDigitNumbers().andNot(NodePattern.N.withHead(NodePattern.or(adjectiveWithNumber, NodePattern.N.directlyBefore(adjectiveWithNumber)))), WordSeparation.modifiedNoun(), WordSeparation.frontModifiedAdjective(), WordSeparation.tailModifiedAdjective(), WordSeparation.modifiedParticiple(), WordSeparation.modifiedVerb(), WordSeparation.verbObjectNoun(), WordSeparation.verbPrepObl(), WordSeparation.commonlyHyphenatedPrefixes(), WordSeparation.partiallyHyphenatedModifier(), WordSeparation.colors(), WordSeparation.directions(), WordSeparation.soCalled(), WordSeparation.zeroDay(), WordSeparation.wordWithParticle(), WordSeparation.thankYou(), WordSeparation.hardcodedHyphenation(), WordSeparation.wordsWithLetters(), WordSeparation.postItNotes(), WordSeparation.motherInLaw(), WordSeparation.fundRaise(), WordSeparation.howTo(), WordSeparation.toDo(), WordSeparation.noGo(), WordSeparation.xYarder(), WordSeparation.addOn(), WordSeparation.sevenEleven(), WordSeparation.mustHaveLike(), WordSeparation.onCampus());
        NodePattern excessiveHyphen = NodePattern.or(WordSeparation.hardCodedExcessiveHyphen(), WordSeparation.lyAdverbLike(), WordSeparation.hyphenToSpace(), WordSeparation.extraCompoundHyphen(), WordSeparation.nowadays(), WordSeparation.www());
        NodePattern extraHyphenOrSpace = NodePattern.or(WordSeparation.excessiveSpace(), WordSeparation.commonlyJoinedCompounds(), WordSeparation.commonlyJoinedPrefixes(), WordSeparation.xWare(), WordSeparation.xFul());
        return NodePattern.or(excessiveHyphen, extraHyphenOrSpace, missingHyphen, WordSeparation.missingSpace(), WordSeparation.phrasalVerbNounConfusion());
    }

    private static NodePattern commonlyJoinedCompounds() {
        Map<String, List<String>> map = Map.of("ground", List.of("work"), "blood", List.of("bath"), "book", List.of("shop", "store"), "web", List.of("site"));
        NodePattern forceDecapitalize = NodePattern.N.formCaseSensitive("Web").and(CommonPatterns.capitalizedMiddle);
        return NodePattern.N.form(map.keySet()).withHead("compound", NodePattern.N.markAs("Head")).and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.alreadyMarkedAs("Head"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).and(NodePattern.custom((w1, match) -> {
            Node w2 = match.getMarkedNode("Head");
            List heads = (List)map.get(w1.lowForm());
            if (w2.lemmaReadings().stream().noneMatch(heads::contains)) {
                return null;
            }
            String concat = w1.lowForm() + w2.lowForm();
            String message = concat.matches("websites?") ? "The standard spelling is now '" + concat + "'" : "'" + concat + "' is usually spelled as one word";
            NodeCorrector corrector = forceDecapitalize.matches(w1) ? NodeCorrector.rawReplace(w1.startOffset(), w2.endOffset(), concat) : NodeCorrector.replaceNodes(w1, w2, concat);
            return match.withCorrector(corrector).withMessage(message);
        }));
    }

    private static NodePattern extraCompoundHyphen() {
        return CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.pos("NNS?").andOr(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod"), NodePattern.N.withDependent("cop")).noLabel(".*").andNot(CommonPatterns.capitalized).markAs("Head")).directlyAfter(CommonPatterns.capitalized.pos("NNP").withHead("compound", NodePattern.N.alreadyMarkedAs("Head")).reportRangeTo("Head")).andNot(NodePattern.N.directlyAfter(hyphPref)).andNot(NodePattern.N.inFormSequence(1, "quick", "-", "fix(es)?")).andNot(NodePattern.N.inFormSequence(1, "server", "-", "side")).andNot(NodePattern.N.inFormSequence(1, "max", "-", "age")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("CPU")).directlyBefore(NodePattern.N.form("(hour|second|year|minute)s?"))).andNot(NodePattern.N.directlyBefore(Tautology.withAbbreviatedCompound)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("co|meta"))).andNot(NodePattern.N.withNeighbor(-2, EnglishTreePatterns.quotations)).andNot(NodePattern.N.withNeighbor(2, EnglishTreePatterns.quotations)).correct(NodeCorrector.replace(" ")).message("Compound nouns usually need no hyphens");
    }

    private static NodePattern commonlyJoinedPrefixes() {
        return NodePattern.N.form("sub|un").and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.markAs("Next").andNot(NodePattern.N.directlyAfterHead()).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)))).andNot(CommonPatterns.capitalized.and(NodePattern.markedNodeMatches("Next", CommonPatterns.capitalized))).noFormCaseSensitive("UN").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.form("sub").directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.lemma("scale|tropical|group|committee|section|contractor|division|standard|continent")))).and(NodePattern.custom((prefix, match) -> {
            Node next = match.getMarkedNode("Next");
            String concat = prefix.lowForm() + next.lowForm();
            if (!next.tree().treeSupport().tagToken(concat).hasPos(".*")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(prefix, next, concat));
        })).message("The prefix '$_-' is usually spelled without spaces or hyphens");
    }

    private static NodePattern partiallyHyphenatedModifier() {
        return npModWithCompound.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceAfter().noSpaceBefore()).andNot(NodePattern.N.inFormSequence(0, "architecture", "-", "based")).message("All parts of a compound adjective should be hyphenated").and(hyphenateWithPrev);
    }

    private static NodePattern phrasalVerbNounConfusion() {
        NodePattern nominalPosition = NodePattern.or(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|ccomp|xcomp|advcl").andOr(NodePattern.N.withDependent("nmod:poss|nummod|amod|case"), CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("det"))).andNot(NodePattern.or(NodePattern.N.withDependent("advmod", NodePattern.N.form("ago")), NodePattern.N.withNextSibling(NodePattern.N.form("ago"))).withHead("obl", NodePattern.N.pos("VBG"))).andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("have")).withDependent("nmod:poss", NodePattern.N.form("her"))), EnglishTreePatterns.compound.andNot(CommonPatterns.capitalized).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)), NodePattern.N.withDependent("cop").noDependents("mark", NodePattern.N.form("to").beforeHead()).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj").pos("VB."))).andNot(NodePattern.N.withDependent("conj", NodePattern.N.pos("VB."))));
        NodePattern immediateVerbalPosition = NodePattern.or(NodePattern.N.withDependent("aux.*").andNot(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.withHead("case", NodePattern.N.pos("NN.*")))), EnglishTreePatterns.rootAfterPlease, NodePattern.N.withHeadRelation("ccomp"), NodePattern.N.withHeadRelation("xcomp"), NodePattern.N.withHeadRelation("advcl|csubj").withDependent("mark", NodePattern.N.form("to")).andNot(NodePattern.N.onlyPos("NN").noDependents(NodePattern.N.afterHead())), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("PRP|WP")), NodePattern.N.withDependent("obj", NodePattern.N.noPos("IN")).andNot(NodePattern.N.pos("VBN").withHeadRelation("amod"))).andNot(NodePattern.N.form(".+in").directlyAfter(NodePattern.N.lemma("be").pos("VB[ZPD]"))).noDependents("obj", NodePattern.N.directlyAfterHead().potentialPos("VB.*")).noDependents("compound").andNot(nominalPosition);
        NodePattern verbalPosition = NodePattern.or(immediateVerbalPosition, CommonPatterns.lastChildPhrase.markAs("Start").withHead("conj", CommonPatterns.skipUp("obj", immediateVerbalPosition)).withDependent("i?obj|nsubj.*|obl", NodePattern.N.noPos("IN")).andNot(nominalPosition));
        String particles = String.join((CharSequence)"|", particle2PhrasalVerb.keySet());
        NodePattern signThatIsUp = NodePattern.N.inFormSequence(1, "sign", "up").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("with(out)?")), NodePattern.N.withHead("obj", NodePattern.N.lemma("have")));
        return NodePattern.or(phrasalVerbAsNoun.and(verbalPosition).andNot(CommonPatterns.capitalizedMiddle).message(PHRASAL_VERB_GENERIC_MESSAGE).correct(NodeCorrector.regexReplace("(.+)(" + particles + ")(s?)", "$1$3 $2")), CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.form(particles).markAs("Particle").andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen))).directlyAfter(NodePattern.custom(n -> WordSeparation.hasCompatiblePhrasalVerbLemma(n, n.neighbor(2).lowForm()))).reportEverythingTouched().directlyAfter(verbalPosition).andNot(NodePattern.N.inFormSequence(2, "to", "check", "-", "in")).message("Verbs with '$Particle' are spelled with a space").correct(NodeCorrector.replace(" ")), spacedPhrasalVerbParticle.markAs("Particle").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andOr(NodePattern.markedNodeMatches("Verb", NodePattern.N.withHead("compound|amod", NodePattern.N.noDependents("compound", NodePattern.N.after("Verb")).andNot(NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Verb")).withDependent("amod", NodePattern.N.form("few").before("Verb")))).andNot(NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.withHead("compound:prt", NodePattern.N.pos("VB.?")))).noDependents("i?obj|obl")), NodePattern.N.directlyAfterHead().withHead("nmod|advmod|amod|compound(:prt)?", nominalPosition.noDependents("advmod", NodePattern.N.after("Particle"))), NodePattern.N.directlyAfterHead().withHeadRelation("flat|goeswith").andNot(CommonPatterns.capitalized), NodePattern.N.withHeadRelation("nmod").directlyAfter(NodePattern.N.alreadyMarkedAs("Verb").onlyPos("NNS?")), hardcodedPhrasalParticle, NodePattern.N.beforeHead().withHead("case", NodePattern.N.withHead("nmod", NodePattern.N.alreadyMarkedAs("Verb").noPos("NN.*")))).andNot(NodePattern.markedNodeMatches("Verb", CommonPatterns.capitalizedMiddle)).andNot(signThatIsUp).andNot(NodePattern.N.inFormSequence(1, "call", "back")).andNot(NodePattern.N.inFormSequence(1, "go", "to", "definition")).message("Phrasal verbs used as nouns are spelled with a hyphen or as a single word").andOr(NodePattern.N.inFormSequence(1, "flash", "backs?").and(concatWithPrev), NodePattern.N.inFormSequence(1, "take", "aways?").and(concatWithPrev), NodePattern.N.inFormSequence(1, "feed", "backs?").and(concatWithPrev), NodePattern.N.inFormSequence(1, "look", "outs?").and(concatWithPrev), NodePattern.N.inFormSequence(1, "make", "overs?").and(concatWithPrev), NodePattern.N.inFormSequence(1, "clean|make", "ups?").andOptionally(NodePattern.not(EnglishParameters.VARIANT.withValue("GB.*")).and(concatWithPrev)).andOptionally(NodePattern.not(EnglishParameters.VARIANT.withValue("US|CA")).and(hyphenateWithPrev)), concatWithPrev.and(hyphenateWithPrev))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations));
    }

    private static boolean hasCompatiblePhrasalVerbLemma(Node verb, String particle) {
        Set<String> compatible = particle2PhrasalVerb.get(particle);
        if (compatible == null) {
            return false;
        }
        return verb.tagIndependently().lemmaReadings().stream().anyMatch(compatible::contains);
    }

    private static NodePattern tailModifiedAdjective() {
        return NodePattern.N.inFormSequence(0, "ready", "to").withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|xcomp|amod", NodePattern.not(NodePattern.N.lemma("have").withDependent("obj")).andNot(NodePattern.N.withHeadRelation("obj"))).withNeighbor(2, NodePattern.N.pos("VB").markAs("Verb")).withNeighbor(3, NodePattern.N.pos("NNS?").noPotentialPos("VB")).noDependents(".*", NodePattern.N.beforeHead()).and(hyphenateWith2Next).message(COMPOUND_ADJ_MSG).trace("tailModifiedAdjective");
    }

    private static NodePattern missingSpace() {
        return NodePattern.or(NodePattern.N.form("everyday").withHead("advmod|obl:tmod", NodePattern.or(NodePattern.N.noPos("NN.*").noHeadRelation("amod"), NodePattern.N.withHeadRelation("xcomp|root"))).and(EnglishTreePatterns.typoReplacement("every day")), NodePattern.N.form("macos").directlyBefore(NodePattern.N.form("x").markAs("X")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("X"), "Mac OS X")).message("Did you mean Mac OS X?"), NodePattern.or(NodePattern.N.form("hotdogs?|(high|low)demands?|audioguides?").and(nounNotAdj).correct(NodeCorrector.regexReplace("hotdog", "hot dog")).correct(NodeCorrector.regexReplace("demand", " demand")).correct(NodeCorrector.regexReplace("audioguide", "audio guide")), CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.inFormSequence(1, "hot", "-", "dogs?"), NodePattern.N.inFormSequence(1, "audio", "-", "guides?"), NodePattern.N.inFormSequence(1, "high|low", "-").directlyBefore(NodePattern.N.pos("NN.*").noPos("JJ|VBG").noForm("risers?|code").noHeadRelation("xcomp").andNot(NodePattern.N.withDependent("conj", NodePattern.or(NodePattern.N.form("support"), NodePattern.N.pos("NNS")))).andNot(NodePattern.N.withHead("conj", NodePattern.ROOT.pos("JJ"))).andNot(NodePattern.N.withHeadRelation("advcl|root").withDependent("cop"))).and(node -> !node.tree().treeSupport().tagToken(node.neighbor(-1).lowForm() + "-" + node.neighbor(1).lowForm()).hasPos("NN.*"))).directlyBefore(nounNotAdj).reportEverythingTouched().correct(NodeCorrector.replace(" "))).message("This word as a noun is spelled with a space"), NodePattern.N.form("t?hereto").directlyBefore(NodePattern.N.potentialPos("VBP?").markAs("Verb")).andNot(NodePattern.N.directlyAfterHead()).correct(NodeCorrector.regexReplace("(t?here)to", "$1 to")).message("Did you mean 'to $Verb'?"));
    }

    private static NodePattern modifiedVerb() {
        return NodePattern.or(NodePattern.N.lemma("click|tap|press").directlyAfter(NodePattern.N.form("left|right|mouse|double|single|middle").withHeadRelation("advmod|xcomp|compound|obl:npmod")), NodePattern.N.lemma("check").directlyAfter(NodePattern.N.lemma("double|fact").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("solve").directlyAfter(NodePattern.N.lemma("problem").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("feed").directlyAfter(NodePattern.N.lemma("force").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("launch|land").directlyAfter(NodePattern.N.form("soft").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("review").directlyAfter(NodePattern.N.form("peer").withHeadRelation("advmod|compound|xcomp|root|obl:npmod")), NodePattern.N.lemma("arm").directlyAfter(NodePattern.N.form("strong").withHeadRelation("advmod|xcomp|amod|root|obl:npmod|compound")), NodePattern.N.lemma("build|make").directlyAfter(NodePattern.N.form("custom").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("start").directlyAfter(NodePattern.N.form("jump").andOr(NodePattern.N.withHeadRelation("advmod|obl:npmod|compound"), NodePattern.N.withDependent("advcl", NodePattern.N.directlyAfterHead()))), NodePattern.N.lemma("shame").directlyAfter(NodePattern.N.form("slut").withHeadRelation("advmod|aux|nsubj|compound|obl:npmod")).andNot(NodePattern.N.inFormSequence(0, "shame", "on", "you")), NodePattern.N.lemma("treat").directlyAfter(NodePattern.N.form("ill").withHeadRelation("advmod|compound|obl:npmod")), NodePattern.N.lemma("skate").directlyAfter(NodePattern.N.form("roller").withHeadRelation("advmod|obl:npmod|xcomp|compound|aux|nsubj")), NodePattern.N.lemma("trip(ping)?").directlyAfter(NodePattern.N.form("guilt")).andOr(NodePattern.N.pos("VB.?").noPos("NN"), NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead())), NodePattern.N.lemma("light").directlyAfter(NodePattern.N.form("green").withHeadRelation("advmod|xcomp|compound|obl:npmod")), NodePattern.N.withDependent("advmod|compound|obl:npmod", NodePattern.N.directlyBeforeHead().form("cross")), NodePattern.N.lemma("chain").withDependent(".*", NodePattern.N.form("daisy").directlyBeforeHead()), NodePattern.N.lemma("trade|trading").directlyAfter(NodePattern.N.form("day").withHeadRelation("advmod|xcomp|compound|nsubj|obl:npmod"))).andOr(EnglishTreePatterns.clause, NodePattern.N.withHead(EnglishTreePatterns.clause).directlyAfterHead(), NodePattern.N.withHeadRelation("xcomp").withNeighbor(-2, NodePattern.or(NodePattern.N.form("to"), NodePattern.N.inFormSequence(1, "let", "['u]s"))), NodePattern.N.potentialPos("VBG").withHeadRelation("acl").withDependent("compound", NodePattern.N.directlyBeforeHead())).andNot(NodePattern.N.potentialPos("VBP?").withDependent("cop")).and(hyphenateWithPrev).and(concatWithPrev).message("Compound verbs are usually spelled with a hyphen");
    }

    private static NodePattern fundRaise() {
        return NodePattern.N.lemma("raise").andOr(NodePattern.N.potentialPos("VB.?").directlyAfter(NodePattern.N.form("fund").withHeadRelation("advmod|compound")), NodePattern.N.withHeadRelation("obj").directlyAfter(EnglishTreePatterns.clause.form("fund"))).and(concatWithPrev).and(hyphenateWithPrev).message("'fund$_' is usually written together or with a hyphen");
    }

    private static NodePattern thankYou() {
        return vbYou.reportEverythingTouched().directlyBefore(hyphenateWithPrev.markAs("You")).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.markedNodeMatches("You", NodePattern.N.directlyBefore(EnglishTreePatterns.quotations))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("You"), m -> List.of("\u201c" + StringTools.uppercaseFirstChar((String)m.anchor().lowForm()) + " You\u201d"))).message("If '$_ $You' is used as an adjective or a noun, a hyphen or quotes should be added");
    }

    private static NodePattern wordWithParticle() {
        return NodePattern.or(WordSeparation.headsUp(), NodePattern.N.pos("IN").directlyAfterHead().withHead("compound(:prt)?|case", NodePattern.N.pos("NN|VBN|JJ").withHeadRelation("amod|compound|acl").beforeHead().andNot(CommonPatterns.capitalizedMiddle).andNot(couldBeImperative).andNot(CommonPatterns.firstWord.withHead(NodePattern.ROOT))).andOr(NodePattern.custom(n -> WordSeparation.hasCompatiblePhrasalVerbLemma(n.neighbor(-1), n.lowForm())), NodePattern.N.inFormSequence(1, "drive", "through|thru"), NodePattern.N.inFormSequence(1, "built", "in"), NodePattern.N.inFormSequence(1, "knock", "on")).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("IN"))).and(hyphenateWithPrev).and(concatWithPrev).trace("wordWithParticle").message(HYPHEN_WORD_MSG), NodePattern.N.inFormSequence(1, "drop", "in").andOr(NodePattern.N.directlyBeforeHead().withHead("case", NodePattern.N.pos("NN").noForm("share|percentage|number").withDependent("det")), NodePattern.N.withHead("compound", EnglishTreePatterns.compound).directlyAfterHead().andNot(NodePattern.N.directlyBefore(NodePattern.N.form("share")))).and(hyphenateWithPrev).message("'drop-in' adjective is usually spelled with a hyphen"), NodePattern.N.inFormSequence(1, "run", "on").directlyBeforeHead().withHead("case", NodePattern.N.pos("NNS?")).withNeighbor(-2, NodePattern.N.withHeadRelation("det|nmod:poss")).and(hyphenateWithPrev).message("'run-on' adjective is usually spelled with a hyphen"), NodePattern.N.inFormSequence(1, "laid", "back").withHeadRelation("advmod").directlyAfterHead().and(hyphenateWithPrev).message("'laid-back' (relaxed) is spelled with a hyphen"), NodePattern.N.inFormSequence(1, "runners?", "ups?").andOr(NodePattern.N.withHeadRelation("compound:prt"), NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.withHead("advmod", NodePattern.N.pos("NNS")).directlyAfterHead()).message("'runner-up' is spelled with a hyphen").and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "knees", "ups?").andOr(NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.withNeighbor(-2, NodePattern.N.withHeadRelation("det"))).message("'knees-up' (party) is spelled with a hyphen").and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "one", "offs?").directlyAfter(EnglishTreePatterns.compound).message("'one-off' is spelled with a hyphen").and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "on|off", "ramps?").withDependent("compound|case", NodePattern.N.beforeHead()).message(HYPHEN_WORD_MSG).and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "off", "key").withDependent("case", NodePattern.N.directlyBeforeHead().andNot(NodePattern.N.withPrevSibling(EnglishTreePatterns.compound))).message("'off-key' adjective or adverb is spelled with a hyphen").and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "do", "overs?").withDependent("compound", NodePattern.N.directlyBeforeHead()).and(hyphenateWithPrev).message("The noun 'do-over' is spelled with a hyphen"));
    }

    private static NodePattern headsUp() {
        return NodePattern.N.form("up").withHeadRelation("nmod").directlyAfter(NodePattern.or(NodePattern.N.form("heads").markAs("Heads"), EnglishTreePatterns.apostropheS.directlyAfter(NodePattern.N.form("head").markAs("Heads")))).reportRangeTo("Heads").correct(NodeCorrector.replaceNodes(NodePointer.marked("Heads"), NodePointer.anchor(), "heads-up")).message("Did you mean 'heads-up'?");
    }

    private static NodePattern nFold() {
        return NodePattern.N.formCaseSensitive("fold").includeIntoReport().directlyAfter(CommonPatterns.letterWord.directlyBeforeHead().withHeadRelation("nummod").noDependents().includeIntoReport()).and(concatWithPrev).message("Numbers with 'fold' are usually written as one word");
    }

    private static NodePattern soCalled() {
        return NodePattern.or(soCalled.noHeadRelation("root|parataxis").reportEverythingTouched().and(hyphenateWithPrev), NodePattern.N.form("socalled").andNot(CommonPatterns.capitalizedMiddle).correct(NodeCorrector.replace("so-called"))).message("'so-called' adjective is usually spelled with a hyphen");
    }

    private static NodePattern zeroDay() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "zero", "days?").andOr(NodePattern.N.noHeadRelation("obj|conj|obl|list"), NodePattern.N.noHeadRelation("conj|obl|list").noDependents(NodePattern.N.afterHead().noPos("RP")).withDependent("compound", NodePattern.N.directlyBeforeHead())).reportEverythingTouched().and(hyphenateWithPrev), NodePattern.N.form("zerodays?").correct(NodeCorrector.regexReplace("zero(.*)", "zero-$1"))).message("'zero-day' is usually spelled with a hyphen");
    }

    private static NodePattern postItNotes() {
        return NodePattern.N.inFormSequence(1, "post", "its?").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("notes?")), NodePattern.N.withHeadRelation("obj|obl").directlyAfter(NodePattern.N.withHeadRelation("obj|obl|compound")), NodePattern.N.withNeighbor(-2, NodePattern.N.pos("DT"))).reportEverythingTouched().and(hyphenateWithPrev).message("'post-it' is usually spelled with a hyphen");
    }

    private static NodePattern twoDigitNumbers() {
        return NodePattern.N.form("one|two|three|four|five|six|seven|eight|nine").includeIntoReport().directlyAfter(NodePattern.N.form("twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety").includeIntoReport()).and(hyphenateWithPrev).message("Two-digit numbers are usually written with a hyphen");
    }

    private static NodePattern hardcodedHyphenation() {
        return NodePattern.or(CommonPatterns.plainReplace("well", "being", "well-being"), CommonPatterns.plainReplace("bare", "bones", "bare-bones").withHeadRelation("compound").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("backend"))), CommonPatterns.plainReplace("miami", "dade", "Miami-Dade").withHeadRelation("compound").andNot(NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("College"))), NodePattern.N.inFormSequence(1, "dry", "erase").withHeadRelation("compound").and(hyphenateWithPrev), NodePattern.N.inFormSequence(0, "one|many", "to", "one|many").withHeadRelation("amod|compound").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "back", "and", "forth").withHeadRelation("amod|compound").and(hyphenateWith2Next), NodePattern.N.lemma("pick").directlyAfter(NodePattern.N.form("cherry")).andNot(NodePattern.N.inFormSequence(2, "\\(", "cherry", "picked", "from", "commit")).and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "about", "faces?").withDependent("case|compound|amod", NodePattern.N.directlyBeforeHead()).andOr(NodePattern.N.withDependent("acl:relcl", NodePattern.N.lemma("make|do")), CommonPatterns.skipUp("nmod", NodePattern.N.withHead("obj", NodePattern.N.lemma("make|do"))), NodePattern.not(Articles.nounWithoutDeterminer), NodePattern.N.withHead("nmod", NodePattern.N.noPos().label("ORGANIZATION").withDependent("det", NodePattern.N.beforeHead()))).and(hyphenateWithPrev), readOnly.withHeadRelation("advmod").afterHead().and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "read", "write").and(hyphenateWithPrev), NodePattern.N.inFormSequence(1, "president", "elect").withDependent("compound", NodePattern.N.directlyBeforeHead()).and(hyphenateWithPrev), NodePattern.N.lemma("wisher").withDependent("amod|compound", NodePattern.N.form("well").directlyBeforeHead()).and(hyphenateWithPrev), NodePattern.N.lemma("wish").pos("NNS?").withDependent("amod|compound", NodePattern.N.form("well").directlyBeforeHead()).and(EnglishParameters.VARIANT.withValue("US")).and(hyphenateWithPrev), WordSeparation.allYouCanEat(), WordSeparation.doItYourself(), WordSeparation.bringYourOwnX(), NodePattern.N.inFormSequence(0, "know", "it", "alls?").andOr(NodePattern.N.withNeighbor(2, NodePattern.N.form("alls")), NodePattern.N.pos("NN"), NodePattern.N.withHeadRelation("advcl|acl:relcl|appos")).and(hyphenateWith2Next), NodePattern.N.inFormSequence(1, "know", "alls?").andOr(NodePattern.N.form("alls"), NodePattern.N.directlyAfterHead().withHead(NodePattern.or(NodePattern.N.pos("NN"), NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))), NodePattern.N.directlyAfter(NodePattern.N.pos("NN").beforeHead()), NodePattern.N.directlyBefore(NodePattern.N.pos("NN").noPos("NNS")).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("VB").withDependent("nsubj", NodePattern.N.pos("NNS"))))).and(hyphenateWithPrev), NodePattern.N.lemma("start").directlyAfter(NodePattern.N.form("kick")).andNot(CommonPatterns.capitalizedMiddle).and(hyphenateWithPrev), NodePattern.N.form("lithiumion").withHeadRelation("compound").correct(NodeCorrector.replace("lithium-ion")), NodePattern.not(CommonPatterns.capitalizedMiddle).form("house").directlyAfter(NodePattern.N.form("in")).andNot(NodePattern.N.withHead("obl", NodePattern.N.lemma("leave|live|stay|die|find|place|trap|reside|hide|raise|locate|sleep|settle|lock|meet"))).and(hyphenateWithPrev), NodePattern.N.form("finetun(e[ds]?|ing)").correct(NodeCorrector.regexReplace("finetun", "fine-tun")), NodePattern.N.lemma("tune").directlyAfter(NodePattern.N.lemma("fine")).noPos("NNS?").and(hyphenateWithPrev), NodePattern.N.inFormSequence(0, "end", "of", "line", "characters?").and(hyphenateWith2Next)).message(HYPHEN_WORD_MSG);
    }

    private static NodePattern onCampus() {
        return NodePattern.N.form("(on|off)(campus|demand|board|air)|on(time|call)").withHeadRelation("amod|compound").directlyBeforeHead().correct(NodeCorrector.regexReplace("(on|off)", "$1-")).message(COMPOUND_ADJ_MSG);
    }

    private static NodePattern allYouCanEat() {
        return NodePattern.N.form("all").markAs("All").directlyBefore(NodePattern.or(NodePattern.N.form("in").directlyBefore(NodePattern.N.form("one").andOr(NodePattern.N.withHead("nmod", NodePattern.N.alreadyMarkedAs("All").andOr(NodePattern.N.withHeadRelation("det|compound"), NodePattern.N.withDependent("det"))), NodePattern.N.directlyBeforeHead().directlyBefore(NodePattern.N.pos("NNS"))).reportRangeTo("All").correct(NodeCorrector.replaceNodes(NodePointer.marked("All"), NodePointer.anchor(), "all-in-one"))), NodePattern.N.form("you").directlyBefore(NodePattern.N.form("can").directlyBefore(NodePattern.N.form("eat").directlyBefore(NodePattern.N.pos("NN.*")).reportRangeTo("All").correct(NodeCorrector.replaceNodes(NodePointer.marked("All"), NodePointer.anchor(), "all-you-can-eat"))))));
    }

    private static NodePattern doItYourself() {
        return doItYourself.withNeighbor(2, NodePattern.N.markAs("Y")).andOr(NodePattern.N.withHeadRelation("obj|compound"), NodePattern.N.withDependent("obj|xcomp|advmod", NodePattern.N.pos("NN.*|VBG").after("Y")), NodePattern.N.withDependent("det", NodePattern.N.beforeHead())).and(NodePattern.custom((d, match) -> {
            Node y = match.getMarkedNode("Y");
            return match.withCorrector(NodeCorrector.replaceNodes(d, y, y.form().startsWith("Y") ? "Do-It-Yourself" : "do-it-yourself"));
        }));
    }

    private static NodePattern bringYourOwnX() {
        return NodePattern.N.inFormSequence(0, "bring", "your", "own").markAs("Bring").withNeighbor(3, NodePattern.N.pos("NNS?")).withNeighbor(4, NodePattern.N.pos("NNS?")).andOr(NodePattern.N.withDependent("det"), NodePattern.N.withHead("compound", NodePattern.N.withDependent("det", NodePattern.N.before("Bring")))).and(NodePattern.custom((node, match) -> {
            Node x = node.neighbor(3);
            return match.withCorrector(NodeCorrector.replaceNodes(node, x, "bring-your-own-" + x.lowForm()));
        }));
    }

    private static NodePattern motherInLaw() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "in", "l[ao]w").withNeighbor(-2, familyMember).noHeadRelation("amod").and(NodePattern.custom((node, match) -> {
            Node x = node.neighbor(-2);
            return match.withCorrector(NodeCorrector.replaceNodes(x, node, x.form() + "-in-law"));
        })), NodePattern.N.inFormSequence(3, "-", "in", "-", "low").withNeighbor(-4, familyMember).correct(NodeCorrector.replace("law"))).message("Did you mean '$Mother-in-law'?");
    }

    private static NodePattern excessiveSpace() {
        NodePattern er = NodePattern.N.form("ers?");
        NodePattern full = NodePattern.N.form("full");
        String beforeJS = "(node|express|next|vue|draft)";
        NodePattern xAside = NodePattern.N.lemma("stand|step|brush|cast|put|set|push|lay|turn|sweep|toss|leave|keep|move|pull|throw|shove|draw");
        NodePattern overX = NodePattern.N.form("over").withHeadRelation("amod|advmod|compound|aux:pass").beforeHead();
        NodePattern notOtherXSide = NodePattern.N.withHead("compound|case", NodePattern.N.alreadyMarkedAs("Side")).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.noSpaceHyphen, NodePattern.N.form("other|same|opposite|different|right|left").withHeadRelation("amod"))));
        return NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(1, "hand", "some|rail|craft").andNot(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(3, "on|from", "the", "one|(an)?other", "hand"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(2, "on|from", "one|(an)?other", "hand"))), NodePattern.N.lemma("write").directlyAfter(NodePattern.N.form("hand").noHeadRelation("obj|nsubj")), NodePattern.N.lemma("hike").directlyAfter(NodePattern.N.form("hitch")), NodePattern.N.form("over").markAs("Over").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("more").withHead("advmod", NodePattern.N.alreadyMarkedAs("Over")))), NodePattern.N.form("out").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("with"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)), NodePattern.or(NodePattern.N.form("saler?s?|some(ly|ness)?|ness"), NodePattern.N.form("meal").withHead(NodePattern.N.pos("NN.*")).directlyBeforeHead()).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("whole"))), NodePattern.or(NodePattern.N.lemma("cast(er|ing)?|master|cam|space"), NodePattern.N.form("toons?")).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("web"))), NodePattern.N.lemma("chair|base|barrow|wright|spin").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("wheel"))), NodePattern.N.lemmaCaseSensitive("yard").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("back|court|vine|grave|ship|lan|junk|dock|barn|farm|church|brick|boat|hal|bone|scrap|lumber|stock|switch|door|ball|steel"))), NodePattern.N.lemma("writer").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("song|screen|type|under|copy|ghost|script|speech|teletype|sky|sign"))), NodePattern.N.form("wide").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("world"))).andNot(NodePattern.N.and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("fund|web")))), NodePattern.N.lemma("worker").markAs("Worker").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("farm|wood|iron|net|metal|field|mine|tele|home|needle|piece|auto|wage|time|non").withHead(NodePattern.N.alreadyMarkedAs("Worker")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("united"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(CommonPatterns.capitalizedMiddle.directlyBefore(CommonPatterns.capitalizedMiddle)))), NodePattern.N.lemma("(wo)?man").markAs("Woman").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("spokes|congress|business|chair|police|bats?|sales|super|sports|council|horse|washer|country|assembly|service|kins|lay|anchor|committee|char|swords|alder|stunt|news(paper)?|fisher|bonds?|club|crafts|needle|fore|church|freed|camera|air|hench|states|cave|yachts|post|marks|towns|lines|ombuds|clergy|space|tribes|trades|handy|frontiers|gentle|noble|mad|sea|infantry|warehouse|gun|booge[yr]|boge?y|fresh").withHead(NodePattern.N.alreadyMarkedAs("Woman")).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.pos("JJ").withHead(NodePattern.N.alreadyMarkedAs("Woman")))).andNot(CommonPatterns.capitalizedMiddle.directlyBefore(CommonPatterns.capitalizedMiddle)))), NodePattern.N.lemmaCaseSensitive("way").markAs("Way").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.or(NodePattern.N.form("path|high|rail|gate|run|sub|hall|drive|road|water|door|air|walk|speed|motor|mid|express|stair|race|head|lee|passage|cause|fair|entry|tram|belt|arch|colou?r|park|taxi|spill|carriage|route|sky|life|side|free|green").withHead("compound", NodePattern.N.alreadyMarkedAs("Way")), NodePattern.N.form("any").withHead("det", NodePattern.N.alreadyMarkedAs("Way").withHeadRelation("obl:tmod|obl:npmod|vocative").noDependents(NodePattern.N.afterHead().noHeadRelation("punct"))), NodePattern.N.formCaseSensitive("Broad"))), NodePattern.N.directlyAfter(NodePattern.N.form("half|mid|alley|side").andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.withDependent("goeswith", NodePattern.N.directlyAfterHead())))), NodePattern.N.lemmaCaseSensitive("dater?|grade(able)?|per|come|load(er)?|set|hold|ward(ly)?|side|right(ness)?|stream|lift(ment)?|take|rise|hill|beat|scale|heaval|state|bring|holstery|land|root|tick|keep|time|roar|town|end|start|surge|holster|turn|shot|swing|link|market|skill(ing)?|tight|wind|stager?|welling|regulation|trend|sell|draft|draught|gradation|cycle|gradable|pity|rate|vote|braid|most|size|on").markAs("Word").andNot(NodePattern.N.directlyAfterHead().noHeadRelation("goeswith")).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, upPossiblePrefix.andOr(NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Word")), NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Word")), NodePattern.N.withDependent("goeswith", NodePattern.N.alreadyMarkedAs("Word"))))), NodePattern.N.form("river|tempo").directlyAfter(upPossiblePrefix), NodePattern.N.form("cover").withHeadRelation("compound").directlyBeforeHead().and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("under"))), NodePattern.or(NodePattern.N.lemma("stand|taker?|graduate|lie|go|ground|mine|water|score|line|pin|estimate|wear|represent|world|side|state(ment)?|cut|writer?|dog|rate|grad|fund|perform|develop(ment)?|privileged|value|tone|sea|utili[sz]e|whelm|current|sign|study|foot|appreciate|explore|weight|belly|pinning|pass|size|growth|carriage|ling|staff|use|power|pay(ment)?|garment|story|gird|employ(ed|ment)|arm|floor|coat|lay|hand|count|tow|class|insure|brush|estimation|nourish|play|cook|nutrition|body|shirt|achieve(r|ment)?|steer|neath|invest(ment)?|sell|dose|predict(ion)?|throw|clothing|mentioned"), NodePattern.N.form("pants|standabl[ey]|mentioned|populat(ed|ion)")).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("under").markAs("Under"))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.form("water").withHead("obl", NodePattern.N.lemma("lay"))).andNot(NodePattern.N.form("(stand|take|lie|mine|pin|state|rate|fund|sign|power|pay|gird|play|cook|dose|sell|line)s?|go(es)?").pos("NNS?")).andNot(NodePattern.N.form("graduate|ground|water|score|wear|side|dog|tone|foot|weight|belly|pass|size|arm|floor|hand|tow|class|brush|body|shirt").pos("VB")).andNot(NodePattern.N.form("current").pos("JJ")).andNot(NodePattern.N.pos("VB").withHead("compound", NodePattern.N.pos("NNS?"))).andNot(NodePattern.N.pos("NNS?").withDependent("nsubj")).andOr(NodePattern.N.withDependent("case", NodePattern.N.before("Under")), NodePattern.not(NodePattern.N.pos("NN").noPos("NNP").withHeadRelation("nmod")).andNot(NodePattern.N.form("development").withHeadRelation("advcl|nmod|obl|root|parataxis"))).andNot(NodePattern.N.pos("VBG").withHeadRelation("advcl")), NodePattern.N.lemma("report|represent").noPos("NNS?").andNot(CommonPatterns.capitalizedMiddle).directlyAfter(NodePattern.N.form("under")), NodePattern.N.form("points?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("touch").withHeadRelation("compound").beforeHead())), NodePattern.N.form("dogs?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("bull").andNot(NodePattern.N.and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("pit")))))), NodePattern.N.potentialLemma("gater?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("tail"))), NodePattern.N.form("tails?").markAs("Tail").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("re|de|cock|en|cur|dove|pig|cat|duck")), CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("white|swallow|wag|yellow|cotton|pin|fan|hard|mock|whip").andOr(EnglishTreePatterns.compound, NodePattern.N.withHead("amod", NodePattern.N.alreadyMarkedAs("Tail").withHeadRelation("compound")), NodePattern.N.withHeadRelation("amod").withNextSibling(NodePattern.N.alreadyMarkedAs("Tail").withHeadRelation("compound")))), NodePattern.N.directlyAfter(NodePattern.N.form("pony|coat"))), NodePattern.N.lemma("do").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("re"))), NodePattern.N.lemma("breaker").markAs("Breaker").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("wind|jaw|back|ground|jail|house|trail|game|stone|heart").withHead(NodePattern.N.alreadyMarkedAs("Breaker"))), NodePattern.N.directlyAfter(NodePattern.N.form("tie|law|strike").withHead(NodePattern.N.alreadyMarkedAs("Breaker")))), NodePattern.N.lemma("break").markAs("Break").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("out|wind|day|jail|house|stone|heart").withHead(NodePattern.N.alreadyMarkedAs("Break"))), NodePattern.N.directlyAfter(NodePattern.N.form("tie").withHead(NodePattern.N.alreadyMarkedAs("Break")))), NodePattern.N.form("breaking(ly)?").markAs("Breaking").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("jaw|house|stone|heart|ice|tie|ship|strike").withHead(NodePattern.N.alreadyMarkedAs("Breaking"))), NodePattern.N.directlyAfter(NodePattern.N.form("ground|back|path").withHead(NodePattern.N.alreadyMarkedAs("Breaking")))), NodePattern.N.lemma("(grand)?((father|mother)(ly)?|son|daughter|child|parent|mom|dad|kid)|family|sister|brother").directlyAfter(NodePattern.N.form("step")), NodePattern.N.lemma("ladder").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("step"))), NodePattern.N.lemma("craft|ship|port|walker|man|faring").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("space"))), NodePattern.N.form("ships?").andNot(CommonPatterns.capitalizedMiddle).noPos("VB[ZP]?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("relation|leader|partner|member|scholar|father|champion|wor|owner|fellow|intern|friend|citizen|entrepreneur|sponsor|hard|flag|apprentice|town|steward|dealer|dictator|censor|mentor|war|craftsman|space|kin|lord|author|reader|workman|disciple|guardian|battle|companion|rider|premier|star|professor|homeowner|court|chairman|sportsman|air|interrelation|assistant|musician|librarian|viewer|survivor|steam|student|king|(bi)?partisan|proprietor|clerkship|governor|gun|lecture|marksman|extern|director|conservator|showman|trustee|horseman|trainee|ruler|editor|mother|head|seaman|comrade|judge|statesman|penman|light|ally|distributor|lady|preceptor|custodian|gamesman|swordsman|salesman|son|listener|controller"))), NodePattern.N.form("times").withHead("obl:tmod", NodePattern.N).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("some"))), NodePattern.N.form("watch(es)?|weeds?").markAs("First").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("smart").withHead("amod|compound", NodePattern.N.alreadyMarkedAs("First")))), NodePattern.N.form("(bow|fall|forest|drop|storm|coat|maker|bird)s?|water|wear|proof").noPos("VBZ?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("rain"))), NodePattern.N.form("sends?").noDependents("i?obj").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("god"))), NodePattern.N.lemma("pass").andNot(CommonPatterns.capitalizedMiddle).noHeadRelation("compound").andNot(NodePattern.N.withHead("advcl", NodePattern.N.noLemma("be"))).markAs("Pass").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("by").andOr(NodePattern.N.withHead("advmod|case|mark|compound|dep|obl:npmod", NodePattern.N.alreadyMarkedAs("Pass")), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Pass"))))), NodePattern.not(CommonPatterns.capitalizedMiddle).lemma("line|rocket|scrap(er|ing)|light|ward|writer?|(lark|jack)(er)?|box|hook|way|walk|scape|bridge|sail|cap|clad|borne?").markAs("First").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.not(CommonPatterns.capitalizedMiddle).form("sky").withHead(NodePattern.N.alreadyMarkedAs("First")))), NodePattern.N.lemma("dive").andNot(NodePattern.N.form("diving").onlyPos("NN")).directlyAfter(NodePattern.N.form("sky")), NodePattern.not(CommonPatterns.capitalizedMiddle).lemma("son|food|side|weed|water|man|bed|port|gull|farer|board|plane|shore|front|scape|craft").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("sea").noDependents("amod|compound", NodePattern.N.beforeHead()))), NodePattern.or(NodePattern.N.lemma("sider?|come|put|liner?|stand|door|let|reach|look|break|fit(ter)?|rage|right|ward(ly)?|go|age|date|set|weigh|sourcer?|law|perform|post|skirt|bound|burst|speak|number|lier?|flow|cry|back|pace|lay|cast|grow|board|do|pour|field(er)?|crop|land(er)?|stretch|strip|live|last|growth|score|run|house|size|build|shine|sole|take|wit|smart|class|sell|play|mode|fall|rider?|rank|doorsman|bid|shoot|flank|performance|gun|maneuver|match|work|gas|group|station|with|compete|going"), NodePattern.N.form("(rageous|landish)(ly|ness)?|ro|standingly|doorsy")).markAs("Second").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("out").andOr(NodePattern.N.withHead("compound|advmod|mark", NodePattern.N.alreadyMarkedAs("Second")), NodePattern.N.withDependent("advcl", NodePattern.N.alreadyMarkedAs("Second").andNot(NodePattern.N.withDependent("obj", NodePattern.N.afterHead()).noDependents(NodePattern.not(NodePattern.N.withHeadRelation("obj")))))))), NodePattern.N.lemma("patient").directlyAfter(NodePattern.N.form("out").noHeadRelation("compound:prt")), NodePattern.N.lemma("all|view|come|look|sea|seer?|night|whelm|sight|head|lap|ly|time|flow|load|haul|turn|lay|throw|take|dose|weight|whelming(ly)?|due|size|write|heat|arch|run|shadow|hear|power|state(ment)?|drive|hang|board|rule|crowd|use|do|estimte|kill|grow|work|lord|watch|cast|tone|lie|draft|charge|land|expression|rate|pay(ment?)|clock(er)?|joy|pass|reach|burden|shoot|price|react(ion)?|bear(er)?|winter|step|lock|populat(e|ion)|coat|spend|simplify|cook|growth|supply|active|blow|zealous(ly)?|age|product(ion)?|stay|fish|print|value|stock|play|sell|simplification|emphasize|buy|expose|dub|cautious(ly)|confident(ly)?|confidence|consume|deliver|exaggerate|protection|prediction|protective(ness)?|complicate|think|estimate|wear|stimulate|engineer|emphasi[sz]e|analy[sz]e|book|dependent|bear|privileged|praise|populate|dramatic|invest|investment|promise|produce|focus|current|precise|comer|harvest|train|hype|speciali[zs]e|stretch|wash|protect|sensitive|sleep|achieve|discount|excite|trust|predict|tolerant|consumption|subscribe|water|staff|category|relay|device").markAs("Second").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.or(overX, NodePattern.ROOT.form("over").withDependent("advcl:relcl", NodePattern.N.alreadyMarkedAs("Second"))))), NodePattern.N.lemma("ride").directlyAfter(overX), NodePattern.N.form("wise").noHeadRelation("amod").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("other"))), NodePattern.N.lemma("walk(er)?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("sleep"))).andNot(CommonPatterns.capitalizedMiddle), NodePattern.N.form("broken(ly)?|felt").markAs("Broken").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("heart").withHead("obl:npmod", NodePattern.N.alreadyMarkedAs("Broken")))), NodePattern.N.inFormSequence(1, "left", "overs?").andOr(NodePattern.N.pos("NNS"), NodePattern.N.withHead("compound:prt|advmod", NodePattern.N.withHeadRelation("amod")).directlyAfterHead()), NodePattern.N.lemma("dream(er|ing)?").markAs("Dream").directlyAfter(NodePattern.N.form("day").andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("day"))).andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Dream")).noDependents())), NodePattern.N.form("hand").withHeadRelation("obl|nmod|root|compound").directlyAfter(NodePattern.N.form("off").directlyBeforeHead()), NodePattern.N.form("time").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("day|night").noDependents().withHeadRelation("compound").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("every|one"))))), NodePattern.N.lemma("feeding").directlyBefore(NodePattern.N.form("breast")), NodePattern.N.lemma("plate|work").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("breast"))), NodePattern.N.form("aches?").noPos("VB.?").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("ear|back|tooth|must|head")), NodePattern.N.directlyAfter(NodePattern.N.form("belly|heart"))), NodePattern.N.form("rolls?").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("pay|bank|blog")), NodePattern.N.directlyAfter(NodePattern.N.form("bed"))), NodePattern.or(NodePattern.N.form("cuts?|dressers?|lines?|pins?|dressing|dos?|brush(es)|balls?|pieces?|streaks?|bands?|cloths?"), NodePattern.N.form("styles?|sprays?|nets?").andNot(EnglishParameters.VARIANT.withValue("US"))).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("hair").andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)))), NodePattern.not(CommonPatterns.capitalizedMiddle).andOr(NodePattern.N.form("grounds?|fields?|wright(ing)?s?|boys?|girls?|houses?|books?|makers?|time|mates?|throughs?|rooms?|things?|groups?|schools?|bills?|pens?"), NodePattern.N.lemma("list")).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("play").beforeHead())), NodePattern.N.form("(intendent|market|star|power|stition|nova|computer|structure|car|yacht|model|store|position|natant|villain|food|group|oxide|script(ion)?|highway|cell|giant|set|user|bug|capacitor|bike|ego(ist)?|delegate|computing|fan|star(dom)?|fluid|continent|imposition|tanker|visee|secret|sonic|block|cluster|string|state|intelligence|moon|glue|ordinate|weapon)s?|stitious|visor[sy]?|man|men|vision|annuation|natural(ly|ness)?|human(ly)?|lative(ly)?|critical(ly)?|fine(ness)?|powered|venience|vention|symmetr(y|ic)|nal(ly)?|cilious(ly|ness)?|strong|normal(ly|ity)?|fluit(y|ies)|high|luminal|heaters?|efficient|max|hero(es)?|famil(y|ies)|majorit(y|ies)|intendenc(y|ies)|numerar(y|ies)|(vis|[sc]ed|impos|charg)(es?|ing|ed|ers?)|conduct(s|ed|ing|ors?|ivity)?|intend(s|ed|ing)?|(heat|cool)(s|ed|ing)|(siz|pos|ven|saturat|annuat)(es?|ed|ing)").andNot(NodePattern.N.inFormSequence(2, "marvel", "super", "heroes")).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("super"))), NodePattern.N.form("fast|massive|powerful|minis?|heroine|soft|spreaders?").directlyAfter(NodePattern.N.form("super")), NodePattern.or(NodePattern.N.lemma("ground|yard|drop|ward|pack(er)?|bone|lash|log|stage|fire|side|link|fill|space|spin|stab(ber)?|beat|flip|breaker|gammon|slash|hand|stretch|stop|plate|lit|field|splash|hoe|slider?|stroker?"), NodePattern.N.form("woods")).markAs("Second").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("back").andOr(NodePattern.N.withHead("advmod|amod|compound", NodePattern.N.alreadyMarkedAs("Second")), NodePattern.N.withDependent("obj|advcl|dep", NodePattern.N.alreadyMarkedAs("Second"))))).andNot(NodePattern.N.inFormSequence(0, "hand", "in", "hand")), NodePattern.N.lemma("track|date").directlyAfter(NodePattern.N.form("back")).directlyBeforeHead(), NodePattern.N.form("doors?").withHeadRelation("amod|advcl|obl").markAs("Doors").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("in|out").withHead("case", NodePattern.N.alreadyMarkedAs("Doors")))), NodePattern.N.lemma("ball(er)?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("foot|basket|base|volley|soft|fast|eye|pin|meat|fire|snow|hand|paint|net|curve|dodge|hair|speed|low|high|kick|gum").beforeHead())), NodePattern.N.form("ball(ing|ed)").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("cannon"))), NodePattern.N.form("balls?").directlyAfter(NodePattern.N.form("puff")), NodePattern.N.form("na").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("gon|wan"))), NodePattern.N.form("no").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("dun"))), NodePattern.N.form("ta").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("got|out"))), NodePattern.N.form("me").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("lem")))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andNot(CommonPatterns.insideQuotes).reportEverythingTouched().message(ONE_WORD_MSG), NodePattern.N.form("more").noHeadRelation("amod|obj").andNot(NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.withHeadRelation("amod"))).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("further"))).message("The adverb 'furthermore' is written as one word"), NodePattern.N.inFormSequence(1, "can", "not").spaceBefore().andNot(NodePattern.N.directlyBefore(NodePattern.N.form("only"))).message("The form 'cannot' is more common"), NodePattern.or(NodePattern.N.form("time").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("mean").andOr(NodePattern.N.withHeadRelation("advmod|nmod"), NodePattern.N.withHead("compound", NodePattern.N.withHeadRelation("obl(:tmod)?"))))), NodePattern.N.form("while").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("mean").pos("JJ")))).message("As an adverb or noun, this word is usually written as one"), NodePattern.N.form("side").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("a"))).andOr(NodePattern.N.withHead("i?obj|xcomp", NodePattern.or(xAside, NodePattern.N.pos("NN.?"))), NodePattern.N.withNeighbor(-2, xAside), NodePattern.N.directlyBefore(NodePattern.N.form("from")).noDependents("case").andNot(NodePattern.N.withHead("obj", NodePattern.N.pos("VB.?"))), NodePattern.N.withHeadRelation("obl:(np|t)mod|advcl")).message("The adverb 'aside' is written as one word"), NodePattern.N.form("sides?").directlyAfter(NodePattern.N.form("a").directlyAfter(NodePattern.N.pos("DT"))).message("The noun 'aside' is written as one word"), mayBe.includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).message("The adverb 'maybe' is written as one word"), NodePattern.N.form("spread|band").noHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?|obj|nmod").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("wide"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("of"))).message("The adjective 'wide$_' is usually written as one word"), WordSeparation.noBodyEtc(), NodePattern.N.form("long").markAs("Long").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("a"))).andOr(CommonPatterns.lastWord, NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("det|advmod|nmod:poss").beforeHead(), NodePattern.N.withHeadRelation("case").noForm("by|in|of|as"), CommonPatterns.comma.andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("amod").beforeHead())).andNot(NodePattern.N.withHead("punct", NodePattern.N.withHead("conj", NodePattern.N.alreadyMarkedAs("Long")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withNextSibling(NodePattern.N.withHead("acl|amod", NodePattern.N.withDependent("amod", NodePattern.N.alreadyMarkedAs("Long")))))), NodePattern.N.withHead("cc", NodePattern.not(NodePattern.N.withHead("conj", NodePattern.N.alreadyMarkedAs("Long")))), NodePattern.N.form("well"), NodePattern.N.pos("DT|VBZ?"), NodePattern.N.pos("PRP.*").noForm("one")))).noHeadRelation("nsubj").message("The preposition or adverb 'along' is usually written as one word"), NodePattern.N.form("going").markAs("Going").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("on").withHead("case|advmod|mark|amod", NodePattern.N.alreadyMarkedAs("Going").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.beforeHead().withHeadRelation("advcl").directlyBefore(NodePattern.N.pos("NNS?")), NodePattern.N.directlyBefore(NodePattern.N.form("correspondence")), NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)))), NodePattern.N.withHeadRelation("goeswith").directlyAfterHead(), NodePattern.N.withHeadRelation("amod").withPrevSibling(NodePattern.N.form("on").withHeadRelation("amod")).beforeHead()).message("The adjective 'ongoing' is usually written as one word"), NodePattern.N.form("n['\u2019`\u2018]t").spaceBefore().directlyAfter(NodePattern.or(NodePattern.N.lemma("be|do|have|must|might|ought|may|need|dare|should").noForm("am"), NodePattern.N.form("wo|sha|ca|ai|[cw]ould"))).message(ONE_WORD_MSG), NodePattern.N.form("able").markAs("Able").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("do").withHead("aux|advmod|cop|obl:npmod|parataxis|compound", NodePattern.N.alreadyMarkedAs("Able").withOnlyDependents(NodePattern.N.beforeHead())))).message("Did you mean the adjective 'doable'?")).and(concatWithPrevWord), blackList.and(CommonPatterns.forceConcatWithPrev).message(ONE_WORD_MSG), WordSeparation.oneSelf(), NodePattern.N.form("for").markAs("For").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("[tw]here").markAs("There"))).andOr(NodePattern.N.withHead("fixed|goeswith", NodePattern.N.alreadyMarkedAs("There")), NodePattern.N.withHead("obl", NodePattern.N.alreadyMarkedAs("There").withOnlyDependents(NodePattern.N.alreadyMarkedAs("For"))), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("There")).withHeadRelation("mark"), NodePattern.N.withHead("mark|case", NodePattern.or(NodePattern.N.pos("VBP?").withNeighbor(-3, NodePattern.N.pos("MD")), NodePattern.N.pos("VBZ"))), NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).and((node, match) -> {
            Node there = match.getMarkedNode("There");
            String replacement = there.lowForm() + "fore";
            return match.withCorrector(NodeCorrector.replaceNodes(there, node, replacement)).withMessage("Did you mean '" + replacement + "'?");
        }), NodePattern.N.form("in").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("linked").markAs("Linked").andNot(CommonPatterns.lowerCase.and(CommonPatterns.insideQuotes)))).andOr(NodePattern.N.withHead("obl|advmod|compound:prt", NodePattern.N.alreadyMarkedAs("Linked")), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("Linked")), NodePattern.N.withDependent("amod|compound", NodePattern.N.alreadyMarkedAs("Linked"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Linked"), NodePointer.anchor(), "LinkedIn")).message("Did you mean 'LinkedIn'?"), NodePattern.N.form("fill?(s|ed|ing)?").andNot(NodePattern.N.withDependent("det", NodePattern.N.beforeHead())).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("full?").markAs("Ful"))).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(match.getMarkedNode("Ful"), node, "ful" + node.lowForm()))).message(ONE_WORD_MSG), NodePattern.or(NodePattern.N.form("\\.?js").and(CommonPatterns.afterSkipping(NodePattern.or(CommonPatterns.dot, CommonPatterns.noSpaceHyphen), NodePattern.N.form(beforeJS).markAs("Node"))), NodePattern.N.form(beforeJS + "js").andNot(CommonPatterns.lowerCase).markAs("Node")).and((node, match) -> {
            Node nodeNode = match.getMarkedNode("Node");
            String replacement = StringTools.uppercaseFirstChar((String)nodeNode.lowForm().replace("js", "")) + ".js";
            return match.withCorrector(NodeCorrector.replaceNodes(nodeNode, node, replacement)).withMessage("Did you mean '" + replacement + "'?");
        }), NodePattern.N.lemma("lift").andOr(NodePattern.N.noPos("NNS?"), NodePattern.or(NodePattern.N.withHeadRelation("root|xcomp"), NodePattern.N.withNeighbor(-3, NodePattern.ROOT.form("let"))).pos("NN").noDependents("det")).directlyAfter(NodePattern.N.form("dead")).and(concatWithPrev).message("The verb 'deadlift' is normally written as one word"), NodePattern.N.form("((mak|giv)(er|ing)|y?er|fare|book)s?|(ful|less)(ly|ness)?|full|m[ae]n|like").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.form("like|full").beforeHead()).and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("law").andNot(NodePattern.N.afterHead()).markAs("Law"))).and((node, match) -> {
            String second = er.matches(node) ? node.lowForm().replace("er", "yer") : (full.matches(node) ? "ful" : node.lowForm());
            return match.withCorrector(NodeCorrector.replaceNodes(match.getMarkedNode("Law"), node, "law" + second)).withMessage("Did you mean 'law" + second + "'?");
        }), NodePattern.N.form("suite?s?").noPos("VBZ").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("law|swim|jump|body|pant|cat|counter|wing|non|snow|play|skin|sun").markAs("First")), NodePattern.N.directlyAfter(NodePattern.N.form("dry").markAs("First"))).and((node, match) -> {
            Node first = match.getMarkedNode("First");
            return match.withCorrector(NodeCorrector.replaceNodes(first, node, first.lowForm() + node.lowForm().replace("e", "")));
        }).message(ONE_WORD_MSG), NodePattern.N.form("stairs?").markAs("Stairs").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("up|down").markAs("Up").andOr(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Stairs")), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Stairs"))).andNot(NodePattern.N.spaceAfter().directlyAfter(NodePattern.custom(n -> WordSeparation.hasCompatiblePhrasalVerbLemma(n, n.neighbor(1).lowForm())))))).and((node, match) -> {
            Node up = match.getMarkedNode("Up");
            return match.withCorrector(NodeCorrector.replaceNodes(up, node, up.lowForm() + "stairs")).withMessage("Did you mean '" + up.lowForm() + "stairs'?");
        }), NodePattern.N.form("fish").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("self").markAs("Self"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Self"), NodePointer.anchor(), "selfish")).message("Did you mean 'selfish'?"), NodePattern.not(CommonPatterns.capitalizedMiddle).lemma("spell(ing)?|take(nly)?|lead|conduct|understand|match|fortune|carriage|place|trust|(represent|interpret|inform)(ation)?|(manage|treat|align)(ment)?|step|read|handle|behave|direct").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("miss?").andNot(EnglishTreePatterns.verbalClause.noHeadRelation("appos")).markAs("Miss"))).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(match.getMarkedNode("Miss"), node, "mis" + node.lowForm()))).message("Did you mean 'mis$_'?"), NodePattern.N.form("sides?").markAs("Side").andOr(NodePattern.or(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, notOtherXSide.form("river|out|in|country|up|down|hill|back|way|grave|broad|wood|fire|pool|mountain|top|track|iron|quay|stream|air|shore")), NodePattern.N.directlyAfter(NodePattern.N.form("off").directlyBeforeHead())).and(concatWithPrevWord).message(ONE_WORD_MSG), CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, notOtherXSide.form("along|road|bed|under|curb|kerb|lake|state|ring|beach|water|on|dock|near|cliff|court|land").markAs("First")).and((node, match) -> {
            Node first = match.getMarkedNode("First");
            return match.withCorrector(NodeCorrector.replaceNodes(first, node, first.lowForm() + "side")).withMessage("Did you mean '" + first.lowForm() + "side'?");
        })), CommonPatterns.capitalized.inFormSequence(2, "we", "are", "developers").inPhrase(NodePattern.N.form("conference|event")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "WeAreDevelopers")).message("The conference is called 'WeAreDevelopers'"), NodePattern.N.form("books?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("mac").markAs("Mac"))).correct(NodeCorrector.regexReplace("book", "MacBook").join(NodeCorrector.removeNodes(NodePointer.marked("Mac"), NodePointer.neighbor(-1)))).message("Did you mean MacBook?"), NodePattern.N.form("less").withHeadRelation("advmod|fixed").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("the").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("never|none").markAs("Never"))))).correct(NodeCorrector.concatenate(NodePointer.marked("Never")).skipping(CommonPatterns.noSpaceHyphen)).and((node, match) -> match.withMessage("The adverb '" + match.getMarkedNode("Never").lowForm() + "theless' is written as one word")), NodePattern.N.form("day").withHead("compound", NodePattern.N.pos("NN.?").markAs("Noun")).directlyAfter(NodePattern.N.form("every").beforeHead().directlyAfter(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Noun")))).and(concatWithPrev).message("Did you mean the adjective 'everyday'?"));
    }

    private static NodePattern oneSelf() {
        return NodePattern.N.form("self|selves").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("i?obj|obl|nmod(:npmod)?|root|fixed"))).directlyAfter(NodePattern.or(NodePattern.N.form("my").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "myself")), NodePattern.N.form("hi[ms]").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "himself")), NodePattern.N.form("hers?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "herself")), NodePattern.N.form("its?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "itself")), NodePattern.N.form("ones?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "oneself")), NodePattern.N.form("ours?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "ourselves")), NodePattern.N.form("them|theirs?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "themselves")), NodePattern.N.form("yours?").correct(NodeCorrector.replace(NodePointer.anchor(), "").join(NodeCorrector.regexReplace(NodePointer.neighbor(1), "(.+)", "your$1"))))).message("Pronouns ending with 'self' are written as one word");
    }

    private static NodePattern noBodyEtc() {
        NodePattern needsAnimateSubject = NodePattern.or(SemCompatibility.needsAnimateSubject, SemCompatibility.needsHumanSubject, SemCompatibility.prefersAnimalSubject, NodePattern.N.lemma("care"));
        NodePattern raisingOrControl = NodePattern.or(Semantics.raisingVerb, NodePattern.N.lemma("need|try|want"));
        NodePattern needsAnimateSubjMisparsedPassive = SemCompatibility.needsAnimateObject.pos("VBN");
        return NodePattern.or(NodePattern.N.form("one|thing").withHeadRelation("nsubj.*|i?obj|obl|nmod|root|flat|goeswith").andNot(NodePattern.N.inFormSequence(0, "one", "of")), NodePattern.N.form("body").andOr(NodePattern.ROOT.withDependent("cop"), NodePattern.N.withHead("nsubj", NodePattern.or(needsAnimateSubject, raisingOrControl.withDependent("xcomp", needsAnimateSubject))), NodePattern.N.withHead("nsubj:pass|obj", SemCompatibility.needsAnimateObject), NodePattern.N.withHead("nsubj", needsAnimateSubjMisparsedPassive.withDependent("cop").and(PassiveToActive.hasPassiveLikeArguments)), NodePattern.N.withHead("nsubj", raisingOrControl.withDependent("xcomp", needsAnimateSubjMisparsedPassive.withDependent("aux:pass"))))).directlyAfter(NodePattern.N.form("any|some|every|no").noHeadRelation("conj").markAs("Det")).noDependents("advmod").andNot(AgreementSet.noOne).message("The pronoun '$Det$_' is written as one word");
    }

    private static NodePattern xWare() {
        NodePattern soft = NodePattern.N.form("soft|hard|mal|firm|ransom|spy|free|middle|share|glass|silver|cook|ad|table|earthen|stone|kitchen|course|dinner|bloat|flat|group|gift|dish|stem|drink|wet|home|scare|china|bar|tin|lacquer|brass|shovel|vapou?r|plastic|granite|crackle|hollow?|wooden|enamel|yellow|willow|luster|jasper|red|sea|tea|clay|cane|gr[ae]y|sponge|metal|cream|delft|treen|iron|slip|censor|crap|stalker|spouse|pay|cyber|rogue");
        NodePattern house = NodePattern.N.form("house");
        NodePattern tupper = NodePattern.N.form("tupper|alien|slack|edg|kit|fire");
        NodePattern bio = NodePattern.N.form("bio|net|lab");
        NodePattern vm = NodePattern.N.form("vm");
        NodePattern v = NodePattern.N.form("v");
        NodePattern under = NodePattern.N.form("under|foot|sports|swim|eye|(wo)?mens|outer|knit");
        NodePattern out = NodePattern.N.form("outs?");
        return NodePattern.N.lemma("[wW]are").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.or(NodePattern.or(soft, house, tupper, bio, vm, under, out).markAs("X"), NodePattern.N.form("m").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, v.markAs("X")))))).and((node, match) -> {
            Node x = match.getMarkedNode("X");
            Object concat = x.lowForm() + node.lowForm();
            if (soft.matches(x)) {
                String singular = x.lowForm() + "ware";
                if (node.hasForm("wares") && !x.tree().treeSupport().isAcceptedBySpellchecker((String)concat) && x.tree().treeSupport().isAcceptedBySpellchecker(singular)) {
                    concat = singular;
                }
            } else if (house.matches(x)) {
                concat = "housewares";
            } else if (tupper.matches(x)) {
                concat = StringTools.uppercaseFirstChar((String)x.lowForm()) + "ware";
            } else if (bio.matches(x)) {
                concat = StringTools.uppercaseFirstChar((String)x.lowForm()) + "Ware";
            } else if (vm.matches(x) || v.matches(x)) {
                concat = "VMware";
            } else if (under.matches(x)) {
                concat = x.lowForm() + "wear";
            } else if (out.matches(x)) {
                concat = x.lowForm() + "wear";
                if (node.hasForm("wares")) {
                    concat = x.lowForm() + "wears";
                }
            }
            return match.withCorrector(NodeCorrector.replaceNodes(x, node, new String[]{concat})).withMessage("Did you mean '" + (String)concat + "'?");
        }).reportEverythingTouched();
    }

    private static NodePattern xFul() {
        NodePattern fully = NodePattern.N.form("full?y");
        NodePattern fulness = NodePattern.N.form("full?ness?");
        NodePattern fuls = NodePattern.N.form("full?s");
        NodePattern beauty = NodePattern.N.form("beauty|plenty|mercy|pity|fancy|bounty|duty");
        return NodePattern.or(NodePattern.N.form("full?(y|ness?)?").markAs("Full").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("(un)?(use|power|wonder|care|meaning|peace|pain|harm|law|success|help|event|grate|faith|aw|colou?r|thought|hope|mind|insight|play|fear|fruit|youth|doubt|joy|cheer|sin|impact|dread|wrong|shame|truth|purpose|right|hate|will?|force|waste|skill?|master|fate|watch|soul|resource|rest|hurt|wish|flavou?r|bliss|health|deceit|art|venge|resent|sorrow|fright|mourn|wist|tear|gain|need|suspecse|prayer|forget|woe|worship|lust|spite|glee|delight|thank|(beaut|plent|merc|pit|fanc|bount|dut)[iy])|(dis)?(respect|grace|taste)").markAs("X").andNot(NodePattern.N.form("will").withHead("aux", CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl")).noDependents("cop|aux|aux:pass", NodePattern.N.before("X")))))).andOr(NodePattern.N.withHead("advmod|obj|xcomp|amod|goeswith", CommonPatterns.skipUp("ccomp", NodePattern.N.alreadyMarkedAs("X"))).noDependents(), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("X")).withHeadRelation("advmod|amod|compound"), NodePattern.N.withDependent("obl:npmod|compound", NodePattern.N.alreadyMarkedAs("X"))), NodePattern.N.form("full?s?").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("hand|mouth|spoon|hope").noDependents("nmod:poss").markAs("X")))).and((node, match) -> {
            String xForm;
            Node x = match.getMarkedNode("X");
            String string = xForm = beauty.matches(x) ? x.lowForm().replace('y', 'i') : x.lowForm();
            String concat = fully.matches(node) ? xForm + "fully" : (fulness.matches(node) ? xForm + "fulness" : (fuls.matches(node) ? xForm + "fuls" : xForm + "ful"));
            return match.withCorrector(NodeCorrector.replaceNodes(x, node, concat)).withMessage("Did you mean '" + concat + "'?");
        });
    }

    private static NodePattern hyphenToSpace() {
        return NodePattern.or(NodePattern.or(CommonPatterns.noSpaceHyphen.inFormSequence(1, "double", "-", "click").reportEverythingTouched().directlyBefore(NodePattern.N.withDependent("det|nmod:poss")).message("'Double click' as a noun is spelled with a space"), CommonPatterns.HYPHEN_NODE.inFormSequence(1, "per", "-", "capita").reportEverythingTouched().message("'per capita' is spelled with a space")).correct(NodeCorrector.replace(" ")), NodePattern.N.form("vi[cs]e").andOr(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(NodePattern.N.form("versa").markAs("Versa"))), NodePattern.N.and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("a").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("versa").markAs("Versa")))))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Versa"), "vice versa")).message("'vise versa' is spelled with a space"));
    }

    private static NodePattern lyAdverbLike() {
        return CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.withHeadRelation("amod").markAs("Head").includeIntoReport()).directlyAfter(NodePattern.N.pos("RB").form("very|.+ly").withHead("advmod", NodePattern.N.alreadyMarkedAs("Head")).markAs("Adv").includeIntoReport()).and(n -> !n.tree().treeSupport().tagToken(n.neighbor(-1).lowForm() + "-" + n.neighbor(1).lowForm()).hasPos(".*")).andNot(NodePattern.N.inFormSequence(1, "very", "-", "large", "-", "scale")).andNot(NodePattern.N.inFormSequence(1, "fully", "-", "featured")).includeIntoReport().correct(NodeCorrector.replace(" ")).andOr(NodePattern.N.form(".+ly").message("Adverbs ending with 'ly' don\u2019t require hyphens"), NodePattern.N.message("The adverb '$Adv' doesn\u2019t require a hyphen"));
    }

    private static NodePattern hardCodedExcessiveHyphen() {
        return CommonPatterns.noSpaceHyphen.andOr(NodePattern.N.inFormSequence(1, "every", "-", "day").directlyBefore(EnglishTreePatterns.compound), NodePattern.N.directlyAfter(blackListAdj).directlyBefore(NodePattern.N.lemma("list")), NodePattern.N.directlyBefore(NodePattern.N.lemma("light(ing)?")).directlyAfter(NodePattern.N.form("high"))).reportEverythingTouched().and(NodePattern.custom((hyphen, match) -> {
            Node prev = Objects.requireNonNull(hyphen.prevNode());
            Node next = Objects.requireNonNull(hyphen.nextNode());
            String concat = prev.hasForm("wal") ? "Walmart" : prev.lowForm() + next.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(prev, next, concat)).withMessage("'" + concat + "' is normally written as one word");
        }));
    }

    private static NodePattern commonlyHyphenatedPrefixes() {
        NodePattern possiblyImperative = NodePattern.or(NodePattern.ROOT.directlyAfter(EnglishTreePatterns.possiblyImperativeVB), NodePattern.N.withHead("conj", NodePattern.N.withHead("obj", EnglishTreePatterns.possiblyImperativeVB)));
        return NodePattern.or(NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|root|amod|flat")).directlyAfter(hyphPref.andNot(NodePattern.N.inFormSequence(0, "non", "compos", "mentis")).andNot(NodePattern.N.inFormSequence(0, "non", "new", "relic")).andNot(NodePattern.N.form("non").directlyBefore(NodePattern.N.noPos())).andNot(NodePattern.N.inFormSequence(1, "blog", "post")).andNot(NodePattern.N.inFormSequence(0, "post", "form")).andNot(NodePattern.N.inFormSequence(3, "more|less", "than", "a", "half")).andOr(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("case|compound|advmod|obl"))).noDependents(NodePattern.N.noHeadRelation("cc|punct|det").beforeHead()), NodePattern.ROOT.withDependent("compound|flat", NodePattern.N.directlyAfterHead())).noLabel(".*").andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.pos("ORD"), CommonPatterns.HYPHEN_NODE))).noFormCaseSensitive("Pro").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.formCaseSensitive("Meta").directlyBefore(NodePattern.N.label("EVENT"))).noHeadRelation("nsubj.*").andNot(NodePattern.N.form("pro").inPhrase(NodePattern.N.lemma("artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate|ranking|tip|trick"))).andNot(NodePattern.N.form("pro").directlyBefore(CommonPatterns.lastWord.form("only"))).andNot(NodePattern.N.inFormSequence(0, "half", "way|less")).andNot(NodePattern.N.inFormSequence(0, "mid", "vowels?|century")).markAs("Prefix")).potentialPos("NNP?S?|JJ.*").noPos("IN").andNot(possiblyImperative).andNot(NodePattern.N.lemma("model|office").directlyAfter(NodePattern.N.form("post"))).andNot(NodePattern.N.formCaseSensitive("Programming").directlyAfter(NodePattern.N.formCaseSensitive("Meta")).directlyBefore(NodePattern.N.formCaseSensitive("System"))).andNot(NodePattern.N.lemma("file|declaration|override|function").directlyAfter(NodePattern.N.form("meta"))), NodePattern.not(CommonPatterns.capitalizedMiddle).form("time").withHeadRelation("compound").directlyAfter(NodePattern.N.form("part").markAs("Prefix")), NodePattern.or(NodePattern.N.pos("CD").withHeadRelation("nummod").beforeHead(), NodePattern.N.form("(\\d\\d)?\\d0s")).directlyAfter(NodePattern.N.form("pre|post|mid").markAs("Prefix"))).and(hyphenateWithPrev).and(concatWithPrev), hyphPref.markAs("Prefix").directlyBefore(NodePattern.N.form("and|or|to").and(CommonPatterns.beforeSkipping(NodePattern.N.pos("DT"), hyphPref.directlyBefore(CommonPatterns.noSpaceHyphen)))).correct(NodeCorrector.insertAfter("-"))).message("Words after '$Prefix' are usually written with a hyphen");
    }

    private static NodePattern directions() {
        NodePattern dir = NodePattern.N.form("(north|south|east|west)(ern|ly|wards?)?").andNot(CommonPatterns.capitalizedMiddle).includeIntoReport();
        return dir.directlyAfter(dir).and(hyphenateWithPrev).and(concatWithPrev).message("Compound directions are usually written with a hyphen");
    }

    private static NodePattern colors() {
        return Semantics.color.andOr(NodePattern.N.withHeadRelation("amod").directlyAfter(NodePattern.or(Semantics.color, NodePattern.N.pos("NN").withHeadRelation("obl.*").directlyBeforeHead(), NodePattern.N.inFormSequence(0, "brick", "red"))), NodePattern.N.directlyAfter(NodePattern.N.form("light|dark|snow").includeIntoReport()).withDependent("cop")).and(hyphenateWithPrev).message("Multi-word colors are usually written with a hyphen");
    }

    private static NodePattern modifiedParticiple() {
        NodePattern misparsedFiniteClause = NodePattern.ROOT.and(NodePattern.markedNodeMatches("Participle", NodePattern.N.potentialPos("VBD")));
        return NodePattern.or(NodePattern.N.withHeadRelation("amod").directlyBeforeHead().potentialPos("VBN").withDependent("amod", NodePattern.N.directlyBeforeHead().andNot(NodePattern.N.onlyPos("RB")).andNot(couldBeImperative).noForm("public|real|mobile|.+nical|under|custom").noPotentialPos("VBD").trace("amod+VBN")), NodePattern.N.beforeHead().markAs("Participle").withHead("amod", NodePattern.or(NodePattern.not(misparsedFiniteClause), NodePattern.N.withDependent("cop"))).potentialPos("VBN").includeIntoReport().directlyAfter(NodePattern.N.markAs("First").beforeHead().noDependents().includeIntoReport().andOr(NodePattern.N.form("well|ill|little|above|below|live|primary|secondary").withHeadRelation("amod|advmod").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("no[tn]"))), NodePattern.N.inFormSequence(0, "much", "needed"), NodePattern.N.inFormSequence(0, "clean", "shave[dn]"), NodePattern.N.form("long|short").withHead("advmod|compound", NodePattern.N.lemma("live|establish")), NodePattern.N.inFormSequence(0, "custom", "built|defined"), NodePattern.N.form("top|bottom|left|right").withHead("advmod|obl:npmod", NodePattern.N.lemma("place|position")), NodePattern.N.withHeadRelation("amod").pos("NN").noPotentialPos("VBG|JJS?").noForm("default").andNot(CommonPatterns.capitalizedMiddle), EnglishTreePatterns.compound.potentialPos("CD"), NodePattern.N.directlyBeforeHead().pos("NN").andOr(EnglishTreePatterns.compound.noForm("custom").andNot(NodePattern.N.potentialPos("VBP?").directlyAfter(NodePattern.N.form("to"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.directlyBefore("First"))), NodePattern.N.withHead("obl:npmod|nummod", NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.withDependent("amod|case|det", NodePattern.N.before("Participle")), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det").beforeHead())))).andNot(EnglishTreePatterns.aBit)), CommonPatterns.capitalizedMiddle.directlyBefore(NodePattern.N.form("born|driven")))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_NODE, EnglishTreePatterns.quotations))).andNot(NodePattern.N.withNeighbor(-2, EnglishTreePatterns.quotations)).noForm("rented").andNot(NodePattern.N.inFormSequence(1, "pun", "intended")).andNot(NodePattern.N.inFormSequence(1, "hand", "written")).trace("VBN after specific word"), NodePattern.N.form("limited").withHeadRelation("amod").directlyAfter(NodePattern.N.beforeHead().withHeadRelation("compound")), NodePattern.N.inFormSequence(1, "even|one|two|right|left|empty|heavy|red|high|single|ham", "handed").withDependent("amod|nummod|advmod", NodePattern.N.directlyBeforeHead()).noDependents("obl.*|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("to|by"))), NodePattern.N.form("based").withDependent("obl:npmod|compound", NodePattern.N.directlyBeforeHead().pos("NNP?")), NodePattern.N.form("shaped").withDependent("advmod|amod", NodePattern.N.directlyBeforeHead().pos("NN")), NodePattern.N.form("made").withDependent("advmod|obl:npmod", NodePattern.N.directlyBeforeHead().potentialPos("NN").noPos("DT")).andOr(NodePattern.N.withDependent("cop|aux:pass").noDependents("xcomp"), NodePattern.N.withHeadRelation("amod")), NodePattern.N.pos("VBG").noPos("NN").includeIntoReport().directlyAfter(NodePattern.N.form("mass").includeIntoReport()), NodePattern.N.form("speaking").withHeadRelation("amod").withDependent("compound", CommonPatterns.capitalized.directlyBeforeHead().label("LANGUAGE")), NodePattern.N.form("fuell?ed").withHeadRelation("amod|conj").directlyAfter(NodePattern.N.pos("NN")), NodePattern.N.form("colou?red").withHeadRelation("amod").directlyBeforeHead().withDependent("amod|obl:npmod", NodePattern.N.directlyBeforeHead().noDependents()), NodePattern.N.lemma("source").pos("VB[NG]").directlyAfter(NodePattern.N.form("open")), NodePattern.N.withHeadRelation("amod").potentialPos("VBG").noDependents(NodePattern.not(NodePattern.N.withHeadRelation("conj")).afterHead()).includeIntoReport().directlyAfter(NodePattern.N.directlyBeforeHead().noDependents().includeIntoReport().andOr(NodePattern.N.form("all|fast|slow").withHeadRelation("advmod"), NodePattern.N.potentialPos("NN").andOr(EnglishTreePatterns.compound.noForm("AI|out"), NodePattern.N.withHead("obl.*", NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.noHeadRelation("nsubj").markAs("Head").withDependent("det", NodePattern.N.markAs("Det"))))).andNot(couldBeImperative).andNot(EnglishTreePatterns.aBit), NodePattern.N.pos("RBR").noForm("more|less"))).andNot(nounLikeGerund).andNot(NodePattern.N.inFormSequence(1, "pattern", "matching")).trace("VBG participle"), NodePattern.N.potentialPos("VBG").potentialPos("JJ").directlyAfter(NodePattern.N.form("high|low").beforeHead()).andOr(NodePattern.N.withHead("amod", NodePattern.N.pos("NNS?")).beforeHead(), NodePattern.N.withDependent("conj", NodePattern.N.pos("NNS?").markAs("Noun")).before("Noun")).trace("high-low VBG")).andNot(CommonPatterns.beforeSlashOrParenth).andNot(blackList).andNot(NodePattern.N.directlyAfter(NodePattern.N.noPos())).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("trough").directlyAfter(NodePattern.N.lemma("go")))).andNot(NodePattern.N.form("paid").directlyAfter(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.pos("VBN").directlyAfter(NodePattern.N.form("common|initial"))).andNot(NodePattern.N.inFormSequence(1, "code", "matching", "verification")).andNot(NodePattern.N.inFormSequence(1, "free", "limited")).andNot(NodePattern.N.inFormSequence(1, "variable", "holding")).andNot(NodePattern.N.inFormSequence(1, "world", "shared")).andNot(NodePattern.N.inFormSequence(1, "book", "printed", "market")).and(hyphenateWithPrev).and(concatWithPrev).message(HYPHEN_PARTICIPLES_MESSAGE).and((node, match) -> match.concedingToOtherGrammarCheckers());
    }

    private static NodePattern modifiedNoun() {
        String compPartRel = "amod|compound|det|case|nummod";
        NodePattern twoWords = NodePattern.or(CommonPatterns.skipConjUp(realCompound), NodePattern.N.withHeadRelation("amod").directlyBeforeHead()).andOr(NodePattern.N.withDependent(compPartRel, NodePattern.N.directlyBeforeHead()), NodePattern.not(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation(compPartRel).withDependent("conj")), NodePattern.N.withDependent(compPartRel, NodePattern.N.withDependent("conj")))).andOr(Semantics.timeUnits.directlyAfter(NodePattern.N.form("single")), NodePattern.N.potentialPos("NN").directlyAfter(NodePattern.N.form("all|high|low|cut|dual|per").andNot(CommonPatterns.capitalizedMiddle).andNot(CommonPatterns.inAllCapitalizedSentence).andNot(NodePattern.N.directlyBefore(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE))).noForm("rpm").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("all")).andNot(NodePattern.N.directlyBeforeHead().andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("NNS"))))).andNot(NodePattern.N.inFormSequence(1, "high", "school|contrast|education|light")).andNot(NodePattern.N.inFormSequence(1, "per", "capita")).andNot(NodePattern.N.inFormSequence(1, "per", "cent|build")).andNot(NodePattern.N.inFormSequence(1, "per", "issue", "type")).andNot(NodePattern.N.inFormSequence(1, "per", "code", "review")).andNot(NodePattern.N.inFormSequence(1, "all", "tool", "windows?")).andNot(NodePattern.N.inFormSequence(1, "dual", "user", "accounts?")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("high|low")).withHead(NodePattern.N.lemma("footprint|value|.*sensitivity|(dis)?satisfaction|deviancy|rate|score|voltage|time|frequency|coverage|usage|requirement|level|limit|output|.+ness|performance|factor"))), NodePattern.N.inFormSequence(1, "left|right|first|second", "hand"), NodePattern.N.inFormSequence(1, "world|first|second|working|upper|middle|low(er)?", "class").andNot(NodePattern.N.directlyBefore(NodePattern.N.onlyPos("VBG").directlyBeforeHead())), NodePattern.N.inFormSequence(1, "late|long|short", "term"), NodePattern.N.inFormSequence(1, "true", "crime"), NodePattern.N.inFormSequence(1, "prime", "time"), NodePattern.N.inFormSequence(1, "write", "protect"), NodePattern.N.inFormSequence(1, "full", "text|screen"), NodePattern.N.inFormSequence(1, "first|second|third", "person"), NodePattern.N.inFormSequence(1, "black|white", "hat"), NodePattern.N.inFormSequence(1, "same|opposite", "sex"), NodePattern.N.inFormSequence(1, "open", "heart|plan"), NodePattern.N.inFormSequence(1, "on|off", "page|screen"), NodePattern.N.inFormSequence(1, "same|full|current|present|whole|modern|multi", "day").andNot(NodePattern.N.withNeighbor(-3, NodePattern.N.form("in"))), NodePattern.N.inFormSequence(1, "red", "light").directlyBefore(NodePattern.N.lemma("area|community|district|street|zone")), NodePattern.N.inFormSequence(1, "near", "death").withHead(NodePattern.N.lemma("experience")), NodePattern.N.form("wheel|duty|edge|look|profit").noDependents("case", NodePattern.N.directlyBeforeHead().directlyAfter(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).andNot(NodePattern.N.formCaseSensitive("Edge")).andNot(NodePattern.N.inFormSequence(0, "edge", "locations?|cases?")).andNot(NodePattern.N.inFormSequence(1, "dark|light", "look")).andNot(NodePattern.N.inFormSequence(1, "mouse", "wheel")), NodePattern.N.pos("NNS").directlyAfter(NodePattern.N.form("all").andNot(CommonPatterns.capitalizedMiddle)).withHead(NodePattern.not(Semantics.allowedCompoundPluralHead)).andNot(Semantics.potentiallyNamedCompoundPlural).andNot(allHandsOnDeck), NodePattern.N.inFormSequence(1, "work", "life").withHead("compound", NodePattern.N.form("balance|conflict")).andNot(CommonPatterns.capitalizedMiddle), NodePattern.N.form("headed").beforeHead(), NodePattern.N.inFormSequence(1, "lithium", "ion")).noLemma("customi[sz]ation").directlyBefore(NodePattern.not(CommonPatterns.slash)).and(hyphenateWithPrev).and((node, match) -> match.concedingToOtherGrammarCheckers());
        NodePattern topDown = NodePattern.or(NodePattern.N.inFormSequence(1, "top", "down"), NodePattern.N.inFormSequence(1, "bottom|push|toss|stand", "up"), NodePattern.N.inFormSequence(1, "mail", "in").directlyBefore(NodePattern.N.lemma("ballot|contest|fraud|giveaway|promotion|rebate|survey|sweepstake|vote|voter|voting")), NodePattern.N.inFormSequence(1, "money", "back"), NodePattern.N.inFormSequence(1, "easy", "going"), NodePattern.N.inFormSequence(1, "hard", "working"), NodePattern.N.inFormSequence(1, "wide", "screen|mouthed"), NodePattern.N.inFormSequence(1, "whole", "hearted(ly)?|grain"), NodePattern.N.inFormSequence(1, "hands", "on").withHead("compound:prt", EnglishTreePatterns.compound), NodePattern.N.inFormSequence(1, "on", "off"), NodePattern.N.inFormSequence(1, "no", "go|fly|fault|haggle").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("away"))), NodePattern.N.inFormSequence(1, "set", "top").withHead("amod|compound", NodePattern.N.lemma("box|decoder|device|player|terminal|TV")), NodePattern.N.formCaseSensitive("app|ear").directlyAfter(NodePattern.N.form("in")).withHead(NodePattern.N.noDependents("amod", NodePattern.N.form("logged"))), NodePattern.N.inFormSequence(1, "stand", "alone"), readOnly, NodePattern.N.form("only").andOr(NodePattern.N.directlyBeforeHead().directlyAfter(EnglishTreePatterns.compound.noDependents("amod", NodePattern.N.directlyBeforeHead())), NodePattern.N.withHead("advmod", EnglishTreePatterns.compound).directlyAfterHead()).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle))).andOr(NodePattern.N.directlyAfterHead().withHead("compound:prt|advmod|compound|obl:npmod", NodePattern.N.beforeHead().withHeadRelation("amod|compound")), NodePattern.N.withHead("amod", NodePattern.N.pos("NN.*")).beforeHead(), NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*"))).and(hyphenateWithPrev).and(concatWithPrev);
        NodePattern oneWordInsertHyphen = NodePattern.N.form("audioguide").withHead("amod|compound", NodePattern.N.pos("NNS?")).beforeHead().correct(NodeCorrector.replace("audio-guide"));
        NodePattern third = NodePattern.not(CommonPatterns.capitalizedMiddle).markAs("Third").withDependent("cc|case|mark", CommonPatterns.letterWord.directlyBeforeHead().directlyAfter("First"));
        NodePattern threeWordsHeadFirst = NodePattern.or(realCompound, NodePattern.N.withHeadRelation("amod|advmod")).andNot(CommonPatterns.capitalizedMiddle).beforeHead().markAs("First").andOr(NodePattern.N.withDependent("conj|nmod|advcl|obl", third), NodePattern.N.withNextSibling(third.beforeHead())).noDependents("nummod").noDependents("amod", NodePattern.N.beforeHead()).noDependents("nmod", NodePattern.N.after("Third")).andOr(NodePattern.N.pos("NN.*").directlyBefore(NodePattern.N.form("to|by|over").withHead("case", NodePattern.N.pos("NN.*").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VBN").withHeadRelation("amod"))).andNot(NodePattern.N.directlyBefore(NodePattern.ROOT)))).noDependents("conj").andNot(NodePattern.N.inFormSequence(0, "long", "by", "wide")), NodePattern.N.inFormSequence(0, "end", "of"), NodePattern.N.inFormSequence(0, "cut", "and", "paste"), NodePattern.N.inFormSequence(0, "down", "and", "out"), NodePattern.N.inFormSequence(0, "do", "or", "die"), NodePattern.N.inFormSequence(0, "make", "or", "break"), NodePattern.N.inFormSequence(0, "mom", "and", "pop"), NodePattern.N.inFormSequence(0, "chicken", "and", "egg"), NodePattern.N.inFormSequence(0, "up", "and", "coming"), NodePattern.N.inFormSequence(0, "head", "to", "head"), NodePattern.N.inFormSequence(0, "soon", "to", "be")).and(hyphenateWith2Next);
        NodePattern threeWordsHeadLast = NodePattern.or(NodePattern.N.withHead("case", NodePattern.N.anyPos().andNot(CommonPatterns.capitalizedMiddle).markAs("Third")).andNot(NodePattern.N.inFormSequence(1, "\\d+", ".*", ".*", "\\d+")).andNot(NodePattern.N.inFormSequence(0, "as|according", "to")).andNot(NodePattern.N.inFormSequence(0, "such", "as")).andNot(NodePattern.N.inFormSequence(0, "out", "of").andOr(NodePattern.N.directlyAfter(EnglishTreePatterns.number), NodePattern.N.withNeighbor(2, NodePattern.N.pos("PRP")), NodePattern.N.inFormSequence(1, ".*", "out", "of", "bounds", "exception"))).andNot(NodePattern.N.inFormSequence(1, "of", "up", "to").withNeighbor(2, NodePattern.N.pos("CD"))).directlyBefore(NodePattern.N.pos("IN")).withNeighbor(2, NodePattern.N.alreadyMarkedAs("Third")).and(NodePattern.markedNodeMatches("Third", NodePattern.or(realCompound, NodePattern.N.withHeadRelation("nmod").directlyBefore(NodePattern.N.pos("NNS?").noPos("CD"))))), NodePattern.or(NodePattern.N.inFormSequence(0, "dog", "eat", "dog"), NodePattern.N.inFormSequence(0, "not", "so|too").withNeighbor(2, NodePattern.N.pos("JJ").noPos("DT"))).withNeighbor(3, NodePattern.N.pos("NN.*").markAs("Head")).inPhrase(NodePattern.N.alreadyMarkedAs("Head"))).and(hyphenateWith2Next);
        NodePattern fourWords = NodePattern.or(NodePattern.or(NodePattern.N.withHeadRelation("compound|[an]mod").beforeHead(), NodePattern.N.withHead(NodePattern.N.withHeadRelation("amod").beforeHead())).andOr(allHandsOnDeck.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(2), "all-hands-on-deck")), NodePattern.N.inFormSequence(0, "state", "of", "the", "art").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(3), "state-of-the-art")), NodePattern.N.inFormSequence(3, "out", "of", "the", "blue|box|way").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-3), node, "out-of-the-" + node.lowForm())))), NodePattern.N.markAs("Start").andOr(NodePattern.N.withHeadRelation("compound|[an]mod").beforeHead(), NodePattern.N.withHeadRelation("obj").withNextSibling(NodePattern.N.withHeadRelation("obj"))).inFormSequence(0, ".*", "out", "of").withNeighbor(3, NodePattern.or(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Start")), NodePattern.N.potentialPos("NNS?").directlyBeforeHead())).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(3), node.form() + "-out-of-" + node.neighbor(3).form()))));
        NodePattern ingNoun = NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").form("making|taking").withDependent("compound", NodePattern.N.directlyBeforeHead()).and(hyphenateWithPrev);
        return NodePattern.or(ingNoun.message("This compound noun is usually written with a hyphen"), NodePattern.or(twoWords.trace("two words"), oneWordInsertHyphen.trace("oneWordInsertHyphen"), topDown.trace("top down"), threeWordsHeadFirst.trace("threeWordsHeadFirst"), threeWordsHeadLast.trace("threeWordsHeadLast"), fourWords.trace("4 words"), simpleToUse.and(hyphenateWith2Next)).message(COMPOUND_ADJ_MSG));
    }

    private static NodePattern verbPrepObl() {
        return NodePattern.N.withHeadRelation("csubj|acl").beforeHead().andOr(NodePattern.N.withDependent("det"), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("det"))).markAs("First").withDependent("obl", NodePattern.or(NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead().markAs("Third")), NodePattern.N.markAs("Third")).withDependent("case", NodePattern.N.directlyBefore("Third").directlyAfter("First"))).potentialPos("VB").andNot(CommonPatterns.insideQuotes).and(hyphenateWith2Next).message(COMPOUND_ADJ_MSG);
    }

    private static NodePattern verbObjectNoun() {
        return NodePattern.N.form("all").andOr(NodePattern.N.directlyBeforeHead().withHeadRelation("det"), NodePattern.N.withHeadRelation("obj").directlyAfterHead()).directlyBefore(NodePattern.N.pos("NN.*").markAs("Head")).directlyAfter(NodePattern.N.potentialPos("VB").withHead("compound", NodePattern.N.alreadyMarkedAs("Head")).andNot(CommonPatterns.capitalizedMiddle).markAs("Verb")).and(hyphenateWithPrev).message("'$Verb-all' compound adjective is usually written with a hyphen");
    }

    private static NodePattern frontModifiedAdjective() {
        return NodePattern.or(NodePattern.or(NodePattern.N.form("free|breaking|friendly|specific|long|first|last|aware|centric|resistant|repellent|critical|bound(ed)?|consuming|limited|dependent|saving|(in)?sensitive").andNot(CommonPatterns.inAllCapitalizedSentence).andNot(CommonPatterns.capitalizedMiddle.inFormSequence(1, "cloud", "free", "tier")), NodePattern.N.form(".*[ai]ble").noPotentialPos("NN.*").noForm("repeatable|loadable").noDependents(NodePattern.not(NodePattern.PUNCT).andNot(NodePattern.N.withHeadRelation("conj")).afterHead()).andNot(NodePattern.N.directlyAfter(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nsubj(:pass)?|obj|obl")))).andNot(NodePattern.N.inFormSequence(2, "no", "longer", ".*"))).directlyAfter(NodePattern.N.potentialPos("NNS?").markAs("Prev").andOr(NodePattern.N.directlyBeforeHead().withHeadRelation("obl:npmod"), CommonPatterns.skipConjUp(NodePattern.N.beforeHead().withHeadRelation("obl:npmod")), secondConjPart.and(NodePattern.markedNodeMatches("Head", NodePattern.N.pos("NNP?"))).directlyBefore(NodePattern.N.withHeadRelation("amod")), EnglishTreePatterns.compound.noDependents().andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.withHeadRelation("amod"))).noForm("default").andNot(NodePattern.N.withNextSibling(EnglishTreePatterns.compound.beforeHead()))).andNot(CommonPatterns.capitalized.directlyAfter(CommonPatterns.capitalized)).andNot(CommonPatterns.capitalizedMiddle.directlyBefore(NodePattern.not(CommonPatterns.capitalized))).and(CommonPatterns.possiblyConj(NodePattern.N.noDependents("amod|nummod|det|case", NodePattern.N.beforeHead())))).andOr(NodePattern.N.withDependent("cop").noPos("VBG"), CommonPatterns.possiblyConj(NodePattern.N.withHead("amod|advmod|advcl", NodePattern.N.markAs("AdjHead"))).noDependents("case").andNot(NodePattern.markedNodeMatches("Prev", couldBeImperative).and(NodePattern.markedNodeMatches("AdjHead", NodePattern.ROOT))), NodePattern.N.withHead("conj", NodePattern.N.withHead("obl", NodePattern.N.pos("JJ.*").withDependent("cop"))), NodePattern.N.withHead("conj", NodePattern.N.pos("JJ.*").noPos("VBG").withDependent("cop"))).potentialPos("JJ|RB"), NodePattern.N.form("engined").directlyAfter(NodePattern.N.pos("JJ").directlyBeforeHead().withHeadRelation("amod|compound")), NodePattern.N.form("average|median").beforeHead().directlyAfter(NodePattern.N.form("above|below").directlyBeforeHead().withHeadRelation("advmod|case")), NodePattern.N.inFormSequence(1, "low", "key"), NodePattern.N.inFormSequence(1, "drop", "dead").directlyBeforeHead().withHead("advmod|amod", NodePattern.N.pos("JJ")), NodePattern.N.inFormSequence(1, "hands", "on").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHeadRelation("goeswith|fixed"), NodePattern.N.withHead("amod|compound", EnglishTreePatterns.compound)), NodePattern.N.inFormSequence(1, "picture|pitch|pixel|postcard|letter|inch|note", "perfect").withDependent("advmod|obl:npmod|compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.inFormSequence(1, "first", "aid").withHead("amod|compound", NodePattern.N.pos("NNS?")).beforeHead().andNot(CommonPatterns.capitalizedMiddle)).includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).message(COMPOUND_ADJ_MSG).trace("front modified adjective").and(hyphenateWithPrev);
    }

    private static NodePattern adjectiveWithNumber() {
        NodePattern toSingularize = NodePattern.N.potentialPos("NNS").andNot(Semantics.fractionDenominator);
        NodePattern afterCD = NodePattern.N.directlyAfter(NodePattern.N.pos("CD"));
        return CommonPatterns.possiblyConj(NodePattern.or(realCompound, NodePattern.N.withHeadRelation("amod"))).directlyAfter(NodePattern.or(EnglishTreePatterns.manyFewSeveral.withHeadRelation("amod").andNot(EnglishTreePatterns.aFew.withHead(NodePattern.N.pos("NNS").andNot(EnglishTreePatterns.compound.andNot(Semantics.timeUnits)))).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHead("compound", NodePattern.N.pos("NNS")))), NodePattern.or(EnglishTreePatterns.number.noDependents(NodePattern.not(CommonPatterns.latinOrNumber).andNot(CommonPatterns.noSpaceHyphen).beforeHead()).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("all"))), NodePattern.N.form("\\d+/\\d+"), NodePattern.N.form("multi[mb]illion")).withHeadRelation("nummod|compound")).markAs("Num")).potentialPos("NNS?").noForm("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])").andOr(NodePattern.markedNodeMatches("Num", NodePattern.or(NodePattern.N.directlyBeforeHead(), NodePattern.N.beforeHead().andOr(NodePattern.N.inFormSequence(0, "one", "stop", "shop"), NodePattern.N.inFormSequence(0, ".*", "years?", "age"), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar"), Semantics.progressUnit))))).andOr(NodePattern.N.withHead(NodePattern.N.withDependent("nmod:poss|det|compound", NodePattern.N.before("Num")).noPos("NNS")), NodePattern.N.form("day").withHead(NodePattern.N.lemma(".*week")), NodePattern.N.lemma("bit|star|person|karat"), NodePattern.N.form("baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar"), Semantics.timeUnits), NodePattern.N.form("factor|season|line|parameters?").withHeadRelation("compound").andNot(afterOne)).andNot(NodePattern.N.withHead(NodePattern.or(NodePattern.N.form("NET|worth"), CommonPatterns.possiblySkipDown("compound", NodePattern.N.form("version"))))).noDependents(NodePattern.N.afterHead().andNot(NodePattern.N.withHeadRelation("conj").withDependent("nummod"))).andNot(NodePattern.N.withHead(NodePattern.N.form("survey").and(NodePattern.markedNodeMatches("Num", EnglishTreePatterns.singleYearCD)))).andNot(NodePattern.markedNodeMatches("Num", NodePattern.N.label("PRODUCT|MISC").directlyAfter(NodePattern.N.label("PRODUCT|MISC")))).andNot(NodePattern.markedNodeMatches("Num", NodePattern.N.withPrevSibling(EnglishTreePatterns.compound.label("PRODUCT|MISC")))).andNot(NodePattern.N.form("step").directlyBefore(NodePattern.or(Semantics.kindredRelation, NodePattern.N.lemma("dancer")).pos("NNS"))).andNot(NodePattern.N.inFormSequence(2, ":", "\\d{1,4}", "connection|link", "ports?")).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("what|which")).directlyBefore(NodePattern.N.withHeadRelation("obj"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("a").withNeighbor(2, EnglishTreePatterns.compound))).directlyBefore(CommonPatterns.letterWord.noHeadRelation("case")).andNot(CommonPatterns.capitalizedMiddle.directlyAfter(CommonPatterns.capitalizedMiddle)).andNot(CommonPatterns.upperCase).andNot(Semantics.definitelyUncountableLemma).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("top"))).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.withHeadRelation("case").beforeHead()).withHead(NodePattern.N.withHeadRelation("nsubj.*"))).andNot(NodePattern.N.withDependent("conj|compound", NodePattern.or(NodePattern.N.pos("CD"), NodePattern.N.form("plus|minus")).afterHead())).andNot(NodePattern.N.form("day").directlyAfter(CommonPatterns.firstWord.form("one"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("plus|minus"))).message("Adjectives with numbers are usually written with a hyphen").and(NodePattern.custom((node, match) -> {
            String nounFix;
            Node num = node.neighbor(-1);
            if (node.hasForm("times?")) {
                return match.withCorrector(NodeCorrector.replaceNodes(num, node, num.lowForm() + (CommonPatterns.letterWord.matches(num) ? "" : "-") + "fold"));
            }
            Node start = num;
            if (num.hasLemma(".*") && afterCD.matches(num) && afterCD.matches(start = num.neighbor(-1))) {
                start = start.neighbor(-1);
            }
            String string = nounFix = toSingularize.matches(node) ? PluralsInCompounds.toRegularSingular(node) : null;
            if (nounFix == null) {
                nounFix = node.form();
            }
            String replacement = ((StreamEx)start.forward().takeWhile(s -> s != node)).map(Tree.Token::form).joining((CharSequence)"-") + "-" + nounFix;
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, replacement));
        }));
    }

    private static NodePattern wordsWithLetters() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("x").directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(NodePattern.N.form("rated?|rays?"))).correct(NodeCorrector.regexReplace("x", "X")).reportEverythingTouched(), NodePattern.N.inFormSequence(1, "x", "rated?|rays?").and(hyphenateWithPrevLetter), NodePattern.N.inFormSequence(1, "t", "shirts?").and(hyphenateWithPrevLetter), NodePattern.N.form("xrated?|xrays?").andNot(NodePattern.N.form("xray").inSentenceWith(NodePattern.N.form("jira"))).correct(NodeCorrector.regexReplace("[xX](.*)", "X-$1")), NodePattern.N.form("tshirts?").correct(NodeCorrector.regexReplace("[tT](.*)", "T-$1"))).message("Single letter prefixes are usually written with a hyphen");
    }

    private static NodePattern xYarder() {
        return NodePattern.or(NodePattern.N.form("yarders?|wheelers?"), NodePattern.N.form("story").andNot(afterOne)).directlyAfter(NodePattern.N.pos("CD")).message("'-$_' with numbers is usually written with a hyphen").and(hyphenateWithPrev);
    }

    private static NodePattern nYearOld() {
        NodePattern oldNode = NodePattern.N.lemma("old").markAs("Old").andOr(NodePattern.N.withHeadRelation("amod").beforeHead(), NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withHead(NodePattern.N.lemma("year").withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.withHeadRelation("root").withDependent("ccomp"), NodePattern.N.withDependent("obl:npmod|compound", NodePattern.N.lemma("year").withDependent("det", NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.form("dozen|hundred|thousand|million|billion|(ga)?zillion"))))), NodePattern.N.withDependent("det"), NodePattern.N.form("olds")).andNot(NodePattern.N.withHead(NodePattern.N.form("aged"))).andNot(TreeMigration.revise("try to remove this andNot", NodePattern.N.form("old").withDependent("obl"))).andNot(NodePattern.N.noForm("olds").withPrevSibling(NodePattern.N.withHeadRelation("nsubj"))).noHeadRelation("appos|advmod|advcl|conj");
        NodePattern withFirstNumber = NodePattern.N.withNeighbor(-2, NodePattern.N.pos("CD")).directlyAfter(NodePattern.N.withHeadRelation("cc|case").noForm("-"));
        return NodePattern.or(NodePattern.N.form("years").inFormSequence(1, "-", "years", "-", "olds?").correct(NodeCorrector.replace("year")).message("Replace with 'year'?"), NodePattern.N.lemma("year").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, oldNode)).markAs("Year").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.pos("CD").markAs("Num"))).and(NodePattern.custom((year, match) -> {
            Node old = match.getMarkedNode("Old");
            Node num = match.getMarkedNode("Num");
            String oldForm = old.form();
            if (num.nextNode() != year && year.nextNode() != old) {
                return null;
            }
            if (old.hasHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?") && Number.verbNumber(EnglishTreePatterns.findFiniteVerb(Objects.requireNonNull(old.head()))) == Number.plural || year.hasHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?") && Number.verbNumber(EnglishTreePatterns.findFiniteVerb(Objects.requireNonNull(year.head()))) == Number.plural) {
                oldForm = "olds";
            }
            NodeCorrector corrector = NodeCorrector.replaceNodes(num, old, num.form() + "-" + year.form().substring(0, 4) + "-" + oldForm);
            if (withFirstNumber.matches(num)) {
                corrector = corrector.join(NodeCorrector.insertAfter(num.neighbor(-2), "-"));
            }
            return match.withCorrector(corrector).withMessage("'" + num.lowForm() + "-year-old' is usually written with a hyphen");
        })), CommonPatterns.HYPHEN_NODE.directlyAfter(NodePattern.N.form("years")).directlyBefore(NodePattern.N.lemma("old").noPos("NNS?").andNot(NodePattern.N.withHeadRelation("amod").noDependents("obl").beforeHead())).reportEverythingTouched().correct(NodeCorrector.replace(" ")).message("'years old' should not be hyphenated after the noun it describes"), CommonPatterns.HYPHEN_NODE.includeIntoReport().andNot(HyphenVsDash.separatesRange).directlyAfter(NodePattern.N.pos("CD").includeIntoReport().andOr(NodePattern.N.withHead(NodePattern.or(atYearsOld, NodePattern.N.withHead(atYearsOld))), NodePattern.N.withDependent("conj", atYearsOld), NodePattern.N.withNextSibling(atYearsOld))).andOr(needsSpaceInsteadOfHyphen.correct(NodeCorrector.replace(" ")), NodePattern.not(needsSpaceInsteadOfHyphen).correct(NodeCorrector.replace(""))).message("Extra hyphen?"));
    }

    private static NodePattern nowadays() {
        return NodePattern.N.form("days?").noHeadRelation("root|ccomp").markAs("Days").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("a").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("now").markAs("Now"))))).andOr(NodePattern.N.directlyBefore(EnglishTreePatterns.apostropheS.markAs("S")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Now"), NodePointer.marked("S"), "nowadays")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Now"), NodePointer.marked("Days"), "nowadays"))).message("Did you mean 'nowadays'?");
    }

    private static NodePattern upToDate() {
        NodePattern upToDateHyphenated = NodePattern.or(NodePattern.N.withHead("case|compound", NodePattern.N.alreadyMarkedAs("Date").andOr(NodePattern.N.withHeadRelation("compound|nmod").andOr(NodePattern.N.beforeHead(), NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("amod|compound").beforeHead())), NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("amod").beforeHead()))), NodePattern.N.withHead("case|compound", NodePattern.not(NodePattern.N.alreadyMarkedAs("Date"))).beforeHead(), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("amod").beforeHead()), NodePattern.N.withHeadRelation("conj").andOr(NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Date").withHead("conj", NodePattern.N.withHeadRelation("amod|compound").beforeHead())), NodePattern.N.withDependent("obl", NodePattern.N.alreadyMarkedAs("Date")).withHead(NodePattern.N.withHeadRelation("amod").beforeHead())), NodePattern.N.withDependent("nmod", NodePattern.N.alreadyMarkedAs("Date")).and(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("amod").beforeHead())), NodePattern.N.withHeadRelation("amod|compound").beforeHead().withDependent("fixed", NodePattern.N.alreadyMarkedAs("Date")));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "up", "to").withNeighbor(2, NodePattern.N.form("date").markAs("Date")).reportEverythingTouched().and(upToDateHyphenated).and(hyphenateWith2Next).message("'up-to-date' should be hyphenated before the noun it describes"), NodePattern.N.inFormSequence(0, "up", "-", "to", "-").withNeighbor(4, NodePattern.N.form("date").markAs("Date")).andNot(upToDateHyphenated).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("IN")).withNeighbor(4, CommonPatterns.lastToken)).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Date"), "up to date")).message("'up to date' should not be hyphenated when it does not describe the following noun"));
    }

    private static NodePattern howTo() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "how", "to").andOr(NodePattern.N.withHeadRelation("case|fixed").directlyAfterHead().andNot(NodePattern.N.directlyBefore(CommonPatterns.colon)).andNot(CommonPatterns.lastToken), NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.directlyBefore(NodePattern.N.pos("NNS?").noPotentialPos("VB.*").noDependents("obj").andNot(phrasalVerbAsNoun).andNot(NodePattern.N.withHead(CommonPatterns.skipUp("obj", EnglishTreePatterns.clause)))), NodePattern.N.directlyAfterHead().withHead("acl", EnglishTreePatterns.compound)), NodePattern.N.inFormSequence(1, "how", "tos")).message("Did you mean 'how-$_'?").and(hyphenateWithPrev);
    }

    private static NodePattern toDo() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "to", "do", EnglishTreePatterns.apostropheS.getFormRegex()).andOr(NodePattern.N.andOr(NodePattern.N.beforeHead(), NodePattern.N.withDependent("obj", NodePattern.N.pos("NNS?"))).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node.neighbor(1), node.neighbor(-1).form() + "-" + node.form()))).message("Did you mean 'to-do'?"), NodePattern.N.andOr(NodePattern.N.afterHead(), NodePattern.ROOT).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node.neighbor(1), node.neighbor(-1).form() + "-" + node.form() + "s"))).message("Did you mean 'to-dos'?")), NodePattern.or(NodePattern.N.inFormSequence(1, "to", "dos").andNot(CommonPatterns.capitalized.directlyAfter(NodePattern.not(CommonPatterns.capitalized))), NodePattern.N.inFormSequence(1, "to", "do").andOr(EnglishTreePatterns.compound.withDependent("case", NodePattern.N.directlyBeforeHead()), NodePattern.N.withDependent("det"))).message("Did you mean 'to-$_'?").and(hyphenateWithPrev));
    }

    private static NodePattern noGo() {
        return NodePattern.N.inFormSequence(1, "no", "go(es)?").pos("NNS?").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("away"))).message("Did you mean 'no-$_'?").and(hyphenateWithPrev);
    }

    private static NodePattern addOn() {
        return NodePattern.N.inFormSequence(1, "add", "ons?").withDependent("compound", NodePattern.N.directlyBeforeHead()).message("Did you mean 'add-$_'?").and(hyphenateWithPrev);
    }

    private static NodePattern sevenEleven() {
        return NodePattern.N.form("seven|7").markAs("Seven").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.noSpaceBefore(), NodePattern.N.noSpaceAfter()), NodePattern.N.form("11|eleven").markAs("Eleven"))).andNot(NodePattern.N.formCaseSensitive("Seven|SEVEN").directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.formCaseSensitive("Eleven|ELEVEN").directlyBefore(NodePattern.N.form("Japan"))))).andNot(NodePattern.N.form("7").directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.formCaseSensitive("Eleven|ELEVEN")))).andNot(NodePattern.N.inFormSequence(0, "7", "-", "11")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Seven"), NodePointer.marked("Eleven"), "7-Eleven")).message("Did you mean a convenience store chain?");
    }

    private static NodePattern mustHaveLike() {
        return NodePattern.or(mustX.andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).message("Did you mean 'must-$_'?").and(hyphenateWithPrev), CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.onlyPos("VB")).directlyAfter(NodePattern.N.form("must").withHeadRelation("aux").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det")))).andNot(CommonPatterns.insideQuotes).correct(NodeCorrector.replace(" ")).reportEverythingTouched().message("Remove hyphen?"));
    }

    private static NodePattern www() {
        return NodePattern.N.form("web").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("wide").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("world").markAs("World"))))).andNot(NodePattern.N.formCaseSensitive("Web").directlyAfter(NodePattern.N.formCaseSensitive("Wide").directlyAfter(NodePattern.N.formCaseSensitive("World")))).andNot(CommonPatterns.lastToken).andNot(NodePattern.N.withHead("compound|amod", NodePattern.N.pos("NN.?")).beforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.marked("World"), NodePointer.anchor(), "World Wide Web")).message("Did you mean 'World Wide Web'?").reportEverythingTouched();
    }
}

