/*
 * Decompiled with CFR 0.152.
 */
package hughai.controllers.level2;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.EnemyTracker;
import hughai.GameAdapter;
import hughai.GiveOrderWrapper;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.mapping.Maps;
import hughai.packcoordinators.SpreadSearchPackCoordinatorWithSearchGrid;
import hughai.unitdata.UnitController;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class ScoutControllerRaider {
    public int nearbyforenemiesmeans = 250;
    public int enemysightedsearchradius = 1000;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    EnemyTracker enemyTracker;
    GiveOrderWrapper giveOrderWrapper;
    UnitController unitController;
    Maps maps;
    Config config;
    SpreadSearchPackCoordinatorWithSearchGrid searchcoordinator;
    List<Unit> ScoutUnits = new ArrayList<Unit>();
    HashSet<Unit> movefailed = new HashSet();
    Random random;
    boolean Active = false;
    ArrayList<Unit> attackingscouts = new ArrayList();

    public ScoutControllerRaider(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.giveOrderWrapper = playerObjects.getGiveOrderWrapper();
        this.maps = playerObjects.getMaps();
        this.unitController = playerObjects.getUnitController();
        this.config = playerObjects.getConfig();
        this.random = new Random();
        this.searchcoordinator = new SpreadSearchPackCoordinatorWithSearchGrid(playerObjects);
        this.logfile.WriteLine("*ScoutControllerRaider initialized*");
    }

    public void Activate() {
        if (!this.Active) {
            this.logfile.WriteLine("activating " + this.getClass().getSimpleName());
            this.csai.registerGameListener(new GameListenerHandler());
            this.csai.RegisterVoiceCommand("countscouts", new VoiceCommandCountScouts());
            this.searchcoordinator.Activate();
            this.Active = true;
        }
    }

    public void Disactivate() {
        if (this.Active) {
            this.csai.unregisterGameListener(new GameListenerHandler());
            this.csai.UnregisterVoiceCommand("countscouts");
            this.searchcoordinator.Disactivate();
            this.Active = false;
        }
    }

    public void AssignUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.ScoutUnits.add(unit);
            this.logfile.WriteLine("New scoutcontrollerraider unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            this.searchcoordinator.AssignUnits(collection);
        }
    }

    public void RevokeUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.ScoutUnits.remove(unit);
            this.searchcoordinator.RevokeUnits(collection);
        }
    }

    public void AssignEnergy(int n) {
    }

    public void AssignMetal(int n) {
    }

    public void AssignPower(double d) {
    }

    public void AssignMetalStream(double d) {
    }

    void ExploreWith(Unit unit) {
        TerrainPos terrainPos = new TerrainPos();
        float f = this.random.nextFloat() * (float)this.aicallback.getMap().getWidth();
        this.maps.getMovementMaps().getClass();
        terrainPos.x = f * 8.0f;
        float f2 = this.random.nextFloat() * (float)this.aicallback.getMap().getHeight();
        this.maps.getMovementMaps().getClass();
        terrainPos.z = f2 * 8.0f;
        terrainPos.y = this.maps.getHeightMap().getElevationAt(terrainPos);
        this.logfile.WriteLine("mapwidth: " + this.aicallback.getMap().getWidth() + " squaresize: " + this.maps.getMovementMaps().SQUARE_SIZE);
        this.logfile.WriteLine("ScoutController sending scout " + unit.getUnitId() + " to " + terrainPos.toString());
        this.giveOrderWrapper.MoveTo(unit, terrainPos);
    }

    void Reappraise() {
        for (Unit unit : this.ScoutUnits) {
            UnitDef unitDef;
            TerrainPos terrainPos = this.unitController.getPos(unit);
            TerrainPos terrainPos2 = null;
            float f = 1.0E8f;
            Unit unit2 = null;
            boolean bl = false;
            for (Unit unit3 : this.enemyTracker.getEnemyUnits()) {
                unitDef = this.enemyTracker.getEnemyUnitDefByUnit().get(unit3);
                if (unitDef == null || !this.IsPriorityTarget(unitDef)) continue;
                bl = true;
            }
            for (Unit unit3 : this.enemyTracker.getEnemyUnits()) {
                unitDef = this.enemyTracker.getEnemyUnitDefByUnit().get(unit3);
                if (unitDef == null || bl && !this.IsPriorityTarget(unitDef)) continue;
                this.logfile.WriteLine("considering unit " + unit3.getUnitId() + " " + unitDef.getName());
                TerrainPos terrainPos3 = TerrainPos.fromAIFloat3(unit3.getPos());
                float f2 = terrainPos.GetSquaredDistance(terrainPos3);
                if (!(f2 < f) || !(this.maps.getThreatMap().getThreatAt(terrainPos3) < 1.0f)) continue;
                terrainPos2 = terrainPos3;
                f = f2;
                unit2 = unit3;
            }
            if (terrainPos2 != null) {
                this.searchcoordinator.Disactivate();
                this.giveOrderWrapper.Attack(unit, unit2);
                this.movefailed.remove(unit);
                if (this.attackingscouts.contains(unit) && !this.movefailed.contains(unit)) continue;
                this.attackingscouts.add(unit);
                continue;
            }
            if (!this.attackingscouts.contains(unit) && !this.movefailed.contains(unit)) continue;
            this.searchcoordinator.Activate();
            this.attackingscouts.remove(unit);
            this.movefailed.remove(unit);
        }
    }

    boolean IsPriorityTarget(UnitDef unitDef) {
        String string = unitDef.getName().toLowerCase();
        return this.config.getScoutraiderprioritytargets().contains(string);
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            ScoutControllerRaider.this.Reappraise();
        }

        @Override
        public void UnitMoveFailed(Unit unit) {
            ScoutControllerRaider.this.movefailed.add(unit);
        }
    }

    class VoiceCommandCountScouts
    implements VoiceCommandHandler {
        VoiceCommandCountScouts() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            ScoutControllerRaider.this.csai.SendTextMsg("scouts: " + ScoutControllerRaider.this.ScoutUnits.size());
        }
    }
}

