﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/ExportResourceSpecification.h>
#include <aws/lexv2-models/model/ExportStatus.h>
#include <aws/lexv2-models/model/ImportExportFileFormat.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class UpdateExportResult {
 public:
  AWS_LEXMODELSV2_API UpdateExportResult() = default;
  AWS_LEXMODELSV2_API UpdateExportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API UpdateExportResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier Amazon Lex assigned to the export.</p>
   */
  inline const Aws::String& GetExportId() const { return m_exportId; }
  template <typename ExportIdT = Aws::String>
  void SetExportId(ExportIdT&& value) {
    m_exportIdHasBeenSet = true;
    m_exportId = std::forward<ExportIdT>(value);
  }
  template <typename ExportIdT = Aws::String>
  UpdateExportResult& WithExportId(ExportIdT&& value) {
    SetExportId(std::forward<ExportIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the type of resource that was exported, either a bot or a
   * bot locale.</p>
   */
  inline const ExportResourceSpecification& GetResourceSpecification() const { return m_resourceSpecification; }
  template <typename ResourceSpecificationT = ExportResourceSpecification>
  void SetResourceSpecification(ResourceSpecificationT&& value) {
    m_resourceSpecificationHasBeenSet = true;
    m_resourceSpecification = std::forward<ResourceSpecificationT>(value);
  }
  template <typename ResourceSpecificationT = ExportResourceSpecification>
  UpdateExportResult& WithResourceSpecification(ResourceSpecificationT&& value) {
    SetResourceSpecification(std::forward<ResourceSpecificationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The file format used for the files that define the resource. The
   * <code>TSV</code> format is required to export a custom vocabulary only;
   * otherwise use <code>LexJson</code> format.</p>
   */
  inline ImportExportFileFormat GetFileFormat() const { return m_fileFormat; }
  inline void SetFileFormat(ImportExportFileFormat value) {
    m_fileFormatHasBeenSet = true;
    m_fileFormat = value;
  }
  inline UpdateExportResult& WithFileFormat(ImportExportFileFormat value) {
    SetFileFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the export. When the status is <code>Completed</code> the
   * export archive is available for download.</p>
   */
  inline ExportStatus GetExportStatus() const { return m_exportStatus; }
  inline void SetExportStatus(ExportStatus value) {
    m_exportStatusHasBeenSet = true;
    m_exportStatus = value;
  }
  inline UpdateExportResult& WithExportStatus(ExportStatus value) {
    SetExportStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the export was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  UpdateExportResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the export was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedDateTime() const { return m_lastUpdatedDateTime; }
  template <typename LastUpdatedDateTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedDateTime(LastUpdatedDateTimeT&& value) {
    m_lastUpdatedDateTimeHasBeenSet = true;
    m_lastUpdatedDateTime = std::forward<LastUpdatedDateTimeT>(value);
  }
  template <typename LastUpdatedDateTimeT = Aws::Utils::DateTime>
  UpdateExportResult& WithLastUpdatedDateTime(LastUpdatedDateTimeT&& value) {
    SetLastUpdatedDateTime(std::forward<LastUpdatedDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateExportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exportId;
  bool m_exportIdHasBeenSet = false;

  ExportResourceSpecification m_resourceSpecification;
  bool m_resourceSpecificationHasBeenSet = false;

  ImportExportFileFormat m_fileFormat{ImportExportFileFormat::NOT_SET};
  bool m_fileFormatHasBeenSet = false;

  ExportStatus m_exportStatus{ExportStatus::NOT_SET};
  bool m_exportStatusHasBeenSet = false;

  Aws::Utils::DateTime m_creationDateTime{};
  bool m_creationDateTimeHasBeenSet = false;

  Aws::Utils::DateTime m_lastUpdatedDateTime{};
  bool m_lastUpdatedDateTimeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
