/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.FileUtils;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolverListeners;
import org.gradle.internal.scripts.ScriptFileUtil;
import org.gradle.internal.scripts.ScriptResolutionResult;
import org.jspecify.annotations.Nullable;

public class DefaultScriptFileResolver
implements ScriptFileResolver {
    private static final String[] EXTENSIONS = ScriptFileUtil.getValidExtensions();
    private final @Nullable ScriptFileResolverListeners listeners;

    public DefaultScriptFileResolver(@Nullable ScriptFileResolverListeners listeners) {
        this.listeners = listeners;
    }

    public DefaultScriptFileResolver() {
        this(null);
    }

    @Override
    public ScriptResolutionResult resolveScriptFile(File dir, String basename) {
        File selectedCandidate = null;
        ArrayList<File> ignoredCandidates = new ArrayList<File>();
        for (String extension : EXTENSIONS) {
            File candidate = new File(dir, basename + extension);
            if (selectedCandidate == null) {
                this.notifyListener(candidate);
                if (!candidate.isFile()) continue;
                selectedCandidate = candidate;
                continue;
            }
            if (!candidate.isFile()) continue;
            ignoredCandidates.add(candidate);
        }
        return new ScriptResolutionResult(dir, basename, selectedCandidate, ignoredCandidates);
    }

    @Override
    public List<File> findScriptsIn(File dir) {
        File[] candidates = dir.listFiles();
        if (candidates == null || candidates.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> found = new ArrayList<File>(candidates.length);
        for (File candidate : candidates) {
            if (!candidate.isFile() || !this.hasScriptExtension(candidate)) continue;
            found.add(candidate);
        }
        return found;
    }

    private void notifyListener(File scriptFile) {
        if (this.listeners != null) {
            this.listeners.onScriptFileResolved(scriptFile);
        }
    }

    private boolean hasScriptExtension(File file) {
        for (String extension : EXTENSIONS) {
            if (!FileUtils.hasExtension((File)file, (String)extension)) continue;
            return true;
        }
        return false;
    }
}

