/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassConsistentDataCopyAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassConsistentDataCopyAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,72:1\n77#2:73\n77#2:74\n22#3:75\n*S KotlinDebug\n*F\n+ 1 FirDataClassConsistentDataCopyAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker\n*L\n28#1:73\n31#1:74\n47#1:75\n*E\n"})
public final class FirDataClassConsistentDataCopyAnnotationChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirDataClassConsistentDataCopyAnnotationChecker INSTANCE = new FirDataClassConsistentDataCopyAnnotationChecker();

    private FirDataClassConsistentDataCopyAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Visibility visibility;
        FirAnnotation exposedCopy;
        FirAnnotation consistentCopy;
        block12: {
            block13: {
                boolean $i$f$isData;
                FirRegularClass $this$isData$iv;
                block10: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        consistentCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), context2.getSession());
                        exposedCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), context2.getSession());
                        if (consistentCopy == null) break block10;
                        if (!(declaration instanceof FirRegularClass)) break block11;
                        $this$isData$iv = (FirRegularClass)declaration;
                        $i$f$isData = false;
                        if ($this$isData$iv.getStatus().isData()) break block10;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), null, 8, null);
                    return;
                }
                if (exposedCopy == null) break block12;
                if (!(declaration instanceof FirRegularClass)) break block13;
                $this$isData$iv = (FirRegularClass)declaration;
                $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block12;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), null, 8, null);
            return;
        }
        if (consistentCopy != null && exposedCopy != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), null, 8, null);
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), null, 8, null);
        }
        FirDataClassConsistentDataCopyAnnotationChecker $this$check_u24lambda_u240 = this;
        boolean bl = false;
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
        if (firConstructorSymbol != null) {
            FirCallableSymbol $this$visibility$iv = firConstructorSymbol;
            boolean $i$f$getVisibility = false;
            visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        } else {
            visibility = null;
        }
        Visibility primaryConstructorVisibility = visibility;
        boolean isPrimaryConstructorVisibilityPublic = Intrinsics.areEqual(primaryConstructorVisibility, (Object)Visibilities.Public.INSTANCE);
        boolean isConstructorVisibilityRespected = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DataClassCopyRespectsConstructorVisibility);
        if (consistentCopy != null && (isPrimaryConstructorVisibilityPublic || isConstructorVisibilityRespected)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), (Object)StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), null, 16, null);
        }
        if (exposedCopy == null) return;
        if (!isPrimaryConstructorVisibilityPublic) return;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), (Object)StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), null, 16, null);
    }
}

