/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeNotFunctionAsOperator;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ7\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkNotFunctionAsOperator", "", "callExpression", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "checkNoGetSetMethods", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkCompareToTypeMismatch", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConventionFunctionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n23#2,2:99\n1#3:101\n*S KotlinDebug\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n*L\n54#1:99,2\n*E\n"})
public final class FirConventionFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConventionFunctionCallChecker INSTANCE = new FirConventionFunctionCallChecker();

    private FirConventionFunctionCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        boolean notFunctionAsOperatorIsReportedOnDispatch = this.checkNotFunctionAsOperator(context2, reporter, expression2, expression2.getDispatchReceiver());
        boolean notFunctionAsOperatorIsReportedOnExtension = this.checkNotFunctionAsOperator(context2, reporter, expression2, expression2.getExtensionReceiver());
        if (!notFunctionAsOperatorIsReportedOnDispatch && !notFunctionAsOperatorIsReportedOnExtension) {
            this.checkCompareToTypeMismatch(reporter, context2, expression2);
        }
        this.checkNoGetSetMethods(reporter, context2, expression2);
    }

    private final boolean checkNotFunctionAsOperator(CheckerContext context2, DiagnosticReporter reporter, FirFunctionCall callExpression, FirExpression receiver) {
        Object object;
        Object v3;
        FirExpression unwrapped;
        block9: {
            List<ConeDiagnostic> list;
            FirExpression firExpression = callExpression.getDispatchReceiver();
            if ((firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null) instanceof ConeDynamicType) {
                return false;
            }
            FirExpression firExpression2 = receiver;
            if (firExpression2 == null || (firExpression2 = FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2)) == null) {
                return false;
            }
            unwrapped = firExpression2;
            FirExpression firExpression3 = unwrapped;
            if (firExpression3 instanceof FirQualifiedAccessExpression) {
                list = ((FirQualifiedAccessExpression)unwrapped).getNonFatalDiagnostics();
            } else if (firExpression3 instanceof FirResolvedQualifier) {
                list = ((FirResolvedQualifier)unwrapped).getNonFatalDiagnostics();
            } else {
                return false;
            }
            List<ConeDiagnostic> nonFatalDiagnostics = list;
            Iterable $this$firstIsInstanceOrNull$iv = nonFatalDiagnostics;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof ConeNotFunctionAsOperator)) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        if ((object = (ConeNotFunctionAsOperator)v3) == null || (object = ((ConeNotFunctionAsOperator)object).getSymbol()) == null) {
            return false;
        }
        Object diagnosticSymbol = object;
        ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType(unwrapped));
        Intrinsics.checkNotNull((Object)classId);
        if (!Intrinsics.areEqual((Object)classId.getShortClassName(), (Object)OperatorNameConventions.ITERATOR)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)callExpression.getCalleeReference().getSource(), FirErrors.INSTANCE.getNOT_FUNCTION_AS_OPERATOR(), (Object)(diagnosticSymbol instanceof FirPropertySymbol ? "Property" : "Object"), diagnosticSymbol, null, 32, null);
            return true;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)unwrapped.getSource(), FirErrors.INSTANCE.getITERATOR_MISSING(), null, 8, null);
        return false;
    }

    private final void checkNoGetSetMethods(DiagnosticReporter reporter, CheckerContext context2, FirFunctionCall expression2) {
        Object object = expression2.getCalleeReference();
        FirErrorNamedReference firErrorNamedReference = object instanceof FirErrorNamedReference ? (FirErrorNamedReference)object : null;
        if (firErrorNamedReference == null) {
            return;
        }
        FirErrorNamedReference calleeReference = firErrorNamedReference;
        ConeDiagnostic coneDiagnostic = calleeReference.getDiagnostic();
        ConeUnresolvedNameError coneUnresolvedNameError = coneDiagnostic instanceof ConeUnresolvedNameError ? (ConeUnresolvedNameError)coneDiagnostic : null;
        if (coneUnresolvedNameError == null) {
            return;
        }
        ConeUnresolvedNameError diagnostic = coneUnresolvedNameError;
        KtSourceElement ktSourceElement = expression2.getCalleeReference().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            object = diagnostic.getName();
            if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.GET)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_GET_METHOD(), null, 8, null);
            } else if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.SET)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_SET_METHOD(), null, 8, null);
            }
        }
    }

    private final void checkCompareToTypeMismatch(DiagnosticReporter reporter, CheckerContext context2, FirFunctionCall expression2) {
        if (expression2.getOrigin() == FirFunctionCallOrigin.Operator && Intrinsics.areEqual((Object)expression2.getCalleeReference().getName(), (Object)OperatorNameConventions.COMPARE_TO)) {
            ConeKotlinType it = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getResolvedType(expression2));
            boolean bl = false;
            boolean bl2 = !(ConeBuiltinTypeUtilsKt.isInt(it) || it instanceof ConeDynamicType || ConeTypeUtilsKt.hasError(it));
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCOMPARE_TO_TYPE_MISMATCH(), (Object)FirTypeUtilsKt.getResolvedType(expression2), null, 16, null);
            }
        }
    }
}

