/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableNullableReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.OperatorCallOfNonOperatorFunction;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u007f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u001a\b\u0002\u0010\u001a\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0018\u00010\u00152\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)V", "checkSpecialFunctionCall", "", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "reportSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "ambiguityFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "missingFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "noneApplicableFactory", "nullableReceiverFactory", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirForLoopChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirForLoopChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,172:1\n1586#2:173\n1661#2,3:174\n777#2:177\n873#2,2:178\n1915#2,2:180\n30#3:182\n*S KotlinDebug\n*F\n+ 1 FirForLoopChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker\n*L\n110#1:173\n110#1:174,3\n132#1:177\n132#1:178,2\n132#1:180,2\n162#1:182\n*E\n"})
public final class FirForLoopChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirForLoopChecker INSTANCE = new FirForLoopChecker();

    private FirForLoopChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirBlock expression2) {
        block8: {
            Object source;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            List<FirStatement> statements = expression2.getStatements();
            FirStatement firStatement = statements.get(0);
            FirProperty firProperty = firStatement instanceof FirProperty ? (FirProperty)firStatement : null;
            if (firProperty == null) {
                return;
            }
            FirProperty iteratorDeclaration = firProperty;
            FirStatement firStatement2 = statements.get(1);
            FirWhileLoop firWhileLoop = firStatement2 instanceof FirWhileLoop ? (FirWhileLoop)firStatement2 : null;
            if (firWhileLoop == null) {
                return;
            }
            FirWhileLoop whileLoop = firWhileLoop;
            KtSourceElement ktSourceElement2 = iteratorDeclaration.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            FirExpression firExpression = iteratorDeclaration.getInitializer();
            Intrinsics.checkNotNull((Object)firExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall iteratorCall = (FirFunctionCall)firExpression;
            Object object = iteratorCall.getExplicitReceiver();
            if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                object = iteratorCall.getSource();
            }
            if (FirForLoopChecker.checkSpecialFunctionCall$default(this, reporter, context2, iteratorCall, (KtSourceElement)(source = object), FirErrors.INSTANCE.getITERATOR_AMBIGUITY(), FirErrors.INSTANCE.getITERATOR_MISSING(), null, FirErrors.INSTANCE.getITERATOR_ON_NULLABLE(), 64, null)) {
                return;
            }
            FirExpression firExpression2 = whileLoop.getCondition();
            Intrinsics.checkNotNull((Object)firExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall hasNextCall = (FirFunctionCall)firExpression2;
            FirForLoopChecker.checkSpecialFunctionCall$default(this, reporter, context2, hasNextCall, (KtSourceElement)source, FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_AMBIGUITY(), FirErrors.INSTANCE.getHAS_NEXT_MISSING(), FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_NONE_APPLICABLE(), null, 128, null);
            Object object2 = CollectionsKt.firstOrNull(whileLoop.getBlock().getStatements());
            FirProperty firProperty2 = object2 instanceof FirProperty ? (FirProperty)object2 : null;
            if (firProperty2 == null) {
                return;
            }
            FirProperty loopParameter = firProperty2;
            Object object3 = loopParameter.getInitializer();
            if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = ((FirExpression)object3).getSource()) != null ? ((KtSourceElement)object3).getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            FirExpression firExpression3 = loopParameter.getInitializer();
            Intrinsics.checkNotNull((Object)firExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall nextCall = (FirFunctionCall)firExpression3;
            FirForLoopChecker.checkSpecialFunctionCall$default(this, reporter, context2, nextCall, (KtSourceElement)source, FirErrors.INSTANCE.getNEXT_AMBIGUITY(), FirErrors.INSTANCE.getNEXT_MISSING(), FirErrors.INSTANCE.getNEXT_NONE_APPLICABLE(), null, 128, null);
            KtSourceElement loopParameterSource = loopParameter.getSource();
            KtKeywordToken ktKeywordToken = FirKeywordUtilsKt.getValOrVarKeyword(loopParameterSource);
            if (ktKeywordToken == null) break block8;
            KtKeywordToken it = ktKeywordToken;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)loopParameterSource, FirErrors.INSTANCE.getVAL_OR_VAR_ON_LOOP_PARAMETER(), (Object)it, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSpecialFunctionCall(DiagnosticReporter reporter, CheckerContext context2, FirFunctionCall call2, KtSourceElement reportSource, KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ambiguityFactory, KtDiagnosticFactory0 missingFactory, KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> noneApplicableFactory, KtDiagnosticFactory0 nullableReceiverFactory) {
        FirBasedSymbol<?> symbol;
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            ConeDiagnostic diagnostic = ((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic();
            if (diagnostic instanceof ConeAmbiguityError) {
                Collection<FirBasedSymbol<?>> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory1;
                DiagnosticContext diagnosticContext2 = context2;
                AbstractKtSourceElement abstractKtSourceElement = reportSource;
                if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability()) || (ktDiagnosticFactory1 = noneApplicableFactory) == null) {
                    ktDiagnosticFactory1 = ambiguityFactory;
                }
                Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory12 = ktDiagnosticFactory1;
                AbstractKtSourceElement abstractKtSourceElement2 = abstractKtSourceElement;
                DiagnosticReporter diagnosticReporter = reporter;
                DiagnosticContext diagnosticContext3 = diagnosticContext2;
                boolean $i$f$map = false;
                void var13_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getSymbol());
                }
                collection = (List)destination$iv$iv;
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext3, diagnosticReporter, abstractKtSourceElement2, ktDiagnosticFactory12, (Object)collection, null, 16, null);
                return true;
            } else if (diagnostic instanceof ConeUnresolvedNameError) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, missingFactory, null, 8, null);
                return true;
            } else if (diagnostic instanceof ConeInapplicableWrongReceiver) {
                if (noneApplicableFactory != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, noneApplicableFactory, ((ConeInapplicableWrongReceiver)diagnostic).getCandidateSymbols(), null, 16, null);
                    return true;
                } else {
                    if (!Intrinsics.areEqual((Object)calleeReference.getName(), (Object)OperatorNameConventions.ITERATOR)) throw new IllegalStateException("ConeInapplicableWrongReceiver, but no diagnostic reported".toString());
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, missingFactory, null, 8, null);
                }
                return true;
            } else if (diagnostic instanceof ConeConstraintSystemHasContradiction) {
                if (!Intrinsics.areEqual((Object)calleeReference.getName(), (Object)OperatorNameConventions.ITERATOR)) return true;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, missingFactory, null, 8, null);
                return true;
            } else {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                if (!(diagnostic instanceof ConeInapplicableCandidateError) || nullableReceiverFactory == null && noneApplicableFactory == null) return true;
                Iterable $this$filter$iv = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getDiagnostics();
                boolean $i$f$filter = false;
                Iterable $this$mapTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getApplicability() == ((ConeInapplicableCandidateError)diagnostic).getApplicability())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv;
                    boolean bl = false;
                    ResolutionDiagnostic resolutionDiagnostic = it;
                    if (resolutionDiagnostic instanceof InapplicableNullableReceiver) {
                        if (nullableReceiverFactory != null) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, nullableReceiverFactory, null, 8, null);
                            return true;
                        } else {
                            DiagnosticContext diagnosticContext4 = context2;
                            AbstractKtSourceElement abstractKtSourceElement = reportSource;
                            KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory1 = noneApplicableFactory;
                            Intrinsics.checkNotNull(ktDiagnosticFactory1);
                            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext4, reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()), null, 16, null);
                        }
                        return true;
                    }
                    if (!(resolutionDiagnostic instanceof OperatorCallOfNonOperatorFunction)) continue;
                    FirNamedFunctionSymbol symbol2 = ((OperatorCallOfNonOperatorFunction)it).getFunction();
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED(), (Object)symbol2, null, 16, null);
                }
            }
            return true;
        }
        if (!(calleeReference instanceof FirResolvedNamedReference) || !((symbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol()) instanceof FirNamedFunctionSymbol)) return false;
        FirCallableSymbol $this$isOperator$iv = (FirCallableSymbol)symbol;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getResolvedStatus().isOperator()) return false;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportSource, FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED(), symbol, null, 16, null);
        return false;
    }

    static /* synthetic */ boolean checkSpecialFunctionCall$default(FirForLoopChecker firForLoopChecker, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, FirFunctionCall firFunctionCall, KtSourceElement ktSourceElement, KtDiagnosticFactory1 ktDiagnosticFactory1, KtDiagnosticFactory0 ktDiagnosticFactory0, KtDiagnosticFactory1 ktDiagnosticFactory12, KtDiagnosticFactory0 ktDiagnosticFactory02, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            ktDiagnosticFactory12 = null;
        }
        if ((n2 & 0x80) != 0) {
            ktDiagnosticFactory02 = null;
        }
        return firForLoopChecker.checkSpecialFunctionCall(diagnosticReporter, checkerContext, firFunctionCall, ktSourceElement, ktDiagnosticFactory1, ktDiagnosticFactory0, ktDiagnosticFactory12, ktDiagnosticFactory02);
    }
}

