/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H&J\u0014\u0010\u001a\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\u001c\u0010%\u001a\u00020\u0016*\u00020\u00162\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\u0006\u0010&\u001a\u00020+H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00020\u001d*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AbstractValueUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "replaceTypesInsideInlinedFunctionBlock", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "icUtils", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "getIcUtils", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "useExpressionAsType", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expectedType", "useAs", "type", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getCallTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "useAsValueArgument", "expression", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "useAsVarargElement", "element", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nAutoboxingTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoboxingTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/AbstractValueUsageLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public abstract class AbstractValueUsageLowering
extends AbstractValueUsageTransformer
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final JsCommonInlineClassesUtils icUtils;

    public AbstractValueUsageLowering(@NotNull JsCommonBackendContext context2, boolean replaceTypesInsideInlinedFunctionBlock) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2.getIrBuiltIns(), replaceTypesInsideInlinedFunctionBlock);
        this.context = context2;
        this.icUtils = this.context.getInlineClassesUtils();
    }

    public /* synthetic */ AbstractValueUsageLowering(JsCommonBackendContext jsCommonBackendContext, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(jsCommonBackendContext, bl);
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final JsCommonInlineClassesUtils getIcUtils() {
        return this.icUtils;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (container.getParent() instanceof IrFunction) {
            return;
        }
        IrElement irElement = container.transform(this, null);
        Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration replacement = (IrDeclaration)irElement;
        if (container != replacement) {
            CompilationExceptionKt.compilationException("Declaration has changed", container);
            throw new KotlinNothingValueException();
        }
        IrElement irElement2 = irBody;
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        PatchDeclarationParentsKt.patchDeclarationParents(irElement2, irDeclarationParent);
    }

    @NotNull
    public abstract IrExpression useExpressionAsType(@NotNull IrExpression var1, @NotNull IrType var2, @NotNull IrType var3);

    @Override
    @NotNull
    protected IrExpression useAs(@NotNull IrExpression $this$useAs, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)$this$useAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.useExpressionAsType($this$useAs, Companion.getActualType($this$useAs, this.context), type);
    }

    private final IrFunction getTarget(IrFunctionAccessExpression $this$target) {
        Object object;
        IrFunctionAccessExpression irFunctionAccessExpression = $this$target;
        if (irFunctionAccessExpression instanceof IrConstructorCall) {
            object = ((IrConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrDelegatingConstructorCall) {
            object = ((IrDelegatingConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrCall) {
            object = this.getCallTarget((IrCall)$this$target);
        } else {
            if (irFunctionAccessExpression instanceof IrEnumConstructorCall) {
                CompilationExceptionKt.compilationException("IrEnumConstructorCall is not supported here", $this$target);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final IrFunction getCallTarget(IrCall $this$callTarget) {
        return IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)$this$callTarget.getSymbol().getOwner());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected IrExpression useAsValueArgument(@NotNull IrExpression $this$useAsValueArgument, @NotNull IrFunctionAccessExpression expression2, @NotNull IrValueParameter parameter) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$useAsValueArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (parameter.getKind() == IrParameterKind.DispatchReceiver) {
            boolean bl;
            IrValueParameter irValueParameter = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getDispatchReceiverParameter();
            if (irValueParameter != null) {
                IrValueParameter it = irValueParameter;
                boolean bl2 = false;
                bl = this.icUtils.shouldValueParameterBeBoxed(it);
            } else {
                bl = false;
            }
            if (bl) {
                irExpression = this.useAs($this$useAsValueArgument, this.getIrBuiltIns().getAnyType());
                return irExpression;
            }
        }
        irExpression = this.useAsValue($this$useAsValueArgument, this.getTarget(expression2).getParameters().get(parameter.getIndexInParameters()));
        return irExpression;
    }

    @Override
    @NotNull
    protected IrExpression useAsVarargElement(@NotNull IrExpression element, @NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.useAs(element, this.icUtils.isTypeInlined(element.getType()) && !this.icUtils.isTypeInlined(expression2.getType()) && !IrTypeUtilsKt.isPrimitiveArray(expression2.getType()) ? this.getIrBuiltIns().getAnyNType() : (!IrTypeUtilsKt.isPrimitiveArray(expression2.getType()) ? this.getIrBuiltIns().getAnyNType() : expression2.getVarargElementType()));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AbstractValueUsageLowering$Companion;", "", "<init>", "()V", "getActualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrType getActualType(@NotNull IrExpression $this$getActualType, @NotNull JsCommonBackendContext context2) {
            IrValueDeclaration value2;
            Intrinsics.checkNotNullParameter((Object)$this$getActualType, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrExpression irExpression = $this$getActualType;
            IrType irType = irExpression instanceof IrConstructorCall ? ((IrConstructor)((IrConstructorCall)$this$getActualType).getSymbol().getOwner()).getReturnType() : (irExpression instanceof IrCall ? IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)((IrCall)$this$getActualType).getSymbol().getOwner()).getReturnType() : (irExpression instanceof IrGetField ? ((IrField)((IrGetField)$this$getActualType).getSymbol().getOwner()).getType() : (irExpression instanceof IrTypeOperatorCall ? (((IrTypeOperatorCall)$this$getActualType).getOperator() == IrTypeOperator.REINTERPRET_CAST ? ((IrTypeOperatorCall)$this$getActualType).getTypeOperand() : $this$getActualType.getType()) : (irExpression instanceof IrGetValue ? ((value2 = ((IrGetValue)$this$getActualType).getSymbol().getOwner()) instanceof IrValueParameter && context2.getInlineClassesUtils().shouldValueParameterBeBoxed((IrValueParameter)value2) ? context2.getIrBuiltIns().getAnyType() : $this$getActualType.getType()) : $this$getActualType.getType()))));
            return irType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

