/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.List;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;

public class BroadcastChangingOutputsStep<C extends WorkspaceContext>
implements Step<C, Result> {
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends Result> delegate;

    public BroadcastChangingOutputsStep(OutputChangeListener outputChangeListener, Step<? super C, ? extends Result> delegate) {
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(UnitOfWork work, C context) {
        List<String> outputsToBeChanged = work.getAllOutputLocationsForInvalidation(((WorkspaceContext)context).getWorkspace());
        this.outputChangeListener.invalidateCachesFor(outputsToBeChanged);
        try {
            Result result = this.delegate.execute(work, context);
            return result;
        }
        finally {
            this.outputChangeListener.invalidateCachesFor(outputsToBeChanged);
        }
    }
}

