/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.ExecutionContext;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkOutput;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.work.InputChanges;

public abstract class ExecuteStep<C extends WorkspaceContext>
implements Step<C, Result> {
    private final BuildOperationRunner buildOperationRunner;

    public ExecuteStep(BuildOperationRunner buildOperationRunner) {
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        final Class<?> workType = work.getClass();
        final Identity identity = ((IdentityContext)context).getIdentity();
        return (Result)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.this.executeInternal(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)new Operation.Details(){

                    @Override
                    public Class<?> getWorkType() {
                        return workType;
                    }

                    @Override
                    public Identity getIdentity() {
                        return identity;
                    }
                });
            }
        });
    }

    private Result executeInternal(UnitOfWork work, C context) {
        WorkOutput workOutput;
        ExecutionContext executionRequest = this.createExecutionContext(context);
        Timer timer = Time.startTimer();
        try {
            workOutput = work.execute(executionRequest);
        }
        catch (Throwable t) {
            return Result.failed(t, Duration.ofMillis(timer.getElapsedMillis()));
        }
        Duration duration = Duration.ofMillis(timer.getElapsedMillis());
        final Execution.ExecutionOutcome mode = this.determineOutcome(context, workOutput);
        return Result.success(duration, new Execution(){

            @Override
            public Execution.ExecutionOutcome getOutcome() {
                return mode;
            }

            @Override
            public Object getOutput(File workspace) {
                return workOutput.getOutput(workspace);
            }

            @Override
            public boolean canStoreOutputsInCache() {
                return workOutput.canStoreInCache();
            }
        });
    }

    protected abstract ExecutionContext createExecutionContext(C var1);

    protected abstract Execution.ExecutionOutcome determineOutcome(C var1, WorkOutput var2);

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public Class<?> getWorkType();

            public Identity getIdentity();
        }
    }

    public static class Mutable
    extends ExecuteStep<InputChangesContext> {
        public Mutable(BuildOperationRunner buildOperationRunner) {
            super(buildOperationRunner);
        }

        @Override
        protected ExecutionContext createExecutionContext(final InputChangesContext context) {
            return new ExecutionContext(){

                @Override
                public File getWorkspace() {
                    return context.getWorkspace();
                }

                @Override
                public Optional<InputChangesInternal> getInputChanges() {
                    return context.getInputChanges();
                }

                @Override
                public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                    return context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork);
                }
            };
        }

        @Override
        protected Execution.ExecutionOutcome determineOutcome(InputChangesContext context, WorkOutput workOutput) {
            switch (workOutput.getDidWork()) {
                case DID_NO_WORK: {
                    return Execution.ExecutionOutcome.UP_TO_DATE;
                }
                case DID_WORK: {
                    return context.getInputChanges().filter(InputChanges::isIncremental).map(Functions.constant((Object)((Object)Execution.ExecutionOutcome.EXECUTED_INCREMENTALLY))).orElse(Execution.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY);
                }
            }
            throw new AssertionError();
        }
    }

    public static class Immutable
    extends ExecuteStep<WorkspaceContext> {
        public Immutable(BuildOperationRunner buildOperationRunner) {
            super(buildOperationRunner);
        }

        @Override
        protected ExecutionContext createExecutionContext(final WorkspaceContext context) {
            return new ExecutionContext(){

                @Override
                public File getWorkspace() {
                    return context.getWorkspace();
                }

                @Override
                public Optional<InputChangesInternal> getInputChanges() {
                    return Optional.empty();
                }

                @Override
                public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                    return Optional.empty();
                }
            };
        }

        @Override
        protected Execution.ExecutionOutcome determineOutcome(WorkspaceContext context, WorkOutput workOutput) {
            return Execution.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
        }
    }
}

