/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.initialization.buildsrc.BuildSrcProjectConfigurationAction;
import org.gradle.util.GradleVersion;

public class GradlePluginApiVersionAttributeConfigurationAction
implements BuildSrcProjectConfigurationAction {
    public void execute(ProjectInternal project) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> this.addGradlePluginApiVersionAttributeToClasspath(project));
    }

    private void addGradlePluginApiVersionAttributeToClasspath(ProjectInternal project) {
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(arg_0 -> this.lambda$addGradlePluginApiVersionAttributeToClasspath$1((ConfigurationContainer)configurations, arg_0));
    }

    private void setAttributeForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        GradlePluginApiVersionAttributeConfigurationAction.setAttributeForConfiguration((NamedDomainObjectProvider<Configuration>)configurations.named(sourceSet.getCompileClasspathConfigurationName()));
        GradlePluginApiVersionAttributeConfigurationAction.setAttributeForConfiguration((NamedDomainObjectProvider<Configuration>)configurations.named(sourceSet.getRuntimeClasspathConfigurationName()));
    }

    private static void setAttributeForConfiguration(NamedDomainObjectProvider<Configuration> configurationProvider) {
        configurationProvider.configure(configuration -> {
            AttributeContainer attrs = configuration.getAttributes();
            attrs.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)attrs.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion())));
        });
    }

    private /* synthetic */ void lambda$addGradlePluginApiVersionAttributeToClasspath$1(ConfigurationContainer configurations, SourceSet sourceSet) {
        this.setAttributeForSourceSet(sourceSet, configurations);
    }
}

