/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.Limiter;

public final class MoreCollectors {
    private MoreCollectors() {
        throw new UnsupportedOperationException();
    }

    private static <T, U> Collector<T, ?, U> empty(Supplier<U> supplier) {
        return new Internals.CancellableCollectorImpl<Object, Object, Object>(() -> Internals.NONE, (acc, t) -> {}, Internals.selectFirst(), acc -> supplier.get(), Internals.alwaysTrue(), EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT));
    }

    private static <T> Collector<T, ?, List<T>> empty() {
        return MoreCollectors.empty(ArrayList::new);
    }

    public static <T> Collector<T, ?, T[]> toArray(IntFunction<T[]> generator) {
        Objects.requireNonNull(generator);
        return Collectors.collectingAndThen(Collectors.toList(), list -> list.toArray((Object[])generator.apply(list.size())));
    }

    public static <T> Collector<T, ?, boolean[]> toBooleanArray(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return Internals.PartialCollector.booleanArray().asRef((box, t) -> {
            if (predicate.test(t)) {
                ((BitSet)box.a).set(box.b);
            }
            box.b = StrictMath.addExact(box.b, 1);
        });
    }

    public static <T extends Enum<T>> Collector<T, ?, EnumSet<T>> toEnumSet(Class<T> enumClass) {
        int size = EnumSet.allOf(enumClass).size();
        return new Internals.CancellableCollectorImpl(() -> EnumSet.noneOf(enumClass), AbstractCollection::add, (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }, Function.identity(), set -> set.size() == size, Internals.UNORDERED_ID_CHARACTERISTICS);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> entriesToMap() {
        return MoreCollectors.entriesToCustomMap(HashMap::new);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> entriesToMap(BinaryOperator<V> combiner) {
        return MoreCollectors.entriesToCustomMap(combiner, HashMap::new);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> entriesToCustomMap(Supplier<M> mapSupplier) {
        return Collector.of(mapSupplier, (m, entry) -> AbstractStreamEx.addToMap(m, entry.getKey(), Objects.requireNonNull(entry.getValue())), (m1, m2) -> {
            m2.forEach((k, v) -> AbstractStreamEx.addToMap(m1, k, v));
            return m1;
        }, new Collector.Characteristics[0]);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> entriesToCustomMap(BinaryOperator<V> combiner, Supplier<M> mapSupplier) {
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(mapSupplier);
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, combiner, mapSupplier);
    }

    public static <T> Collector<T, ?, Integer> distinctCount(Function<? super T, ?> mapper) {
        Objects.requireNonNull(mapper);
        return Collectors.collectingAndThen(Collectors.mapping(mapper, Collectors.toSet()), Set::size);
    }

    public static <T> Collector<T, ?, List<T>> distinctBy(Function<? super T, ?> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(LinkedHashMap::new, (map, t) -> map.putIfAbsent(mapper.apply(t), t), (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.putIfAbsent(e.getKey(), e.getValue());
            }
            return m1;
        }, map -> new ArrayList(map.values()), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Integer> countingInt() {
        return Internals.PartialCollector.intSum().asRef((acc, t) -> {
            acc[0] = acc[0] + 1;
        });
    }

    public static <T, A1, A2, R1, R2, R> Collector<T, ?, R> pairing(Collector<? super T, A1, R1> c1, Collector<? super T, A2, R2> c2, BiFunction<? super R1, ? super R2, ? extends R> finisher) {
        Objects.requireNonNull(finisher);
        EnumSet<Collector.Characteristics> c = EnumSet.noneOf(Collector.Characteristics.class);
        c.addAll(c1.characteristics());
        c.retainAll(c2.characteristics());
        c.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
        Supplier c1Supplier = c1.supplier();
        Supplier c2Supplier = c2.supplier();
        BiConsumer c1Accumulator = c1.accumulator();
        BiConsumer c2Accumulator = c2.accumulator();
        BinaryOperator c1Combiner = c1.combiner();
        BinaryOperator c2combiner = c2.combiner();
        Supplier<Internals.PairBox> supplier = () -> new Internals.PairBox(c1Supplier.get(), c2Supplier.get());
        BiConsumer<Internals.PairBox, Object> accumulator = (acc, v) -> {
            c1Accumulator.accept(acc.a, v);
            c2Accumulator.accept((Object)acc.b, (Object)v);
        };
        BinaryOperator combiner = (acc1, acc2) -> {
            acc1.a = c1Combiner.apply(acc1.a, acc2.a);
            acc1.b = c2combiner.apply(acc1.b, acc2.b);
            return acc1;
        };
        Function<Internals.PairBox, Object> resFinisher = acc -> {
            Object r1 = c1.finisher().apply(acc.a);
            Object r2 = c2.finisher().apply(acc.b);
            return finisher.apply((Object)r1, (Object)r2);
        };
        Predicate c1Finished = Internals.finished(c1);
        Predicate c2Finished = Internals.finished(c2);
        if (c1Finished != null && c2Finished != null) {
            Predicate<Internals.PairBox> finished = acc -> c1Finished.test(acc.a) && c2Finished.test(acc.b);
            return new Internals.CancellableCollectorImpl<Object, Internals.PairBox, Object>(supplier, accumulator, combiner, resFinisher, finished, c);
        }
        return Collector.of(supplier, accumulator, combiner, resFinisher, c.toArray(new Collector.Characteristics[0]));
    }

    public static <T, R> Collector<T, ?, Optional<R>> minMax(Comparator<? super T> comparator, BiFunction<? super T, ? super T, ? extends R> finisher) {
        Objects.requireNonNull(finisher);
        return MoreCollectors.pairing(Collectors.minBy(comparator), Collectors.maxBy(comparator), (min, max) -> min.isPresent() ? Optional.of(finisher.apply((Object)min.get(), (Object)max.get())) : Optional.empty());
    }

    public static <T, A, D> Collector<T, ?, D> maxAll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream) {
        Objects.requireNonNull(comparator);
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BinaryOperator downstreamCombiner = downstream.combiner();
        Supplier<Internals.PairBox> supplier = () -> new Internals.PairBox(downstreamSupplier.get(), Internals.none());
        BiConsumer<Internals.PairBox, Object> accumulator = (acc, t) -> {
            if (acc.b == Internals.NONE) {
                downstreamAccumulator.accept(acc.a, t);
                acc.b = t;
            } else {
                int cmp = comparator.compare(t, acc.b);
                if (cmp > 0) {
                    acc.a = downstreamSupplier.get();
                    acc.b = t;
                }
                if (cmp >= 0) {
                    downstreamAccumulator.accept(acc.a, t);
                }
            }
        };
        BinaryOperator combiner = (acc1, acc2) -> {
            if (acc2.b == Internals.NONE) {
                return acc1;
            }
            if (acc1.b == Internals.NONE) {
                return acc2;
            }
            int cmp = comparator.compare((Object)acc1.b, (Object)acc2.b);
            if (cmp > 0) {
                return acc1;
            }
            if (cmp < 0) {
                return acc2;
            }
            acc1.a = downstreamCombiner.apply(acc1.a, acc2.a);
            return acc1;
        };
        Function<Internals.PairBox, Object> finisher = acc -> downstream.finisher().apply(acc.a);
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, List<T>> maxAll(Comparator<? super T> comparator) {
        return MoreCollectors.maxAll(comparator, Collectors.toList());
    }

    public static <T extends Comparable<? super T>, A, D> Collector<T, ?, D> maxAll(Collector<T, A, D> downstream) {
        return MoreCollectors.maxAll(Comparator.naturalOrder(), downstream);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, List<T>> maxAll() {
        return MoreCollectors.maxAll(Comparator.naturalOrder(), Collectors.toList());
    }

    public static <T, A, D> Collector<T, ?, D> minAll(Comparator<? super T> comparator, Collector<T, A, D> downstream) {
        return MoreCollectors.maxAll(comparator.reversed(), downstream);
    }

    public static <T> Collector<T, ?, List<T>> minAll(Comparator<? super T> comparator) {
        return MoreCollectors.maxAll(comparator.reversed(), Collectors.toList());
    }

    public static <T extends Comparable<? super T>, A, D> Collector<T, ?, D> minAll(Collector<T, A, D> downstream) {
        return MoreCollectors.maxAll(Comparator.reverseOrder(), downstream);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, List<T>> minAll() {
        return MoreCollectors.maxAll(Comparator.reverseOrder(), Collectors.toList());
    }

    public static <T> Collector<T, ?, Optional<T>> onlyOne() {
        return new Internals.CancellableCollectorImpl<Object, Internals.Box, Optional>(Internals.Box::new, (box, t) -> {
            box.a = box.a == null ? Optional.of(t) : Optional.empty();
        }, (box1, box2) -> box1.a == null ? box2 : (box2.a == null ? box1 : new Internals.Box(Optional.empty())), box -> box.a == null ? Optional.empty() : (Optional)box.a, box -> box.a != null && !((Optional)box.a).isPresent(), Internals.UNORDERED_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, Optional<T>> onlyOne(Predicate<? super T> predicate) {
        return MoreCollectors.filtering(predicate, MoreCollectors.onlyOne());
    }

    public static <T> Collector<T, ?, Optional<T>> first() {
        return new Internals.CancellableCollectorImpl<Object, Internals.Box, Optional>(() -> new Internals.Box(Internals.none()), (box, t) -> {
            if (box.a == Internals.NONE) {
                box.a = t;
            }
        }, (box1, box2) -> box1.a == Internals.NONE ? box2 : box1, box -> box.a == Internals.NONE ? Optional.empty() : Optional.of(box.a), box -> box.a != Internals.NONE, Internals.NO_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, Optional<T>> last() {
        return Collector.of(() -> new Internals.Box(Internals.none()), (box, t) -> {
            box.a = t;
        }, (box1, box2) -> box2.a == Internals.NONE ? box1 : box2, box -> box.a == Internals.NONE ? Optional.empty() : Optional.of(box.a), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, List<T>> head(int n) {
        if (n <= 0) {
            return MoreCollectors.empty();
        }
        return new Internals.CancellableCollectorImpl(ArrayList::new, (acc, t) -> {
            if (acc.size() < n) {
                acc.add(t);
            }
        }, (acc1, acc2) -> {
            acc1.addAll(acc2.subList(0, Math.min(acc2.size(), n - acc1.size())));
            return acc1;
        }, Function.identity(), acc -> acc.size() >= n, Internals.ID_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, List<T>> tail(int n) {
        if (n <= 0) {
            return MoreCollectors.empty();
        }
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (acc.size() == n) {
                acc.pollFirst();
            }
            acc.addLast(t);
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, List<T>> greatest(Comparator<? super T> comparator, int n) {
        return MoreCollectors.least(comparator.reversed(), n);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, List<T>> greatest(int n) {
        return MoreCollectors.least(Comparator.reverseOrder(), n);
    }

    public static <T> Collector<T, ?, List<T>> least(Comparator<? super T> comparator, int n) {
        Objects.requireNonNull(comparator);
        if (n <= 0) {
            return MoreCollectors.empty();
        }
        if (n == 1) {
            return Collector.of(() -> new Internals.Box(Internals.none()), (box, t) -> {
                if (box.a == Internals.NONE || comparator.compare(t, box.a) < 0) {
                    box.a = t;
                }
            }, (box1, box2) -> box2.a != Internals.NONE && (box1.a == Internals.NONE || comparator.compare((Object)box2.a, (Object)box1.a) < 0) ? box2 : box1, box -> box.a == Internals.NONE ? new ArrayList() : new ArrayList(Collections.singleton(box.a)), new Collector.Characteristics[0]);
        }
        if (n >= 0x3FFFFFFF) {
            return MoreCollectors.collectingAndThen(Collectors.toList(), list -> {
                list.sort(comparator);
                if (list.size() <= n) {
                    return list;
                }
                return new ArrayList(list.subList(0, n));
            });
        }
        return Collector.of(() -> new Limiter(n, comparator), Limiter::put, Limiter::putAll, pq -> {
            pq.sort();
            return new ArrayList(pq);
        }, new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, List<T>> least(int n) {
        return MoreCollectors.least(Comparator.naturalOrder(), n);
    }

    public static <T> Collector<T, ?, OptionalLong> minIndex(Comparator<? super T> comparator) {
        class Container {
            T value;
            long count = 0L;
            long index = -1L;

            Container() {
            }
        }
        Objects.requireNonNull(comparator);
        return Collector.of(() -> new Container(), (c, t) -> {
            if (c.index == -1L || comparator.compare(c.value, t) > 0) {
                c.value = t;
                c.index = c.count;
            }
            ++c.count;
        }, (c1, c2) -> {
            if (c1.index == -1L || c2.index != -1L && comparator.compare((Object)c1.value, (Object)c2.value) > 0) {
                c2.index += c1.count;
                c2.count += c1.count;
                return c2;
            }
            c1.count += c2.count;
            return c1;
        }, c -> c.index == -1L ? OptionalLong.empty() : OptionalLong.of(c.index), new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, OptionalLong> minIndex() {
        return MoreCollectors.minIndex(Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, OptionalLong> maxIndex(Comparator<? super T> comparator) {
        return MoreCollectors.minIndex(comparator.reversed());
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, OptionalLong> maxIndex() {
        return MoreCollectors.minIndex(Comparator.reverseOrder());
    }

    public static <T, K extends Enum<K>, A, D> Collector<T, ?, EnumMap<K, D>> groupingByEnum(Class<K> enumClass, Function<? super T, K> classifier, Collector<? super T, A, D> downstream) {
        return MoreCollectors.groupingBy(classifier, EnumSet.allOf(enumClass), () -> new EnumMap(enumClass), downstream);
    }

    public static <T, K, D, A> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Set<K> domain, Collector<? super T, A, D> downstream) {
        return MoreCollectors.groupingBy(classifier, domain, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Set<K> domain, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Collector<Object, Map, M> groupingBy;
        Objects.requireNonNull(classifier);
        Objects.requireNonNull(domain);
        Objects.requireNonNull(mapFactory);
        Supplier downstreamSupplier = downstream.supplier();
        Function<Object, Object> supplier = k -> {
            if (!domain.contains(k)) {
                throw new IllegalStateException("Classifier returned value '" + k + "' which is out of domain");
            }
            return downstreamSupplier.get();
        };
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t));
            Object container = m.computeIfAbsent(key, supplier);
            downstreamAccumulator.accept((Object)container, (Object)t);
        };
        Internals.PartialCollector partial = Internals.PartialCollector.grouping(mapFactory, downstream);
        Predicate downstreamFinished = Internals.finished(downstream);
        if (downstreamFinished != null) {
            int size = domain.size();
            groupingBy = partial.asCancellable(accumulator, map -> {
                if (map.size() < size) {
                    return false;
                }
                for (Object container : map.values()) {
                    if (downstreamFinished.test(container)) continue;
                    return false;
                }
                return true;
            });
        } else {
            groupingBy = partial.asRef(accumulator);
        }
        return MoreCollectors.collectingAndThen(groupingBy, map -> {
            Function finisher = downstream.finisher();
            domain.forEach(arg_0 -> MoreCollectors.lambda$groupingBy$59(map, finisher, (Supplier)downstreamSupplier, arg_0));
            return map;
        });
    }

    public static <T, S extends Collection<T>> Collector<S, ?, Set<T>> intersecting() {
        return new Internals.CancellableCollectorImpl<Collection, Internals.Box, Set>(Internals.Box::new, (b, t) -> {
            if (b.a == null) {
                b.a = new HashSet(t);
            } else {
                ((Set)b.a).retainAll((Collection<?>)t);
            }
        }, (b1, b2) -> {
            if (b1.a == null) {
                return b2;
            }
            if (b2.a != null) {
                ((Set)b1.a).retainAll((Collection)b2.a);
            }
            return b1;
        }, b -> b.a == null ? Collections.emptySet() : (Set)b.a, b -> b.a != null && ((Set)b.a).isEmpty(), Internals.UNORDERED_CHARACTERISTICS);
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> downstream, Function<R, RR> finisher) {
        Predicate<A> finished = Internals.finished(downstream);
        if (finished != null) {
            return new Internals.CancellableCollectorImpl<T, A, RR>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), finished, downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? Internals.UNORDERED_CHARACTERISTICS : Internals.NO_CHARACTERISTICS);
        }
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> downstream) {
        Objects.requireNonNull(predicate);
        Predicate finished = Internals.finished(downstream);
        if (finished != null) {
            BiConsumer accumulator = downstream.accumulator();
            return Internals.BooleanMap.partialCollector(downstream).asCancellable((map, t) -> accumulator.accept((Object)(predicate.test(t) ? map.trueValue : map.falseValue), (Object)t), map -> finished.test(map.trueValue) && finished.test(map.falseValue));
        }
        return Collectors.partitioningBy(predicate, downstream);
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        Objects.requireNonNull(mapper);
        Predicate finished = Internals.finished(downstream);
        if (finished != null) {
            BiConsumer downstreamAccumulator = downstream.accumulator();
            return new Internals.CancellableCollectorImpl<Object, Object, R>(downstream.supplier(), (acc, t) -> {
                if (!finished.test(acc)) {
                    downstreamAccumulator.accept((Object)acc, (Object)mapper.apply(t));
                }
            }, downstream.combiner(), downstream.finisher(), finished, downstream.characteristics());
        }
        return Collectors.mapping(mapper, downstream);
    }

    public static <T, U> Collector<T, ?, List<U>> mapping(Function<? super T, ? extends U> mapper) {
        return Collectors.mapping(mapper, Collectors.toList());
    }

    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        Objects.requireNonNull(mapper);
        BiConsumer downstreamAccumulator = downstream.accumulator();
        Predicate finished = Internals.finished(downstream);
        if (finished != null) {
            return new Internals.CancellableCollectorImpl<Object, Object, R>(downstream.supplier(), (acc, t) -> {
                if (finished.test(acc)) {
                    return;
                }
                try (Stream stream = (Stream)mapper.apply(t);){
                    if (stream != null) {
                        stream.spliterator().forEachRemaining(u -> {
                            downstreamAccumulator.accept(acc, u);
                            if (finished.test(acc)) {
                                throw new Internals.CancelException();
                            }
                        });
                    }
                }
                catch (Internals.CancelException cancelException) {
                    // empty catch block
                }
            }, downstream.combiner(), downstream.finisher(), finished, downstream.characteristics());
        }
        return Collector.of(downstream.supplier(), (acc, t) -> {
            try (Stream stream = (Stream)mapper.apply(t);){
                if (stream != null) {
                    stream.spliterator().forEachRemaining(u -> downstreamAccumulator.accept(acc, u));
                }
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics().toArray(new Collector.Characteristics[0]));
    }

    public static <T, U> Collector<T, ?, List<U>> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper) {
        return MoreCollectors.flatMapping(mapper, Collectors.toList());
    }

    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<T, A, R> downstream) {
        Objects.requireNonNull(predicate);
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Object, Object> accumulator = (acc, t) -> {
            if (predicate.test(t)) {
                downstreamAccumulator.accept(acc, t);
            }
        };
        Predicate<A> finished = Internals.finished(downstream);
        if (finished != null) {
            return new Internals.CancellableCollectorImpl<Object, Object, R>(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), finished, downstream.characteristics());
        }
        return Collector.of(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), downstream.characteristics().toArray(new Collector.Characteristics[0]));
    }

    public static <T> Collector<T, ?, List<T>> filtering(Predicate<? super T> predicate) {
        return MoreCollectors.filtering(predicate, Collectors.toList());
    }

    public static <T> Collector<T, ?, OptionalInt> andingInt(ToIntFunction<T> mapper) {
        Objects.requireNonNull(mapper);
        return new Internals.CancellableCollectorImpl<Object, Internals.PrimitiveBox, OptionalInt>(Internals.PrimitiveBox::new, (acc, t) -> {
            if (!acc.b) {
                acc.i = mapper.applyAsInt(t);
                acc.b = true;
            } else {
                acc.i &= mapper.applyAsInt(t);
            }
        }, (acc1, acc2) -> {
            if (!acc1.b) {
                return acc2;
            }
            if (!acc2.b) {
                return acc1;
            }
            acc1.i &= acc2.i;
            return acc1;
        }, Internals.PrimitiveBox::asInt, acc -> acc.b && acc.i == 0, Internals.UNORDERED_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, OptionalLong> andingLong(ToLongFunction<T> mapper) {
        Objects.requireNonNull(mapper);
        return new Internals.CancellableCollectorImpl<Object, Internals.PrimitiveBox, OptionalLong>(Internals.PrimitiveBox::new, (acc, t) -> {
            if (!acc.b) {
                acc.l = mapper.applyAsLong(t);
                acc.b = true;
            } else {
                acc.l &= mapper.applyAsLong(t);
            }
        }, (acc1, acc2) -> {
            if (!acc1.b) {
                return acc2;
            }
            if (!acc2.b) {
                return acc1;
            }
            acc1.l &= acc2.l;
            return acc1;
        }, Internals.PrimitiveBox::asLong, acc -> acc.b && acc.l == 0L, Internals.UNORDERED_CHARACTERISTICS);
    }

    public static Collector<CharSequence, ?, String> commonPrefix() {
        BiConsumer<Internals.ObjIntBox, CharSequence> accumulator = (acc, t) -> {
            if (acc.b == -1) {
                acc.a = t;
                acc.b = t.length();
            } else if (acc.b > 0) {
                if (t.length() < acc.b) {
                    acc.b = t.length();
                }
                for (int i = 0; i < acc.b; ++i) {
                    if (((CharSequence)acc.a).charAt(i) == t.charAt(i)) continue;
                    if (i > 0 && Character.isHighSurrogate(t.charAt(i - 1)) && (Character.isLowSurrogate(t.charAt(i)) || Character.isLowSurrogate(((CharSequence)acc.a).charAt(i)))) {
                        --i;
                    }
                    acc.b = i;
                    break;
                }
            }
        };
        return new Internals.CancellableCollectorImpl<CharSequence, Internals.ObjIntBox, String>(() -> new Internals.ObjIntBox<Object>(null, -1), accumulator, (acc1, acc2) -> {
            if (acc1.b == -1) {
                return acc2;
            }
            if (acc2.b != -1) {
                accumulator.accept((Internals.ObjIntBox)acc1, ((CharSequence)acc2.a).subSequence(0, acc2.b));
            }
            return acc1;
        }, acc -> acc.a == null ? "" : ((CharSequence)acc.a).subSequence(0, acc.b).toString(), acc -> acc.b == 0, Internals.UNORDERED_CHARACTERISTICS);
    }

    public static Collector<CharSequence, ?, String> commonSuffix() {
        BiConsumer<Internals.ObjIntBox, CharSequence> accumulator = (acc, t) -> {
            if (acc.b == -1) {
                acc.a = t;
                acc.b = t.length();
            } else if (acc.b > 0) {
                int aLen = ((CharSequence)acc.a).length();
                int bLen = t.length();
                if (bLen < acc.b) {
                    acc.b = bLen;
                }
                for (int i = 0; i < acc.b; ++i) {
                    if (((CharSequence)acc.a).charAt(aLen - 1 - i) == t.charAt(bLen - 1 - i)) continue;
                    if (i > 0 && Character.isLowSurrogate(t.charAt(bLen - i)) && (Character.isHighSurrogate(t.charAt(bLen - 1 - i)) || Character.isHighSurrogate(((CharSequence)acc.a).charAt(aLen - 1 - i)))) {
                        --i;
                    }
                    acc.b = i;
                    break;
                }
            }
        };
        return new Internals.CancellableCollectorImpl<CharSequence, Internals.ObjIntBox, String>(() -> new Internals.ObjIntBox<Object>(null, -1), accumulator, (acc1, acc2) -> {
            if (acc1.b == -1) {
                return acc2;
            }
            if (acc2.b != -1) {
                accumulator.accept((Internals.ObjIntBox)acc1, ((CharSequence)acc2.a).subSequence(((CharSequence)acc2.a).length() - acc2.b, ((CharSequence)acc2.a).length()));
            }
            return acc1;
        }, acc -> acc.a == null ? "" : ((CharSequence)acc.a).subSequence(((CharSequence)acc.a).length() - acc.b, ((CharSequence)acc.a).length()).toString(), acc -> acc.b == 0, Internals.UNORDERED_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, List<T>> dominators(BiPredicate<? super T, ? super T> isDominator) {
        Objects.requireNonNull(isDominator);
        return Collector.of(ArrayList::new, (acc, t) -> {
            if (acc.isEmpty() || !isDominator.test((Object)acc.get(acc.size() - 1), (Object)t)) {
                acc.add(t);
            }
        }, (acc1, acc2) -> {
            int i;
            if (acc1.isEmpty()) {
                return acc2;
            }
            int l = acc2.size();
            Object last = acc1.get(acc1.size() - 1);
            for (i = 0; i < l && isDominator.test((Object)last, (Object)acc2.get(i)); ++i) {
            }
            if (i < l) {
                acc1.addAll(acc2.subList(i, l));
            }
            return acc1;
        }, new Collector.Characteristics[0]);
    }

    public static <T, A, R> Collector<T, ?, Optional<R>> ifAllMatch(Predicate<T> predicate, Collector<T, A, R> downstream) {
        Objects.requireNonNull(predicate);
        Predicate finished = Internals.finished(downstream);
        Supplier supplier = downstream.supplier();
        BiConsumer accumulator = downstream.accumulator();
        BinaryOperator combiner = downstream.combiner();
        return new Internals.CancellableCollectorImpl<Object, Internals.PairBox, Optional>(() -> new Internals.PairBox(supplier.get(), Boolean.TRUE), (acc, t) -> {
            if (((Boolean)acc.b).booleanValue() && predicate.test(t)) {
                accumulator.accept(acc.a, t);
            } else {
                acc.b = Boolean.FALSE;
            }
        }, (acc1, acc2) -> {
            if (((Boolean)acc1.b).booleanValue() && ((Boolean)acc2.b).booleanValue()) {
                acc1.a = combiner.apply(acc1.a, acc2.a);
            } else {
                acc1.b = Boolean.FALSE;
            }
            return acc1;
        }, acc -> (Boolean)acc.b != false ? Optional.of(downstream.finisher().apply(acc.a)) : Optional.empty(), finished == null ? acc -> (Boolean)acc.b == false : acc -> (Boolean)acc.b == false || finished.test(acc.a), downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? Internals.UNORDERED_CHARACTERISTICS : Internals.NO_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, Optional<T>> reducingWithZero(T zero, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        return new Internals.CancellableCollectorImpl<Object, Internals.ObjIntBox, Optional>(() -> new Internals.ObjIntBox<Object>(null, 0), (acc, t) -> {
            if (acc.b != 2) {
                if (acc.b == 1) {
                    t = op.apply(t, acc.a);
                }
                if (Objects.equals(t, zero)) {
                    acc.b = 2;
                    acc.a = zero;
                } else {
                    acc.b = 1;
                    acc.a = t;
                }
            }
        }, (acc1, acc2) -> {
            if (acc1.b == 0 || acc2.b == 2) {
                return acc2;
            }
            if (acc2.b == 0 || acc1.b == 2) {
                return acc1;
            }
            Object t = op.apply(acc1.a, acc2.a);
            if (Objects.equals(t, zero)) {
                acc1.b = 2;
                acc1.a = zero;
            } else {
                acc1.a = t;
            }
            return acc1;
        }, acc -> acc.b == 0 ? Optional.empty() : Optional.of(acc.a), acc -> acc.b == 2, Internals.UNORDERED_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, T> reducingWithZero(T zero, T identity, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        return new Internals.CancellableCollectorImpl<Object, Internals.ObjIntBox, Object>(() -> new Internals.ObjIntBox<Object>(identity, 1), (acc, t) -> {
            if (acc.b != 2) {
                if (Objects.equals(t = op.apply(t, acc.a), zero)) {
                    acc.b = 2;
                    acc.a = zero;
                } else {
                    acc.b = 1;
                    acc.a = t;
                }
            }
        }, (acc1, acc2) -> {
            if (acc2.b == 2) {
                return acc2;
            }
            if (acc1.b == 2) {
                return acc1;
            }
            Object t = op.apply(acc1.a, acc2.a);
            if (Objects.equals(t, zero)) {
                acc1.b = 2;
                acc1.a = zero;
            } else {
                acc1.a = t;
            }
            return acc1;
        }, acc -> acc.a, acc -> acc.b == 2, Internals.UNORDERED_CHARACTERISTICS);
    }

    private static /* synthetic */ void lambda$groupingBy$59(Map map, Function finisher, Supplier downstreamSupplier, Object key) {
        map.computeIfAbsent(key, arg_0 -> MoreCollectors.lambda$groupingBy$58(finisher, (Supplier)downstreamSupplier, arg_0));
    }

    private static /* synthetic */ Object lambda$groupingBy$58(Function finisher, Supplier downstreamSupplier, Object k) {
        return finisher.apply(downstreamSupplier.get());
    }
}

