/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.LazyBeanEntry;

final class BeanCache<Q extends Annotation, T> {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceFieldUpdater<BeanCache, Object> MAPPING_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BeanCache.class, Object.class, "mapping");
    private volatile Object mapping;
    private Map<Binding<T>, BeanEntry<Q, T>> readCache;
    private volatile boolean mutated;

    BeanCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> create(Q qualifier, Binding<T> binding, int rank) {
        LazyBeanEntry<Q, T> newBean;
        Object n;
        Object o;
        do {
            if (null == (o = this.mapping)) {
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n = newBean;
                continue;
            }
            if (o instanceof LazyBeanEntry) {
                LazyBeanEntry oldBean = (LazyBeanEntry)o;
                if (binding == oldBean.binding) {
                    return oldBean;
                }
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n = BeanCache.createMap(oldBean, newBean);
                continue;
            }
            BeanCache beanCache = this;
            synchronized (beanCache) {
                Map map2 = (Map)o;
                newBean = (LazyBeanEntry<Q, T>)map2.get(binding);
                if (null == newBean) {
                    newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                    map2.put(binding, newBean);
                    this.mutated = true;
                }
                return newBean;
            }
        } while (!MAPPING_UPDATER.compareAndSet(this, o, n));
        if (n instanceof IdentityHashMap) {
            this.mutated = true;
        }
        return newBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Binding<T>, BeanEntry<Q, T>> flush() {
        if (this.mutated) {
            BeanCache beanCache = this;
            synchronized (beanCache) {
                if (this.mutated) {
                    this.readCache = (Map)((IdentityHashMap)this.mapping).clone();
                    this.mutated = false;
                }
            }
        }
        return this.readCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Binding<T>> bindings() {
        Object o = this.mapping;
        if (null == o) {
            return Collections.EMPTY_SET;
        }
        if (o instanceof LazyBeanEntry) {
            return Collections.singleton(((LazyBeanEntry)o).binding);
        }
        BeanCache beanCache = this;
        synchronized (beanCache) {
            return new ArrayList<Binding<T>>(((Map)o).keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> remove(Binding<T> binding) {
        LazyBeanEntry oldBean;
        Object n;
        Object o;
        do {
            if (null == (o = this.mapping)) {
                return null;
            }
            if (o instanceof LazyBeanEntry) {
                oldBean = (LazyBeanEntry)o;
                if (binding != oldBean.binding) {
                    return null;
                }
            } else {
                BeanCache beanCache = this;
                synchronized (beanCache) {
                    oldBean = (LazyBeanEntry)((Map)o).remove(binding);
                    if (null != oldBean) {
                        this.mutated = true;
                    }
                    return oldBean;
                }
            }
            n = null;
        } while (!MAPPING_UPDATER.compareAndSet(this, o, n));
        return oldBean;
    }

    private static Map createMap(LazyBeanEntry one, LazyBeanEntry two) {
        IdentityHashMap map2 = new IdentityHashMap(10);
        map2.put(one.binding, one);
        map2.put(two.binding, two);
        return map2;
    }
}

