/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.Implementations;
import org.eclipse.sisu.inject.ImplicitBindings;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.LocatedBeans;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MildConcurrentValues;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankedBindings;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.inject.WatchedBeans;
import org.eclipse.sisu.inject.Weak;

@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<Long, RankedBindings> cachedBindings = Weak.concurrentValues(256, 1);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);
    private final Long[] typeIdHolder = new Long[1];
    private final ReentrantReadWriteLock publisherLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = this.fetchBindings(type, null);
        if (null == bindings) {
            ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
            synchronized (concurrentMap) {
                bindings = this.fetchBindings(type, this.typeIdHolder);
                if (null == bindings) {
                    bindings = new RankedBindings(type, this.publishers);
                    this.cachedBindings.put(this.typeIdHolder[0], bindings);
                }
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeArguments.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Key key, Mediator mediator, Object watcher) {
        this.publisherLock.readLock().lock();
        try {
            WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
            for (BindingPublisher p : this.publishers()) {
                p.subscribe(beans);
            }
            Map<WatchedBeans, Object> map2 = this.cachedWatchers;
            synchronized (map2) {
                this.cachedWatchers.put(beans, watcher);
            }
        }
        finally {
            this.publisherLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(BindingPublisher publisher) {
        WatchedBeans[] currentWatchers;
        this.publisherLock.writeLock().lock();
        try {
            if (this.publishers.contains(publisher)) {
                boolean bl = false;
                return bl;
            }
            Logs.trace("Add publisher: {}", publisher, null);
            WatchedBeans[] watchedBeansArray = this.cachedBindings;
            synchronized (watchedBeansArray) {
                int rank = publisher.maxBindingRank();
                this.publishers.insert(publisher, rank);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.add(publisher, rank);
                }
            }
            watchedBeansArray = this.cachedWatchers;
            synchronized (watchedBeansArray) {
                currentWatchers = this.cachedWatchers.keySet().toArray(new WatchedBeans[0]);
            }
            this.publisherLock.readLock().lock();
        }
        finally {
            this.publisherLock.writeLock().unlock();
        }
        try {
            for (WatchedBeans beans : currentWatchers) {
                publisher.subscribe(beans);
            }
        }
        finally {
            this.publisherLock.readLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(BindingPublisher publisher) {
        WatchedBeans[] currentWatchers;
        BindingPublisher oldPublisher;
        this.publisherLock.writeLock().lock();
        try {
            WatchedBeans[] watchedBeansArray = this.cachedBindings;
            synchronized (watchedBeansArray) {
                block16: {
                    oldPublisher = this.publishers.remove(publisher);
                    if (null != oldPublisher) break block16;
                    boolean bl = false;
                    return bl;
                }
                Logs.trace("Remove publisher: {}", oldPublisher, null);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.remove(oldPublisher);
                }
            }
            watchedBeansArray = this.cachedWatchers;
            synchronized (watchedBeansArray) {
                currentWatchers = this.cachedWatchers.keySet().toArray(new WatchedBeans[0]);
            }
            this.publisherLock.readLock().lock();
        }
        finally {
            this.publisherLock.writeLock().unlock();
        }
        try {
            for (WatchedBeans beans : currentWatchers) {
                oldPublisher.unsubscribe(beans);
            }
        }
        finally {
            this.publisherLock.readLock().unlock();
        }
        ((MildConcurrentValues)this.cachedBindings).compact();
        return true;
    }

    @Override
    public Iterable<BindingPublisher> publishers() {
        return this.publishers.snapshot();
    }

    @Override
    public void clear() {
        for (BindingPublisher p : this.publishers()) {
            this.remove(p);
        }
    }

    private RankedBindings fetchBindings(TypeLiteral type, Long[] idReturn) {
        RankedBindings result;
        int loaderHash = System.identityHashCode(type.getRawType().getClassLoader());
        long id = (long)type.hashCode() << 32 | 0xFFFFFFFFL & (long)loaderHash;
        while (null != (result = (RankedBindings)this.cachedBindings.get(id)) && !type.equals(result.type())) {
            ++id;
        }
        if (null != idReturn) {
            idReturn[0] = id;
        }
        return result;
    }

    @Inject
    void autoPublish(Injector injector) {
        this.add(InjectorBindings.findBindingPublisher(injector));
    }

    @Inject
    static void autoPublishChild(Injector childInjector) {
        Binding locatorBinding = childInjector.getBinding(MutableBeanLocator.class);
        if (DefaultBeanLocator.class.equals(Implementations.find(locatorBinding))) {
            ((DefaultBeanLocator)locatorBinding.getProvider().get()).autoPublish(childInjector);
        }
    }
}

