/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public class ShouldContainOnlyKeys
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainOnlyKeys(Object actual, Object expected, Object notFound, Object notExpected) {
        return new ShouldContainOnlyKeys(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainOnlyKeys(Object actual, Object expected, Object notFound, Iterable<?> notExpected) {
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldContainOnlyKeys(actual, expected, notFound, StandardComparisonStrategy.instance());
        }
        return new ShouldContainOnlyKeys(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    private ShouldContainOnlyKeys(Object actual, Object expected, Object notFound, Object notExpected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain only following keys:%n  %s%nkeys not found:%n  %s%nand keys not expected:%n  %s%n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainOnlyKeys(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain only following keys:%n  %s%nbut could not find the following keys:%n  %s%n%s", actual, expected, notFound, comparisonStrategy);
    }
}

