/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.EventQueueImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;

public class InternalEventHandler
implements Runnable {
    final EventQueueImpl queue;
    final VirtualMachineImpl vm;

    InternalEventHandler(VirtualMachineImpl vm, EventQueueImpl queue) {
        this.vm = vm;
        this.queue = queue;
        Thread thread = new Thread(vm.threadGroupForJDI(), this, "JDI Internal Event Handler");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Internal event handler running");
        }
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                try {
                    block9: while (true) {
                        eventSet = this.queue.removeInternal();
                        it = eventSet.eventIterator();
                        while (true) {
                            if (!it.hasNext()) continue block9;
                            event = it.nextEvent();
                            if (event instanceof ClassUnloadEvent) {
                                cuEvent = (ClassUnloadEvent)event;
                                this.vm.removeReferenceType(cuEvent.classSignature());
                                if ((this.vm.traceFlags & 4) == 0) continue;
                                this.vm.printTrace("Handled Unload Event for " + cuEvent.classSignature());
                                continue;
                            }
                            if (!(event instanceof ClassPrepareEvent)) continue;
                            cpEvent = (ClassPrepareEvent)event;
                            ((ReferenceTypeImpl)cpEvent.referenceType()).markPrepared();
                            if ((this.vm.traceFlags & 4) == 0) continue;
                            this.vm.printTrace("Handled Prepare Event for " + cpEvent.referenceType().name());
                        }
                        break;
                    }
                }
                catch (VMOutOfMemoryException vmme) {
                    vmme.printStackTrace();
                }
                catch (InconsistentDebugInfoException idie) {
                    idie.printStackTrace();
                }
                catch (ObjectCollectedException oce) {
                    oce.printStackTrace();
                }
                catch (ClassNotPreparedException cnpe) {
                    cnpe.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException var1_6) {
        }
        catch (VMDisconnectedException var1_7) {
            // empty catch block
        }
        ** GOTO lbl-1000
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Internal event handler exiting");
        }
    }
}

