/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.bundles.TextMateResourceReader;
import org.jetbrains.plugins.textmate.logging.TextMateLogger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/textmate/bundles/TextMateNioResourceReader;", "Lorg/jetbrains/plugins/textmate/bundles/TextMateResourceReader;", "directory", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "list", "", "", "relativePath", "read", "", "Companion", "intellij.textmate.core"})
public final class TextMateNioResourceReader
implements TextMateResourceReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    @NotNull
    private static final TextMateLogger LOG = MultiplatformKt.getLogger(Reflection.getOrCreateKotlinClass(TextMateNioResourceReader.class));

    public TextMateNioResourceReader(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String relativePath) {
        Object object;
        Object $this$list_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Object object2 = this;
        try {
            List<String> list;
            $this$list_u24lambda_u240 = object2;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.list(((TextMateNioResourceReader)$this$list_u24lambda_u240).directory.resolve(relativePath));
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                list = stream.filter(arg_0 -> TextMateNioResourceReader.list$lambda$0$0$1(TextMateNioResourceReader::list$lambda$0$0$0, arg_0)).map(arg_0 -> TextMateNioResourceReader.list$lambda$0$0$3(TextMateNioResourceReader::list$lambda$0$0$2, arg_0)).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            $this$list_u24lambda_u240 = Result.constructor-impl(list);
        }
        catch (Throwable bl) {
            $this$list_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$list_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            if (!(e instanceof NoSuchFileException)) {
                LOG.warn(e, (Function0<String>)((Function0)() -> TextMateNioResourceReader.list$lambda$1$0(relativePath)));
            }
            object = CollectionsKt.emptyList();
        }
        return (List)object;
    }

    @Override
    @Nullable
    public byte[] read(@NotNull String relativePath) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            Path path = this.directory.resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            byte[] byArray2 = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            byArray = byArray2;
        }
        catch (NoSuchFileException noSuchFileException) {
            LOG.warn((Function0<String>)((Function0)() -> TextMateNioResourceReader.read$lambda$0(relativePath, this)));
            byArray = null;
        }
        catch (Throwable e) {
            LOG.warn(e, (Function0<String>)((Function0)() -> TextMateNioResourceReader.read$lambda$1(relativePath, this)));
            byArray = null;
        }
        return byArray;
    }

    private static final boolean list$lambda$0$0$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean list$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String list$lambda$0$0$2(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return PathsKt.getName((Path)it);
    }

    private static final String list$lambda$0$0$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String list$lambda$1$0(String $relativePath) {
        return "Can't load plists from `" + $relativePath + "`";
    }

    private static final String read$lambda$0(String $relativePath, TextMateNioResourceReader this$0) {
        return "Cannot find referenced file `" + $relativePath + "` in bundle `" + this$0.directory + "`";
    }

    private static final String read$lambda$1(String $relativePath, TextMateNioResourceReader this$0) {
        return "Cannot read referenced file `" + $relativePath + "` in bundle `" + this$0.directory + "`";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/textmate/bundles/TextMateNioResourceReader$Companion;", "", "<init>", "()V", "LOG", "Lorg/jetbrains/plugins/textmate/logging/TextMateLogger;", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

