/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.util.CommandDefaultOptions;

public class CommandLineUtils {
    public static boolean isPrintHelpNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.args.length == 0 || commandOpts.options.has(commandOpts.helpOpt);
    }

    public static boolean isPrintVersionNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.options.has(commandOpts.versionOpt);
    }

    public static void maybePrintHelpOrVersion(CommandDefaultOptions commandOpts, String message) {
        if (CommandLineUtils.isPrintHelpNeeded(commandOpts)) {
            CommandLineUtils.printUsageAndExit(commandOpts.parser, message);
        }
        if (CommandLineUtils.isPrintVersionNeeded(commandOpts)) {
            CommandLineUtils.printVersionAndExit();
        }
    }

    public static void checkRequiredArgs(OptionParser parser, OptionSet options, OptionSpec<?> ... requiredList) {
        for (OptionSpec<?> arg : requiredList) {
            if (options.has(arg)) continue;
            CommandLineUtils.printUsageAndExit(parser, String.format("Missing required argument \"%s\"", arg));
        }
    }

    public static void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, OptionSpec<?> ... invalidOptions) {
        if (options.has(usedOption)) {
            for (OptionSpec<?> arg : invalidOptions) {
                if (!options.has(arg)) continue;
                CommandLineUtils.printUsageAndExit(parser, String.format("Option \"%s\" can't be used with option \"%s\"", usedOption, arg));
            }
        }
    }

    public static void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, Set<OptionSpec<?>> invalidOptions) {
        OptionSpec[] array = new OptionSpec[invalidOptions.size()];
        invalidOptions.toArray(array);
        CommandLineUtils.checkInvalidArgs(parser, options, usedOption, array);
    }

    public static void checkInvalidArgsSet(OptionParser parser, OptionSet options, Set<OptionSpec<?>> usedOptions, Set<OptionSpec<?>> invalidOptions, Optional<String> trailingAdditionalMessage) {
        if (usedOptions.stream().filter(arg_0 -> ((OptionSet)options).has(arg_0)).count() == (long)usedOptions.size()) {
            for (OptionSpec<?> arg : invalidOptions) {
                if (!options.has(arg)) continue;
                CommandLineUtils.printUsageAndExit(parser, String.format("Option combination \"%s\" can't be used with option \"%s\"%s", usedOptions, arg, trailingAdditionalMessage.orElse("")));
            }
        }
    }

    public static void printErrorAndExit(String message) {
        System.err.println(message);
        Exit.exit((int)1, (String)message);
    }

    public static void checkOneOfArgs(OptionParser parser, OptionSet options, OptionSpec<?> ... optionSpecs) {
        if (optionSpecs == null || optionSpecs.length == 0) {
            throw new IllegalArgumentException("At least one option must be provided");
        }
        int presentCount = 0;
        for (OptionSpec<?> spec : optionSpecs) {
            if (!options.has(spec)) continue;
            ++presentCount;
        }
        if (presentCount != 1) {
            CommandLineUtils.printUsageAndExit(parser, "Exactly one of the following arguments is required: " + Arrays.stream(optionSpecs).map(Object::toString).collect(Collectors.joining(", ")));
        }
    }

    public static void printUsageAndExit(OptionParser parser, String message) {
        System.err.println(message);
        try {
            parser.printHelpOn((OutputStream)System.err);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Exit.exit((int)1, (String)message);
    }

    public static void printVersionAndExit() {
        System.out.println(AppInfoParser.getVersion());
        Exit.exit((int)0);
    }

    public static Properties parseKeyValueArgs(List<String> args) {
        return CommandLineUtils.parseKeyValueArgs(args, true);
    }

    public static Properties parseKeyValueArgs(List<String> args, boolean acceptMissingValue) {
        Properties props = new Properties();
        ArrayList splits = new ArrayList();
        args.forEach(arg -> {
            String[] split = arg.split("=", 2);
            if (split.length > 0) {
                splits.add(split);
            }
        });
        splits.forEach(split -> {
            if (((String[])split).length == 1 || ((String[])split).length == 2 && (split[1] == null || split[1].isEmpty())) {
                if (!acceptMissingValue) throw new IllegalArgumentException(String.format("Missing value for key %s}", split[0]));
                props.put(split[0], "");
                return;
            } else {
                props.put(split[0], split[1]);
            }
        });
        return props;
    }

    public static <T> void maybeMergeOptions(Properties props, String key, OptionSet options, OptionSpec<T> spec) {
        if (options.has(spec) || !props.containsKey(key)) {
            Object value = options.valueOf(spec);
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, value.toString());
            }
        }
    }

    public static void initializeBootstrapProperties(Properties properties, Optional<String> bootstrapServer, Optional<String> bootstrapControllers) {
        if (bootstrapServer.isPresent()) {
            if (bootstrapControllers.isPresent()) {
                throw new InitializeBootstrapException("You cannot specify both --bootstrap-controller and --bootstrap-server.");
            }
            properties.setProperty("bootstrap.servers", bootstrapServer.get());
            properties.remove("bootstrap.controllers");
        } else if (bootstrapControllers.isPresent()) {
            properties.remove("bootstrap.servers");
            properties.setProperty("bootstrap.controllers", bootstrapControllers.get());
        } else {
            throw new InitializeBootstrapException("You must specify either --bootstrap-controller or --bootstrap-server.");
        }
    }

    public static void initializeBootstrapProperties(OptionParser parser, OptionSet options, Properties properties, OptionSpec<String> bootstrapServer, OptionSpec<String> bootstrapControllers) {
        try {
            CommandLineUtils.initializeBootstrapProperties(properties, options.has(bootstrapServer) ? Optional.of((String)options.valueOf(bootstrapServer)) : Optional.empty(), options.has(bootstrapControllers) ? Optional.of((String)options.valueOf(bootstrapControllers)) : Optional.empty());
        }
        catch (InitializeBootstrapException e) {
            CommandLineUtils.printUsageAndExit(parser, e.getMessage());
        }
    }

    static class InitializeBootstrapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InitializeBootstrapException(String message) {
            super(message);
        }
    }
}

