/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataDelta;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShard;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.slf4j.Logger;

public class SnapshottableCoordinator<S extends CoordinatorShard<U>, U>
implements CoordinatorPlayback<U> {
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final S coordinator;
    private final TopicPartition tp;
    private long lastWrittenOffset;
    private long lastCommittedOffset;

    public SnapshottableCoordinator(LogContext logContext, SnapshotRegistry snapshotRegistry, S coordinator, TopicPartition tp) {
        this.log = logContext.logger(SnapshottableCoordinator.class);
        this.coordinator = coordinator;
        this.snapshotRegistry = snapshotRegistry;
        this.tp = tp;
        this.lastWrittenOffset = 0L;
        this.lastCommittedOffset = 0L;
        snapshotRegistry.idempotentCreateSnapshot(0L);
    }

    synchronized void revertLastWrittenOffset(long offset) {
        if (offset > this.lastWrittenOffset) {
            throw new IllegalStateException("New offset " + offset + " of " + String.valueOf(this.tp) + " must be smaller than " + this.lastWrittenOffset + ".");
        }
        this.log.debug("Revert last written offset of {} to {}.", (Object)this.tp, (Object)offset);
        this.lastWrittenOffset = offset;
        this.snapshotRegistry.revertToSnapshot(offset);
    }

    @Override
    public synchronized void replay(long offset, long producerId, short producerEpoch, U record) {
        this.coordinator.replay(offset, producerId, producerEpoch, record);
    }

    @Override
    public synchronized void replayEndTransactionMarker(long producerId, short producerEpoch, TransactionResult result) {
        this.coordinator.replayEndTransactionMarker(producerId, producerEpoch, result);
    }

    @Override
    public synchronized void updateLastWrittenOffset(long offset) {
        if (offset <= this.lastWrittenOffset) {
            throw new IllegalStateException("New last written offset " + offset + " of " + String.valueOf(this.tp) + " must be greater than " + this.lastWrittenOffset + ".");
        }
        this.lastWrittenOffset = offset;
        this.snapshotRegistry.idempotentCreateSnapshot(offset);
        this.log.debug("Updated last written offset of {} to {}.", (Object)this.tp, (Object)offset);
    }

    @Override
    public synchronized void updateLastCommittedOffset(long offset) {
        if (offset < this.lastCommittedOffset) {
            throw new IllegalStateException("New committed offset " + offset + " of " + String.valueOf(this.tp) + " must be greater than or equal to " + this.lastCommittedOffset + ".");
        }
        if (offset > this.lastWrittenOffset) {
            throw new IllegalStateException("New committed offset " + offset + " of " + String.valueOf(this.tp) + " must be less than or equal to " + this.lastWrittenOffset + ".");
        }
        this.lastCommittedOffset = offset;
        this.snapshotRegistry.deleteSnapshotsUpTo(offset);
        this.log.debug("Updated committed offset of {} to {}.", (Object)this.tp, (Object)offset);
    }

    synchronized void onLoaded(CoordinatorMetadataImage newImage) {
        this.coordinator.onLoaded(newImage);
    }

    synchronized void onUnloaded() {
        if (this.coordinator != null) {
            this.coordinator.onUnloaded();
        }
    }

    synchronized long lastWrittenOffset() {
        return this.lastWrittenOffset;
    }

    synchronized void onNewMetadataImage(CoordinatorMetadataImage newImage, CoordinatorMetadataDelta delta) {
        this.coordinator.onNewMetadataImage(newImage, delta);
    }

    synchronized long lastCommittedOffset() {
        return this.lastCommittedOffset;
    }

    synchronized S coordinator() {
        return this.coordinator;
    }

    synchronized SnapshotRegistry snapshotRegistry() {
        return this.snapshotRegistry;
    }
}

