/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.ad.model.Action;
import org.opensearch.ad.model.Condition;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class Rule
implements Writeable,
ToXContentObject {
    private static final String ACTION_FIELD = "action";
    private static final String CONDITIONS_FIELD = "conditions";
    private Action action;
    private List<Condition> conditions;

    public Rule(Action action, List<Condition> conditions) {
        this.action = action;
        this.conditions = conditions;
    }

    public Rule(StreamInput input) throws IOException {
        this.action = (Action)input.readEnum(Action.class);
        this.conditions = input.readList(Condition::new);
    }

    public static Rule parse(XContentParser parser) throws IOException {
        Action action = null;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "action": {
                    action = Action.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "conditions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        conditions.add(Condition.parse(parser));
                    }
                    break;
                }
            }
        }
        return new Rule(action, conditions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(ACTION_FIELD, (Object)this.action).field(CONDITIONS_FIELD, (Object)this.conditions.toArray());
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.action);
        out.writeList(this.conditions);
    }

    public Action getAction() {
        return this.action;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Rule that = (Rule)o;
        return Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal(this.conditions, that.conditions);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.action, this.conditions});
        return result;
    }

    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append(ACTION_FIELD, (Object)this.action).append(CONDITIONS_FIELD, this.conditions).toString();
    }
}

