/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.util.ParseUtils;

public class ForecasterExecutionInput
implements ToXContentObject {
    private static final String FORECASTER_ID_FIELD = "forecaster_id";
    private static final String PERIOD_START_FIELD = "period_start";
    private static final String PERIOD_END_FIELD = "period_end";
    private static final String FORECASTER_FIELD = "forecaster";
    private Instant periodStart;
    private Instant periodEnd;
    private String forecasterId;
    private Forecaster forecaster;

    public ForecasterExecutionInput(String forecasterId, Instant periodStart, Instant periodEnd, Forecaster forecaster) {
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.forecasterId = forecasterId;
        this.forecaster = forecaster;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(FORECASTER_ID_FIELD, this.forecasterId).field(PERIOD_START_FIELD, this.periodStart.toEpochMilli()).field(PERIOD_END_FIELD, this.periodEnd.toEpochMilli()).field(FORECASTER_FIELD, (ToXContent)this.forecaster);
        return xContentBuilder.endObject();
    }

    public static ForecasterExecutionInput parse(XContentParser parser) throws IOException {
        return ForecasterExecutionInput.parse(parser, null);
    }

    public static ForecasterExecutionInput parse(XContentParser parser, String inputConfigId) throws IOException {
        Instant periodStart = null;
        Instant periodEnd = null;
        Forecaster forecaster = null;
        String forecasterId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "forecaster_id": {
                    forecasterId = parser.text();
                    break;
                }
                case "period_start": {
                    periodStart = ParseUtils.toInstant(parser);
                    break;
                }
                case "period_end": {
                    periodEnd = ParseUtils.toInstant(parser);
                    break;
                }
                case "forecaster": {
                    XContentParser.Token token = parser.currentToken();
                    if (!parser.currentToken().equals((Object)XContentParser.Token.START_OBJECT)) break;
                    forecaster = Forecaster.parse(parser, forecasterId);
                    break;
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)inputConfigId)) {
            forecasterId = inputConfigId;
        }
        return new ForecasterExecutionInput(forecasterId, periodStart, periodEnd, forecaster);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecasterExecutionInput that = (ForecasterExecutionInput)o;
        return Objects.equal((Object)this.periodStart, (Object)that.periodStart) && Objects.equal((Object)this.periodEnd, (Object)that.periodEnd) && Objects.equal((Object)this.forecasterId, (Object)that.forecasterId) && Objects.equal((Object)this.forecaster, (Object)that.forecaster);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.periodStart, this.periodEnd, this.forecasterId});
    }

    public Instant getPeriodStart() {
        return this.periodStart;
    }

    public Instant getPeriodEnd() {
        return this.periodEnd;
    }

    public String getForecasterId() {
        return this.forecasterId;
    }

    public void setForecasterId(String forecasterId) {
        this.forecasterId = forecasterId;
    }

    public Forecaster getForecaster() {
        return this.forecaster;
    }
}

