"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFormFieldset", {
  enumerable: true,
  get: function get() {
    return _form_fieldset.EuiFormFieldset;
  }
});
exports.OuiFormFieldset = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _form_legend = require("./form_legend");
var _form_fieldset = require("../../../eui_components/form/form_fieldset/form_fieldset");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var OuiFormFieldset = function OuiFormFieldset(_ref) {
  var children = _ref.children,
    className = _ref.className,
    legend = _ref.legend,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "legend"]);
  var legendDisplay = !!legend && /*#__PURE__*/_react.default.createElement(_form_legend.OuiFormLegend, legend);
  return /*#__PURE__*/_react.default.createElement("fieldset", (0, _extends2.default)({
    className: className
  }, rest), legendDisplay, children);
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiFormFieldset = OuiFormFieldset;
OuiFormFieldset.propTypes = {
  /**
     * Adds an OuiFormLegend element as the first child
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  }),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */