/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.search.processor.mmr;

import lombok.Generated;
import org.opensearch.core.action.ActionListener;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.search.processor.mmr.MMRQueryTransformer;
import org.opensearch.knn.search.processor.mmr.MMRRerankContext;
import org.opensearch.knn.search.processor.mmr.MMRTransformContext;
import org.opensearch.knn.search.processor.mmr.MMRUtil;
import org.opensearch.knn.search.processor.mmr.MMRVectorFieldInfo;

public class MMRKnnQueryTransformer
implements MMRQueryTransformer<KNNQueryBuilder> {
    @Override
    public void transform(KNNQueryBuilder queryBuilder, ActionListener<Void> listener, MMRTransformContext mmrTransformContext) {
        try {
            if (queryBuilder.getMaxDistance() == null && queryBuilder.getMinScore() == null) {
                queryBuilder.setK(mmrTransformContext.getCandidates());
            }
            if (mmrTransformContext.isVectorFieldInfoResolved()) {
                listener.onResponse(null);
                return;
            }
            MMRRerankContext mmrRerankContext = mmrTransformContext.getMmrRerankContext();
            String knnVectorFieldPath = queryBuilder.fieldName();
            if (knnVectorFieldPath == null) {
                throw new IllegalArgumentException("Failed to transform the knn query for MMR. Field name of the knn query should not be null.");
            }
            mmrRerankContext.setVectorFieldPath(knnVectorFieldPath);
            MMRUtil.resolveKnnVectorFieldInfo(knnVectorFieldPath, mmrTransformContext.getUserProvidedSpaceType(), mmrTransformContext.getUserProvidedVectorDataType(), mmrTransformContext.getLocalIndexMetadataList(), mmrTransformContext.getClient(), (ActionListener<MMRVectorFieldInfo>)ActionListener.wrap(vectorFieldInfo -> {
                mmrRerankContext.setVectorDataType(vectorFieldInfo.getVectorDataType());
                mmrRerankContext.setSpaceType(vectorFieldInfo.getSpaceType());
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public String getQueryName() {
        return "knn";
    }

    @Generated
    public MMRKnnQueryTransformer() {
    }
}

