/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LabsLogFormatter
extends Formatter {
    private static final Logger logger = Logger.getLogger(LabsLogFormatter.class.getName());
    private boolean terse;

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public boolean getTerse() {
        return this.terse;
    }

    @Override
    public String format(LogRecord record) {
        String message = this.formatMessage(record);
        if (this.terse) {
            return message + '\n';
        }
        String cn = record.getSourceClassName();
        int p = cn.lastIndexOf(46);
        if (p > 0) {
            cn = cn.substring(p + 1);
        }
        String mn = record.getSourceMethodName();
        String msg = String.format("[%tD %tT:%tL] %s %s.%s %s", record.getMillis(), record.getMillis(), record.getMillis(), record.getLevel(), cn, mn, message);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            msg = msg + "\n" + sw.toString();
        }
        return msg + '\n';
    }

    public static void setAllLogFormatters() {
        LabsLogFormatter.setAllLogFormatters(Level.ALL);
    }

    public static void setAllLogFormatters(Level level) {
        AccessController.doPrivileged(() -> {
            for (Handler h : Logger.getLogger("").getHandlers()) {
                h.setLevel(level);
                h.setFormatter(new LabsLogFormatter());
                try {
                    h.setEncoding("utf-8");
                }
                catch (Exception ex) {
                    logger.severe("Error setting output encoding");
                }
            }
            return null;
        });
    }
}

