/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import lombok.Generated;

public class RamBytesRecorder {
    private final AtomicLong totalBytes;
    private BiPredicate<Long, Long> canRecordIncrementChecker;

    public RamBytesRecorder() {
        this.totalBytes = new AtomicLong(0L);
        this.canRecordIncrementChecker = null;
    }

    public RamBytesRecorder(BiPredicate<Long, Long> canRecordIncrementChecker) {
        this.totalBytes = new AtomicLong(0L);
        this.canRecordIncrementChecker = canRecordIncrementChecker;
    }

    public RamBytesRecorder(long initialBytes) {
        this.totalBytes = new AtomicLong(initialBytes);
        this.canRecordIncrementChecker = null;
    }

    public synchronized boolean record(long bytes) {
        if (this.canRecordIncrementChecker != null && bytes > 0L && !this.canRecordIncrementChecker.test(bytes, this.totalBytes.get() + bytes)) {
            return false;
        }
        this.totalBytes.addAndGet(bytes);
        return true;
    }

    public void recordWithoutValidation(long bytes, Consumer<Long> postAction) {
        this.totalBytes.addAndGet(bytes);
        if (postAction != null) {
            postAction.accept(bytes);
        }
    }

    public long getBytes() {
        return this.totalBytes.get();
    }

    @Generated
    public void setCanRecordIncrementChecker(BiPredicate<Long, Long> canRecordIncrementChecker) {
        this.canRecordIncrementChecker = canRecordIncrementChecker;
    }
}

