/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.SvekEdge;

public class Neighborhood {
    private final Entity leaf;
    private final List<Link> sametailLinks;
    private final List<Link> allButSametails;
    private static final double epsilon = 0.001;

    public Neighborhood(Entity leaf, List<Link> sametailLinks, List<Link> all) {
        this.leaf = leaf;
        this.sametailLinks = sametailLinks;
        this.allButSametails = new ArrayList<Link>(all);
        this.allButSametails.removeAll(sametailLinks);
    }

    public void drawU(UGraphic ug, double minX, double minY, Bibliotekon bibliotekon, XDimension2D shapeDim) {
        HashSet<XPoint2D> contactPoints = new HashSet<XPoint2D>();
        for (Link link : this.sametailLinks) {
            SvekEdge line = bibliotekon.getLine(link);
            XPoint2D contact = line.getStartContactPoint();
            contactPoints.add(contact);
        }
        XRectangle2D rect = new XRectangle2D(minX, minY, shapeDim.getWidth(), shapeDim.getHeight());
        XPoint2D center = new XPoint2D(rect.getCenterX(), rect.getCenterY());
        for (XPoint2D pt : contactPoints) {
            XPoint2D inter = Neighborhood.intersection(rect, center, pt);
            if (inter == null) {
                assert (false);
                continue;
            }
            double theta = Math.atan2(center.getX() - pt.getX(), -(center.getY() - pt.getY()));
            XPoint2D middle = this.drawExtends(ug, inter, theta);
            this.drawLine(ug, middle, pt);
        }
        for (Link link : this.allButSametails) {
            XPoint2D inter;
            SvekEdge line = bibliotekon.getLine(link);
            XPoint2D contact = link.getEntity1() == this.leaf ? line.getStartContactPoint() : line.getEndContactPoint();
            if (contact == null || (inter = Neighborhood.intersection(rect, center, contact)) == null) continue;
            this.drawLine(ug, inter, contact);
        }
    }

    private XPoint2D drawExtends(UGraphic ug, XPoint2D contact, double theta) {
        UPolygon poly = new UPolygon();
        poly.addPoint(0.0, 0.0);
        poly.addPoint(7.0, 20.0);
        poly.addPoint(-7.0, 20.0);
        poly.rotate(theta);
        UTranslate translate = UTranslate.point(contact);
        ug.apply(translate).draw(poly);
        XPoint2D p1 = translate.getTranslated(poly.getPoints().get(1));
        XPoint2D p2 = translate.getTranslated(poly.getPoints().get(2));
        return new XPoint2D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    static XPoint2D intersection(XRectangle2D rect, XPoint2D pt1, XPoint2D pt2) {
        XPoint2D p = Neighborhood.intersection(new XPoint2D(rect.getMinX(), rect.getMinY()), new XPoint2D(rect.getMaxX(), rect.getMinY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new XPoint2D(rect.getMinX(), rect.getMaxY()), new XPoint2D(rect.getMaxX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new XPoint2D(rect.getMinX(), rect.getMinY()), new XPoint2D(rect.getMinX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new XPoint2D(rect.getMaxX(), rect.getMinY()), new XPoint2D(rect.getMaxX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        return null;
    }

    private static XPoint2D intersection(XPoint2D pt1, XPoint2D pt2, XPoint2D pt3, XPoint2D pt4) {
        return Neighborhood.intersection(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY());
    }

    private static XPoint2D intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return null;
        }
        double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
        double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
        XPoint2D p = new XPoint2D(xi, yi);
        if (xi + 0.001 < Math.min(x1, x2) || xi - 0.001 > Math.max(x1, x2)) {
            return null;
        }
        if (xi + 0.001 < Math.min(x3, x4) || xi - 0.001 > Math.max(x3, x4)) {
            return null;
        }
        if (yi + 0.001 < Math.min(y1, y2) || yi - 0.001 > Math.max(y1, y2)) {
            return null;
        }
        if (yi + 0.001 < Math.min(y3, y4) || yi - 0.001 > Math.max(y3, y4)) {
            return null;
        }
        return p;
    }

    private void drawLine(UGraphic ug, XPoint2D pt1, XPoint2D pt2) {
        this.drawLine(ug, pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        ULine line = new ULine(x2 - x1, y2 - y1);
        ug.apply(new UTranslate(x1, y1)).draw(line);
    }
}

