/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

public final class PortGeometry
implements Comparable<PortGeometry> {
    private final String id;
    private final double position;
    private final double height;
    private final int score;

    public PortGeometry(String id, double position, double height, int score) {
        this.id = id;
        this.position = position;
        this.height = height;
        this.score = score;
    }

    public PortGeometry translateY(double deltaY) {
        return new PortGeometry(this.id, this.position + deltaY, this.height, this.score);
    }

    public String toString() {
        return "pos=" + this.position + " height=" + this.height + " (" + this.score + ")";
    }

    public double getHeight() {
        return this.height;
    }

    public double getPosition() {
        return this.position;
    }

    public double getLastY() {
        return this.position + this.height;
    }

    public int getScore() {
        return this.score;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(PortGeometry other) {
        return Double.compare(this.position, other.position);
    }
}

