/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.quickfix.WrapExceptTupleInParenthesesQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyTryExceptAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    PyTryExceptAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyTryExceptStatement(@NotNull PyTryExceptStatement node) {
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        boolean haveDefaultExcept = false;
        for (PyExceptPart part : node.getExceptParts()) {
            if (haveDefaultExcept) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.default.except.must.be.last", new Object[0])).range((PsiElement)part).create();
            }
            if (part.getExceptClass() != null) continue;
            haveDefaultExcept = true;
        }
        boolean haveStar = false;
        boolean haveNotStar = false;
        for (PyExceptPart exceptPart : node.getExceptParts()) {
            PsiElement star = PyPsiUtils.getFirstChildOfType((PsiElement)exceptPart, (PyElementType)PyTokenTypes.MULT);
            if (star != null) {
                haveStar = true;
            } else {
                haveNotStar = true;
            }
            if (!haveNotStar || !haveStar) continue;
            PsiElement exceptKeyword = exceptPart.getFirstChild();
            int startOffset = exceptKeyword.getTextOffset();
            int endOffset = exceptKeyword.getTextRange().getEndOffset();
            if (star != null) {
                endOffset = star.getTextRange().getEndOffset();
            }
            TextRange textRange = new TextRange(startOffset, endOffset);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.try.except.can.not.have.except.and.star.except", new Object[0])).range(textRange).create();
            break;
        }
    }

    public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (node.getExpressions().length == 0 && PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PyExceptPart.class, PyFinallyPart.class, PyFunction.class}) == null) {
            this.myHolder.markError((PsiElement)node, PyPsiBundle.message("ANN.no.exception.to.reraise", new Object[0]));
        }
    }

    @Nullable
    private static PyReferenceExpression tryGetExceptionGroupInExpression(@Nullable PsiElement exceptExpression) {
        if (exceptExpression instanceof PyReferenceExpression && "ExceptionGroup".equals(((PyReferenceExpression)exceptExpression).getName())) {
            return (PyReferenceExpression)exceptExpression;
        }
        if (exceptExpression instanceof PyParenthesizedExpression) {
            return PyTryExceptAnnotatorVisitor.tryGetExceptionGroupInExpression((PsiElement)PyPsiUtils.flattenParens((PyExpression)((PyParenthesizedExpression)exceptExpression)));
        }
        if (exceptExpression instanceof PyTupleExpression) {
            for (PsiElement child : exceptExpression.getChildren()) {
                PyReferenceExpression result = PyTryExceptAnnotatorVisitor.tryGetExceptionGroupInExpression(child);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void visitPyExceptBlock(@NotNull PyExceptPart node) {
        PyTupleExpression tuple;
        LanguageLevel level;
        PyExpression exceptClass;
        PyReferenceExpression exceptionGroup;
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if (node.isStar() && (exceptionGroup = PyTryExceptAnnotatorVisitor.tryGetExceptionGroupInExpression((PsiElement)(exceptClass = node.getExceptClass()))) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.exception.group.in.star.except", new Object[0])).range((PsiElement)exceptionGroup).create();
        }
        if (!(level = LanguageLevel.forElement((PsiElement)node)).isPy3K()) {
            return;
        }
        if (node.getTarget() == null) {
            return;
        }
        PyExpression exceptExpr = node.getExceptClass();
        if (exceptExpr instanceof PyParenthesizedExpression) {
            return;
        }
        if (exceptExpr instanceof PyTupleExpression && (tuple = (PyTupleExpression)exceptExpr).getElements().length > 1) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("INSP.except.clause.missing.parens", new Object[0])).range((PsiElement)tuple).withFix((CommonIntentionAction)new WrapExceptTupleInParenthesesQuickFix(tuple)).create();
        }
    }

    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        PyExceptPart exceptPart;
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if ((exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class, (boolean)false, (Class[])new Class[]{PyFunction.class})) != null && exceptPart.isStar()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.continue.break.or.return.in.star.except", new Object[0])).create();
        }
    }

    private void checkForContinueAndReturn(@NotNull PsiElement node) {
        PyExceptPart exceptPart;
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if ((exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class, (boolean)false, (Class[])new Class[]{PyLoopStatement.class})) != null && exceptPart.isStar()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.continue.break.or.return.in.star.except", new Object[0])).create();
        }
    }

    public void visitPyContinueStatement(@NotNull PyContinueStatement node) {
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        this.checkForContinueAndReturn((PsiElement)node);
    }

    public void visitPyBreakStatement(@NotNull PyBreakStatement node) {
        if (node == null) {
            PyTryExceptAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        this.checkForContinueAndReturn((PsiElement)node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyTryExceptAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyTryExceptStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyRaiseStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyExceptBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyReturnStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForContinueAndReturn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyContinueStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyBreakStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

