/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SimpleRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchType;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 .2\u00020\u0001:\u0006)*+,-.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/log/GitRefManager;", "Lcom/intellij/vcs/log/VcsLogRefManager;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lcom/intellij/dvcs/repo/RepositoryManager;", "Lgit4idea/repo/GitRepository;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/dvcs/repo/RepositoryManager;)V", "labelsComparator", "Ljava/util/Comparator;", "Lcom/intellij/vcs/log/VcsRef;", "branchLayoutComparator", "branchManager", "Lgit4idea/ui/branch/GitBranchManager;", "getLabelsOrderComparator", "getBranchLayoutComparator", "groupForBranchFilter", "", "Lcom/intellij/vcs/log/RefGroup;", "refs", "", "groupForTable", "references", "compact", "", "showTagNames", "getRepository", "serialize", "", "out", "Ljava/io/DataOutput;", "type", "Lcom/intellij/vcs/log/VcsRefType;", "deserialize", "in", "Ljava/io/DataInput;", "reference", "isFavorite", "setFavorite", "favorite", "RefType", "RemoteRefGroup", "GitLabelComparator", "GitBranchLayoutComparator", "GitRefComparator", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRefManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRefManager.kt\ngit4idea/log/GitRefManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1869#2,2:368\n295#2,2:370\n*S KotlinDebug\n*F\n+ 1 GitRefManager.kt\ngit4idea/log/GitRefManager\n*L\n100#1:368,2\n106#1:370,2\n*E\n"})
public final class GitRefManager
implements VcsLogRefManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RepositoryManager<GitRepository> repositoryManager;
    @NotNull
    private final Comparator<VcsRef> labelsComparator;
    @NotNull
    private final Comparator<VcsRef> branchLayoutComparator;
    @NotNull
    private final GitBranchManager branchManager;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final JBColor HEAD_COLOR;
    @NotNull
    private static final JBColor LOCAL_BRANCH_COLOR;
    @NotNull
    private static final JBColor REMOTE_BRANCH_COLOR;
    @NotNull
    private static final JBColor TAG_COLOR;
    @NotNull
    private static final JBColor OTHER_COLOR;
    @JvmField
    @NotNull
    public static final VcsRefType HEAD;
    @JvmField
    @NotNull
    public static final VcsRefType LOCAL_BRANCH;
    @JvmField
    @NotNull
    public static final VcsRefType REMOTE_BRANCH;
    @JvmField
    @NotNull
    public static final VcsRefType TAG;
    @JvmField
    @NotNull
    public static final VcsRefType OTHER;
    @NotNull
    private static final List<VcsRefType> REF_TYPE_INDEX;
    @NotNull
    public static final String MASTER = "master";
    @NotNull
    public static final String MAIN = "main";
    @NotNull
    public static final String ORIGIN_MASTER = "origin/master";
    @NotNull
    public static final String ORIGIN_MAIN = "origin/main";
    @NotNull
    private static final String REMOTE_TABLE_SEPARATOR = " & ";
    @NotNull
    private static final String SEPARATOR = "/";

    public GitRefManager(@NotNull Project project, @NotNull RepositoryManager<GitRepository> repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositoryManager, (String)"repositoryManager");
        this.repositoryManager = repositoryManager;
        this.labelsComparator = new GitLabelComparator(this.repositoryManager);
        this.branchLayoutComparator = new GitBranchLayoutComparator();
        Object object = project.getService(GitBranchManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.branchManager = (GitBranchManager)((Object)object);
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        return this.labelsComparator;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        return this.branchLayoutComparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<? extends VcsRef> refs) {
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        ArrayList<SingletonRefGroup> simpleGroups = new ArrayList<SingletonRefGroup>();
        ArrayList<VcsRef> localBranches2 = new ArrayList<VcsRef>();
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap remoteRefGroups = multiMap;
        MultiMap refsByRoot = GitRefManager.Companion.groupRefsByRoot(refs);
        for (Object object : refsByRoot.entrySet()) {
            List refsInRoot;
            Intrinsics.checkNotNull((Object)object);
            VirtualFile root = (VirtualFile)object.getKey();
            Collection value = (Collection)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ContainerUtil.sorted((Collection)value, this.labelsComparator), (String)"sorted(...)");
            GitRepository repository2 = (GitRepository)this.repositoryManager.getRepositoryForRootQuick(root);
            if (repository2 == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set locals = GitRefManager.Companion.getLocalBranches(repository2);
            Map allRemote = GitRefManager.Companion.getAllRemoteBranches(repository2);
            for (VcsRef ref : refsInRoot) {
                String refName;
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ref.getName(), (String)"getName(...)");
                if (locals.contains(refName)) {
                    localBranches2.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    remoteRefGroups.putValue(allRemote.get(refName), (Object)ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList<Object> result2 = new ArrayList<Object>((Collection)simpleGroups);
        if (!localBranches2.isEmpty()) {
            String string = GitBundle.message("git.log.refGroup.local", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result2.add(new SimpleRefGroup(string, (List)localBranches2, false));
        }
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            GitRemote key = (GitRemote)entry.getKey();
            Collection value = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)value);
            result2.add(new RemoteRefGroup(key, value));
        }
        return result2;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<? extends VcsRef> references, boolean compact, boolean showTagNames) {
        SimpleRefGroup simpleRefGroup;
        Intrinsics.checkNotNullParameter(references, (String)"references");
        if (references.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List list = ContainerUtil.sorted(references, this.labelsComparator);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sorted(...)");
        List sortedReferences = list;
        MultiMap multiMap = ContainerUtil.groupBy((Iterable)sortedReferences, arg_0 -> GitRefManager.groupForTable$lambda$1(GitRefManager::groupForTable$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"groupBy(...)");
        MultiMap groupedRefs = multiMap;
        Collection headRefs = groupedRefs.remove((Object)HEAD);
        GitRepository repository2 = this.getRepository(references);
        Object object = repository2;
        if (object == null || (object = GitRefManager.Companion.getTrackedRefs((GitRepository)object, (MultiMap<VcsRefType, VcsRef>)groupedRefs)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object trackedRefs = object;
        Iterable $this$forEach$iv = (Iterable)trackedRefs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefGroup refGroup = (RefGroup)element$iv;
            boolean bl = false;
            groupedRefs.remove((Object)LOCAL_BRANCH, refGroup.getRefs().get(0));
            groupedRefs.remove((Object)REMOTE_BRANCH, refGroup.getRefs().get(1));
        }
        Object object2 = repository2;
        if (object2 != null && (object2 = object2.getCurrentBranchName()) != null) {
            Object v5;
            Object branchName;
            block13: {
                branchName = object2;
                boolean bl = false;
                Collection collection = groupedRefs.get((Object)LOCAL_BRANCH);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VcsRef it = (VcsRef)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)branchName)) continue;
                    v5 = element$iv;
                    break block13;
                }
                v5 = null;
            }
            VcsRef vcsRef = v5;
            if (vcsRef == null) {
                simpleRefGroup = null;
            } else {
                VcsRef branch = vcsRef;
                groupedRefs.get((Object)LOCAL_BRANCH).remove(branch);
                Object[] objectArray = new VcsRef[]{branch};
                SimpleRefGroup simpleRefGroup2 = new SimpleRefGroup((String)branchName, CollectionsKt.mutableListOf((Object[])objectArray), false, 4, null);
                simpleRefGroup = simpleRefGroup2;
            }
        } else {
            simpleRefGroup = null;
        }
        SimpleRefGroup currentBranch = simpleRefGroup;
        List refGroups = SimpleRefGroup.Companion.buildGroups(CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(currentBranch), (Iterable)((Iterable)trackedRefs)), groupedRefs, compact, showTagNames);
        Collection collection = headRefs;
        if (collection == null || collection.isEmpty()) {
            return refGroups;
        }
        ArrayList<SimpleRefGroup> result2 = new ArrayList<SimpleRefGroup>();
        result2.addAll(refGroups);
        if (repository2 != null && !repository2.isOnBranch()) {
            result2.add(0, new SimpleRefGroup("!", CollectionsKt.toMutableList((Collection)headRefs), false, 4, null));
        } else if (!result2.isEmpty()) {
            ((RefGroup)CollectionsKt.first((List)result2)).getRefs().addAll(0, CollectionsKt.toMutableList((Collection)headRefs));
        } else {
            result2.add(0, new SimpleRefGroup("", CollectionsKt.toMutableList((Collection)headRefs), false, 4, null));
        }
        return result2;
    }

    private final GitRepository getRepository(Collection<? extends VcsRef> references) {
        if (references.isEmpty()) {
            return null;
        }
        VcsRef ref = (VcsRef)CollectionsKt.first((Iterable)references);
        GitRepository repository2 = this.getRepository(ref);
        if (repository2 == null) {
            LOG.warn("No repository for root: " + ref.getRoot());
        }
        return repository2;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        return REF_TYPE_INDEX.get(id);
    }

    private final GitRepository getRepository(VcsRef reference) {
        return (GitRepository)this.repositoryManager.getRepositoryForRootQuick(reference.getRoot());
    }

    public boolean isFavorite(@NotNull VcsRef reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (Intrinsics.areEqual((Object)reference.getType(), (Object)HEAD)) {
            return true;
        }
        if (!reference.getType().isBranch()) {
            return false;
        }
        return this.branchManager.isFavorite(GitRefManager.Companion.getBranchType(reference), this.getRepository(reference), reference.getName());
    }

    public void setFavorite(@NotNull VcsRef reference, boolean favorite) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (Intrinsics.areEqual((Object)reference.getType(), (Object)HEAD)) {
            return;
        }
        if (!reference.getType().isBranch()) {
            return;
        }
        this.branchManager.setFavorite(GitRefManager.Companion.getBranchType(reference), this.getRepository(reference), reference.getName(), favorite);
    }

    private static final VcsRefType groupForTable$lambda$0(VcsRef it) {
        return it.getType();
    }

    private static final VcsRefType groupForTable$lambda$1(Function1 $tmp0, Object p0) {
        return (VcsRefType)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final VcsRefType getRefType(@NotNull String refName) {
        return Companion.getRefType(refName);
    }

    static {
        Logger logger = Logger.getInstance(GitRefManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.GitLog.headIconColor", (Color)VcsLogStandardColors.Refs.TIP);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        HEAD_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"VersionControl.GitLog.localBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        LOCAL_BRANCH_COLOR = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"VersionControl.GitLog.remoteBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH_REF);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        REMOTE_BRANCH_COLOR = jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"VersionControl.GitLog.tagIconColor", (Color)VcsLogStandardColors.Refs.TAG);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
        TAG_COLOR = jBColor4;
        JBColor jBColor5 = JBColor.namedColor((String)"VersionControl.GitLog.otherIconColor", (Color)VcsLogStandardColors.Refs.TAG);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"namedColor(...)");
        OTHER_COLOR = jBColor5;
        HEAD = (VcsRefType)new SimpleRefType("HEAD", true, (Color)HEAD_COLOR);
        LOCAL_BRANCH = (VcsRefType)new SimpleRefType("LOCAL_BRANCH", true, (Color)LOCAL_BRANCH_COLOR);
        REMOTE_BRANCH = (VcsRefType)new SimpleRefType("REMOTE_BRANCH", true, (Color)REMOTE_BRANCH_COLOR);
        TAG = (VcsRefType)new SimpleRefType("TAG", false, (Color)TAG_COLOR);
        OTHER = (VcsRefType)new SimpleRefType("OTHER", false, (Color)OTHER_COLOR);
        Object[] objectArray = new VcsRefType[]{HEAD, LOCAL_BRANCH, REMOTE_BRANCH, TAG, OTHER};
        REF_TYPE_INDEX = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0014*\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020!0 H\u0002J$\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%2\u0006\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160+2\u0006\u0010,\u001a\u00020\u001eH\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020/0.2\u0006\u0010,\u001a\u00020\u001eH\u0002J\"\u00100\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020!0 2\f\u00102\u001a\b\u0012\u0004\u0012\u00020!03H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u0016H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lgit4idea/log/GitRefManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "HEAD_COLOR", "Lcom/intellij/ui/JBColor;", "LOCAL_BRANCH_COLOR", "REMOTE_BRANCH_COLOR", "TAG_COLOR", "OTHER_COLOR", "HEAD", "Lcom/intellij/vcs/log/VcsRefType;", "LOCAL_BRANCH", "REMOTE_BRANCH", "TAG", "OTHER", "REF_TYPE_INDEX", "", "MASTER", "", "MAIN", "ORIGIN_MASTER", "ORIGIN_MAIN", "REMOTE_TABLE_SEPARATOR", "SEPARATOR", "getTrackedRefs", "Lcom/intellij/vcs/log/RefGroup;", "Lgit4idea/repo/GitRepository;", "groupedRefs", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/vcs/log/VcsRef;", "createTrackedGroup", "Lcom/intellij/vcs/log/impl/SimpleRefGroup;", "references", "", "localRef", "getBranchType", "Lgit4idea/branch/GitBranchType;", "reference", "getLocalBranches", "", "repository", "getAllRemoteBranches", "", "Lgit4idea/repo/GitRemote;", "groupRefsByRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "refs", "", "getRefType", "refName", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRefManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRefManager.kt\ngit4idea/log/GitRefManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n774#2:368\n865#2,2:369\n774#2:372\n865#2,2:373\n1#3:371\n*S KotlinDebug\n*F\n+ 1 GitRefManager.kt\ngit4idea/log/GitRefManager$Companion\n*L\n310#1:368\n310#1:369,2\n319#1:372\n319#1:373,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<RefGroup> getTrackedRefs(GitRepository $this$getTrackedRefs, MultiMap<VcsRefType, VcsRef> groupedRefs) {
            ArrayList<SimpleRefGroup> result2 = new ArrayList<SimpleRefGroup>();
            Collection collection = groupedRefs.get((Object)LOCAL_BRANCH);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Collection locals = collection;
            Collection collection2 = groupedRefs.get((Object)REMOTE_BRANCH);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            Collection remotes = collection2;
            for (VcsRef localRef : locals) {
                Intrinsics.checkNotNull((Object)localRef);
                SimpleRefGroup group = this.createTrackedGroup($this$getTrackedRefs, remotes, localRef);
                if (group == null) continue;
                result2.add(group);
            }
            return result2;
        }

        private final SimpleRefGroup createTrackedGroup(GitRepository $this$createTrackedGroup, Collection<? extends VcsRef> references, VcsRef localRef) {
            Object v1;
            GitBranchTrackInfo info;
            List remoteBranches2;
            Object[] $this$filterTo$iv$iv2;
            Object destination$iv$iv;
            block8: {
                Iterable $this$filter$iv = references;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean bl = false;
                for (Object t : $this$filterTo$iv$iv2) {
                    VcsRef ref = (VcsRef)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ref.getType(), (Object)REMOTE_BRANCH)) continue;
                    destination$iv$iv.add(t);
                }
                remoteBranches2 = (List)destination$iv$iv;
                Collection<GitBranchTrackInfo> collection = $this$createTrackedGroup.getBranchTrackInfos();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getBranchTrackInfos(...)");
                $this$filterTo$iv$iv2 = (Object[])collection;
                for (Object e : $this$filterTo$iv$iv2) {
                    info = (GitBranchTrackInfo)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)info.getLocalBranch().getName(), (Object)localRef.getName())) continue;
                    v1 = e;
                    break block8;
                }
                v1 = null;
            }
            GitBranchTrackInfo trackInfo = v1;
            if (trackInfo != null) {
                GitBranchTrackInfo gitBranchTrackInfo;
                block9: {
                    destination$iv$iv = remoteBranches2;
                    Iterator iterator = destination$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        info = iterator.next();
                        VcsRef objectArray = (VcsRef)info;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)objectArray.getName(), (Object)trackInfo.getRemoteBranch().getName())) continue;
                        gitBranchTrackInfo = info;
                        break block9;
                    }
                    gitBranchTrackInfo = null;
                }
                VcsRef trackedRef = (VcsRef)gitBranchTrackInfo;
                if (trackedRef != null) {
                    $this$filterTo$iv$iv2 = new VcsRef[]{localRef, trackedRef};
                    return new SimpleRefGroup(trackInfo.getRemote().getName() + GitRefManager.REMOTE_TABLE_SEPARATOR + localRef.getName(), CollectionsKt.mutableListOf((Object[])$this$filterTo$iv$iv2), false, 4, null);
                }
            }
            Iterable $this$filter$iv = remoteBranches2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl = false;
            for (Object element$iv$iv : iterable) {
                VcsRef ref = (VcsRef)element$iv$iv;
                boolean bl4 = false;
                String string = ref.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)(GitRefManager.SEPARATOR + localRef.getName()), (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List trackingCandidates = (List)destination$iv$iv2;
            for (GitRemote remote : $this$createTrackedGroup.getRemotes()) {
                for (VcsRef candidate : trackingCandidates) {
                    if (!Intrinsics.areEqual((Object)candidate.getName(), (Object)(remote.getName() + GitRefManager.SEPARATOR + localRef.getName()))) continue;
                    Object[] objectArray = new VcsRef[]{localRef, candidate};
                    return new SimpleRefGroup(remote.getName() + GitRefManager.REMOTE_TABLE_SEPARATOR + localRef.getName(), CollectionsKt.mutableListOf((Object[])objectArray), false, 4, null);
                }
            }
            return null;
        }

        private final GitBranchType getBranchType(VcsRef reference) {
            return Intrinsics.areEqual((Object)reference.getType(), (Object)LOCAL_BRANCH) ? GitBranchType.LOCAL : GitBranchType.REMOTE;
        }

        private final Set<String> getLocalBranches(GitRepository repository2) {
            Collection<GitLocalBranch> collection = repository2.getBranches().getLocalBranches();
            Function function = Companion::getLocalBranches$lambda$0;
            Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type com.intellij.util.Function<git4idea.GitBranch, kotlin.String>");
            Set set = ContainerUtil.map2Set(collection, (Function)function);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map2Set(...)");
            return set;
        }

        private final Map<String, GitRemote> getAllRemoteBranches(GitRepository repository2) {
            HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository2.getBranches().getRemoteBranches());
            HashMap allRemote = new HashMap();
            Iterator<GitRemoteBranch> iterator = all.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<GitRemoteBranch> iterator2 = iterator;
            while (iterator2.hasNext()) {
                GitRemoteBranch remoteBranch = iterator2.next();
                ((Map)allRemote).put(remoteBranch.getName(), remoteBranch.getRemote());
            }
            return allRemote;
        }

        private final MultiMap<VirtualFile, VcsRef> groupRefsByRoot(Iterable<? extends VcsRef> refs) {
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            MultiMap grouped = multiMap;
            for (VcsRef vcsRef : refs) {
                grouped.putValue((Object)vcsRef.getRoot(), (Object)vcsRef);
            }
            return grouped;
        }

        @JvmStatic
        @NotNull
        public final VcsRefType getRefType(@NotNull String refName) {
            Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
            if (StringsKt.startsWith$default((String)refName, (String)"refs/heads/", (boolean)false, (int)2, null)) {
                return LOCAL_BRANCH;
            }
            if (StringsKt.startsWith$default((String)refName, (String)"refs/remotes/", (boolean)false, (int)2, null)) {
                return REMOTE_BRANCH;
            }
            if (StringsKt.startsWith$default((String)refName, (String)"refs/tags/", (boolean)false, (int)2, null)) {
                return TAG;
            }
            if (StringsKt.startsWith$default((String)refName, (String)"HEAD", (boolean)false, (int)2, null)) {
                return HEAD;
            }
            return OTHER;
        }

        private static final String getLocalBranches$lambda$0(GitBranch branch) {
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            return branch.getName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lgit4idea/log/GitRefManager$GitBranchLayoutComparator;", "Lgit4idea/log/GitRefManager$GitRefComparator;", "<init>", "()V", "orderedTypes", "", "Lgit4idea/log/GitRefManager$RefType;", "getOrderedTypes", "()[Lgit4idea/log/GitRefManager$RefType;", "[Lgit4idea/log/GitRefManager$RefType;", "intellij.vcs.git"})
    private static final class GitBranchLayoutComparator
    extends GitRefComparator {
        @NotNull
        private final RefType[] orderedTypes;

        public GitBranchLayoutComparator() {
            RefType[] refTypeArray = new RefType[]{RefType.ORIGIN_MASTER, RefType.REMOTE_BRANCH, RefType.MASTER, RefType.LOCAL_BRANCH, RefType.TAG, RefType.CURRENT_BRANCH, RefType.HEAD, RefType.OTHER};
            this.orderedTypes = refTypeArray;
        }

        @Override
        @NotNull
        protected RefType[] getOrderedTypes() {
            return this.orderedTypes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lgit4idea/log/GitRefManager$GitLabelComparator;", "Lgit4idea/log/GitRefManager$GitRefComparator;", "repositoryManager", "Lcom/intellij/dvcs/repo/RepositoryManager;", "Lgit4idea/repo/GitRepository;", "<init>", "(Lcom/intellij/dvcs/repo/RepositoryManager;)V", "orderedTypes", "", "Lgit4idea/log/GitRefManager$RefType;", "getOrderedTypes", "()[Lgit4idea/log/GitRefManager$RefType;", "[Lgit4idea/log/GitRefManager$RefType;", "getType", "ref", "Lcom/intellij/vcs/log/VcsRef;", "isCurrentBranch", "", "intellij.vcs.git"})
    private static final class GitLabelComparator
    extends GitRefComparator {
        @NotNull
        private final RepositoryManager<GitRepository> repositoryManager;
        @NotNull
        private final RefType[] orderedTypes;

        public GitLabelComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            Intrinsics.checkNotNullParameter(repositoryManager, (String)"repositoryManager");
            this.repositoryManager = repositoryManager;
            RefType[] refTypeArray = new RefType[]{RefType.HEAD, RefType.CURRENT_BRANCH, RefType.MASTER, RefType.ORIGIN_MASTER, RefType.LOCAL_BRANCH, RefType.REMOTE_BRANCH, RefType.TAG, RefType.OTHER};
            this.orderedTypes = refTypeArray;
        }

        @Override
        @NotNull
        protected RefType[] getOrderedTypes() {
            return this.orderedTypes;
        }

        @Override
        @NotNull
        protected RefType getType(@NotNull VcsRef ref) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            RefType type = super.getType(ref);
            if ((type == RefType.LOCAL_BRANCH || type == RefType.MASTER) && this.isCurrentBranch(ref)) {
                return RefType.CURRENT_BRANCH;
            }
            return type;
        }

        private final boolean isCurrentBranch(VcsRef ref) {
            GitRepository gitRepository = (GitRepository)this.repositoryManager.getRepositoryForRootQuick(ref.getRoot());
            if (gitRepository == null) {
                return false;
            }
            GitRepository repo = gitRepository;
            GitLocalBranch gitLocalBranch = repo.getCurrentBranch();
            if (gitLocalBranch == null) {
                return false;
            }
            GitLocalBranch currentBranch = gitLocalBranch;
            return Intrinsics.areEqual((Object)currentBranch.getName(), (Object)ref.getName());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lgit4idea/log/GitRefManager$GitRefComparator;", "Ljava/util/Comparator;", "Lcom/intellij/vcs/log/VcsRef;", "<init>", "()V", "orderedTypes", "", "Lgit4idea/log/GitRefManager$RefType;", "getOrderedTypes", "()[Lgit4idea/log/GitRefManager$RefType;", "compare", "", "ref1", "ref2", "getType", "ref", "intellij.vcs.git"})
    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        @NotNull
        protected abstract RefType[] getOrderedTypes();

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            Intrinsics.checkNotNullParameter((Object)ref1, (String)"ref1");
            Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref2");
            int power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref1)));
            int power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref2)));
            if (power1 != power2) {
                return power1 - power2;
            }
            int namesComparison = GitReference.REFS_NAMES_COMPARATOR.compare(ref1.getName(), ref2.getName());
            return namesComparison != 0 ? namesComparison : VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        @NotNull
        protected RefType getType(@NotNull VcsRef ref) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            VcsRefType vcsRefType = ref.getType();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"getType(...)");
            VcsRefType type = vcsRefType;
            String string = ref.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            return type == HEAD ? RefType.HEAD : (type == TAG ? RefType.TAG : (type == LOCAL_BRANCH ? (Intrinsics.areEqual((Object)name, (Object)GitRefManager.MASTER) || Intrinsics.areEqual((Object)name, (Object)GitRefManager.MAIN) ? RefType.MASTER : RefType.LOCAL_BRANCH) : (type == REMOTE_BRANCH ? (Intrinsics.areEqual((Object)name, (Object)GitRefManager.ORIGIN_MASTER) || Intrinsics.areEqual((Object)name, (Object)GitRefManager.ORIGIN_MAIN) ? RefType.ORIGIN_MASTER : RefType.REMOTE_BRANCH) : RefType.OTHER)));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/log/GitRefManager$RefType;", "", "<init>", "(Ljava/lang/String;I)V", "OTHER", "HEAD", "CURRENT_BRANCH", "TAG", "LOCAL_BRANCH", "MASTER", "REMOTE_BRANCH", "ORIGIN_MASTER", "intellij.vcs.git"})
    private static final class RefType
    extends Enum<RefType> {
        public static final /* enum */ RefType OTHER = new RefType();
        public static final /* enum */ RefType HEAD = new RefType();
        public static final /* enum */ RefType CURRENT_BRANCH = new RefType();
        public static final /* enum */ RefType TAG = new RefType();
        public static final /* enum */ RefType LOCAL_BRANCH = new RefType();
        public static final /* enum */ RefType MASTER = new RefType();
        public static final /* enum */ RefType REMOTE_BRANCH = new RefType();
        public static final /* enum */ RefType ORIGIN_MASTER = new RefType();
        private static final /* synthetic */ RefType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RefType[] values() {
            return (RefType[])$VALUES.clone();
        }

        public static RefType valueOf(String value) {
            return Enum.valueOf(RefType.class, value);
        }

        @NotNull
        public static EnumEntries<RefType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = refTypeArray = new RefType[]{RefType.OTHER, RefType.HEAD, RefType.CURRENT_BRANCH, RefType.TAG, RefType.LOCAL_BRANCH, RefType.MASTER, RefType.REMOTE_BRANCH, RefType.ORIGIN_MASTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J>\u0010\r\u001a8\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u0006 \u000f*\u001a\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u00060\u0012\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00110\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0016\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00140\u00140\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/log/GitRefManager$RemoteRefGroup;", "Lcom/intellij/vcs/log/RefGroup;", "remote", "Lgit4idea/repo/GitRemote;", "branches", "", "Lcom/intellij/vcs/log/VcsRef;", "<init>", "(Lgit4idea/log/GitRefManager;Lgit4idea/repo/GitRemote;Ljava/util/Collection;)V", "isExpanded", "", "getName", "", "getRefs", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Unmodifiable;", "Lorg/jetbrains/annotations/NotNull;", "", "getColors", "Ljava/awt/Color;", "intellij.vcs.git"})
    private final class RemoteRefGroup
    implements RefGroup {
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final Collection<VcsRef> branches;

        public RemoteRefGroup(@NotNull GitRemote remote, Collection<? extends VcsRef> branches) {
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            this.remote = remote;
            this.branches = branches;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            return this.remote.getName() + "/...";
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List list = ContainerUtil.sorted(this.branches, GitRefManager.this.getLabelsOrderComparator());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sorted(...)");
            return list;
        }

        @NotNull
        public List<Color> getColors() {
            return CollectionsKt.listOf((Object)VcsLogStandardColors.Refs.BRANCH_REF);
        }
    }
}

