/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.impl;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlEntityRefUtil {
    @NonNls
    private static final String GT_ENTITY = "&gt;";
    @NonNls
    private static final String QUOT_ENTITY = "&quot;";

    @Nullable
    public static XmlEntityDecl resolveEntity(XmlEntityRef element, PsiFile targetFile) {
        String text = element.getText();
        if (text.equals(GT_ENTITY) || text.equals(QUOT_ENTITY)) {
            return null;
        }
        return XmlEntityRefUtil.resolveEntity((XmlElement)element, text, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl resolveEntity(XmlElement element, String text, PsiFile targetFile) {
        CachedValue value;
        String entityName = text.substring(1, text.length() - 1);
        PsiFile targetElement = targetFile != null ? targetFile : element;
        Object object = XmlEntityCache.LOCK;
        synchronized (object) {
            Map map = XmlEntityCache.getCachingMap((PsiElement)targetElement);
            value = (CachedValue)map.get(entityName);
            PsiFile containingFile = element.getContainingFile();
            if (value == null) {
                PsiManager manager = element.getManager();
                if (manager == null) {
                    return (XmlEntityDecl)XmlEntityRefUtil.doResolveEntity((PsiElement)targetElement, entityName, containingFile).getValue();
                }
                value = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> XmlEntityRefUtil.lambda$resolveEntity$0((PsiElement)targetElement, entityName, containingFile), true);
                map.put(entityName, value);
            }
        }
        return (XmlEntityDecl)value.getValue();
    }

    private static CachedValueProvider.Result<XmlEntityDecl> doResolveEntity(final PsiElement targetElement, final String entityName, final PsiFile contextFile) {
        return (CachedValueProvider.Result)RecursionManager.doPreventingRecursion((Object)targetElement, (boolean)true, (Computable)new Computable<CachedValueProvider.Result<XmlEntityDecl>>(){

            public CachedValueProvider.Result<XmlEntityDecl> compute() {
                final ArrayList<Object> deps = new ArrayList<Object>();
                final XmlEntityDecl[] result = new XmlEntityDecl[]{null};
                PsiElementProcessor<PsiElement> processor = new PsiElementProcessor<PsiElement>(){

                    public boolean execute(@NotNull PsiElement element) {
                        XmlEntityDecl entityDecl;
                        String declName;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof XmlDoctype) {
                            XmlMarkupDecl markupDecl;
                            XmlDoctype xmlDoctype = (XmlDoctype)element;
                            String dtdUri = XmlEntityRefUtil.getDtdForEntity(xmlDoctype);
                            if (dtdUri != null) {
                                XmlFile file = XmlUtil.getContainingFile((PsiElement)element);
                                if (file == null) {
                                    return true;
                                }
                                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)file, (String)dtdUri);
                                if (xmlFile != null && xmlFile != targetElement) {
                                    deps.add(xmlFile);
                                    if (!XmlUtil.processXmlElements((XmlElement)xmlFile, (PsiElementProcessor)this, (boolean)true)) {
                                        return false;
                                    }
                                }
                            }
                            if ((markupDecl = xmlDoctype.getMarkupDecl()) != null && !XmlUtil.processXmlElements((XmlElement)markupDecl, (PsiElementProcessor)this, (boolean)true)) {
                                return false;
                            }
                        } else if (element instanceof XmlEntityDecl && StringUtil.equals((CharSequence)(declName = (entityDecl = (XmlEntityDecl)element).getName()), (CharSequence)entityName)) {
                            result[0] = entityDecl;
                            deps.add(entityDecl.getContainingFile());
                            return false;
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/impl/XmlEntityRefUtil$1$1", "execute"));
                    }
                };
                FileViewProvider provider = targetElement.getContainingFile().getViewProvider();
                deps.add(provider.getPsi(provider.getBaseLanguage()));
                boolean notfound = PsiTreeUtil.processElements((PsiElement)targetElement, (PsiElementProcessor)processor);
                if (notfound && contextFile != targetElement && contextFile != null && contextFile.isValid()) {
                    notfound = PsiTreeUtil.processElements((PsiElement)contextFile, (PsiElementProcessor)processor);
                }
                if (notfound && targetElement instanceof XmlFile && deps.size() == 1 && ((XmlFile)targetElement).getFileType() != DTDFileType.INSTANCE) {
                    for (XmlFile descriptorFile : XmlExtension.getExtension((PsiFile)((XmlFile)targetElement)).getCharEntitiesDTDs((XmlFile)targetElement)) {
                        if (descriptorFile.getName().equals(((XmlFile)targetElement).getName() + ".dtd")) continue;
                        deps.add(descriptorFile);
                        if (XmlUtil.processXmlElements((XmlElement)descriptorFile, (PsiElementProcessor)processor, (boolean)true)) continue;
                        break;
                    }
                }
                return new CachedValueProvider.Result((Object)result[0], ArrayUtil.toObjectArray(deps));
            }
        });
    }

    private static String getDtdForEntity(XmlDoctype xmlDoctype) {
        return HtmlUtil.isHtml5Doctype((XmlDoctype)xmlDoctype) ? Html5SchemaProvider.getCharsDtdLocation() : XmlUtil.getDtdUri((XmlDoctype)xmlDoctype);
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$resolveEntity$0(PsiElement targetElement, String entityName, PsiFile containingFile) {
        return XmlEntityRefUtil.doResolveEntity(targetElement, entityName, containingFile);
    }
}

