/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionTypeImpl
implements PyFunctionType {
    @NotNull
    private final PyCallable myCallable;
    @NotNull
    private final @NotNull List<@NotNull PyCallableParameter> myParameters;

    public static PyFunctionType create(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(1);
        }
        ArrayList<PyCallableParameter> parameters = new ArrayList<PyCallableParameter>();
        for (PyParameter parameter : callable.getParameterList().getParameters()) {
            PyType pyType;
            PyNamedParameter namedParameter;
            if (parameter instanceof PyNamedParameter && (namedParameter = (PyNamedParameter)parameter).isKeywordContainer() && (pyType = context.getType((PyTypedElement)namedParameter)) instanceof PyTypedDictType) {
                PyTypedDictType typedDictType = (PyTypedDictType)pyType;
                List typedDictParameters = typedDictType.toClass().getParameters(context);
                parameters.addAll(ContainerUtil.notNullize((List)typedDictParameters));
                continue;
            }
            parameters.add(PyCallableParameterImpl.psi(parameter));
        }
        return new PyFunctionTypeImpl(callable, parameters);
    }

    @Deprecated
    public PyFunctionTypeImpl(@NotNull PyCallable callable) {
        if (callable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(2);
        }
        this(callable, ContainerUtil.map((Object[])callable.getParameterList().getParameters(), PyCallableParameterImpl::psi));
    }

    public PyFunctionTypeImpl(@NotNull PyCallable callable, @NotNull @NotNull List<@NotNull PyCallableParameter> parameters) {
        if (callable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(4);
        }
        this.myCallable = callable;
        this.myParameters = parameters;
    }

    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(5);
        }
        return context.getReturnType(this.myCallable);
    }

    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(6);
        }
        if (callSite == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(7);
        }
        return this.myCallable.getCallType(context, callSite);
    }

    public @Nullable List<@NotNull PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(8);
        }
        return this.myParameters;
    }

    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PyClassType delegate;
        if (name == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(9);
        }
        if (direction == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(10);
        }
        if (resolveContext == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(11);
        }
        if ((delegate = this.selectCallableType(location, resolveContext.getTypeEvalContext())) == null) {
            return Collections.emptyList();
        }
        return delegate.resolveMember(name, location, direction, resolveContext);
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        PyClassType delegate;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)location.getProject(), (PsiFile)location.getContainingFile());
        if (location instanceof PyReferenceExpression) {
            delegate = this.selectCallableType(((PyReferenceExpression)location).getQualifier(), typeEvalContext);
        } else {
            PyClass cls = PyPsiFacade.getInstance((Project)this.myCallable.getProject()).createClassByQName("types.FunctionType", (PsiElement)this.myCallable);
            PyClassTypeImpl pyClassTypeImpl = delegate = cls != null ? new PyClassTypeImpl(cls, false) : null;
        }
        if (delegate == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return delegate.getCompletionVariants(completionPrefix, location, context);
    }

    @Nullable
    private PyClassType selectCallableType(@Nullable PyExpression location, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(12);
        }
        String className = location instanceof PyReferenceExpression && this.isBoundMethodReference((PyReferenceExpression)location, context) ? "types.UnboundMethodType" : "types.FunctionType";
        PyClass cls = PyPsiFacade.getInstance((Project)this.myCallable.getProject()).createClassByQName(className, (PsiElement)this.myCallable);
        return cls != null ? new PyClassTypeImpl(cls, false) : null;
    }

    private boolean isBoundMethodReference(@NotNull PyReferenceExpression location, @NotNull TypeEvalContext context) {
        PyFunction function;
        boolean isNonStaticMethod;
        if (location == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(14);
        }
        boolean bl = isNonStaticMethod = (function = PyUtil.as(this.getCallable(), PyFunction.class)) != null && function.getContainingClass() != null && function.getModifier() != PyAstFunction.Modifier.STATICMETHOD;
        if (isNonStaticMethod) {
            PyType qualifierType;
            PyExpression qualifier;
            if (LanguageLevel.forElement((PsiElement)location).isPython2()) {
                return true;
            }
            if (location.isQualified()) {
                qualifier = location.getQualifier();
            } else {
                PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
                qualifier = (PyExpression)ContainerUtil.getLastItem((List)location.followAssignmentsChain(resolveContext).getQualifiers());
            }
            if (qualifier != null && PyTypeUtil.toStream(qualifierType = context.getType((PyTypedElement)qualifier)).select(PyClassType.class).anyMatch(it -> !it.isDefinition())) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return "function";
    }

    public boolean isBuiltin() {
        return false;
    }

    public void assertValid(String message) {
    }

    @NotNull
    public PyCallable getCallable() {
        PyCallable pyCallable = this.myCallable;
        if (pyCallable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(15);
        }
        return pyCallable;
    }

    @NotNull
    public PyFunctionType dropSelf(@NotNull TypeEvalContext context) {
        List<PyCallableParameter> parameters;
        if (context == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(16);
        }
        if (!ContainerUtil.isEmpty(parameters = this.getParameters(context)) && parameters.get(0).isSelf()) {
            return new PyFunctionTypeImpl(this.myCallable, ContainerUtil.subList(parameters, (int)1));
        }
        PyFunctionTypeImpl pyFunctionTypeImpl = this;
        if (pyFunctionTypeImpl == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(17);
        }
        return pyFunctionTypeImpl;
    }

    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        if (visitor == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(18);
        }
        return (T)visitor.visitPyFunctionType((PyFunctionType)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyFunctionTypeImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyFunctionTypeImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "dropSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectCallableType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBoundMethodReference";
                break;
            }
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dropSelf";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 17 -> new IllegalStateException(string);
        };
    }
}

