/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.html.CodeFenceGeneratingProvider;
import org.intellij.markdown.html.CodeSpanGeneratingProvider;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlBlockGeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.ImageGeneratingProvider;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.ListItemGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.XssSafeLinksKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer._MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "useSafeLinks", "", "absolutizeAnchorLinks", "(ZZ)V", "getAbsolutizeAnchorLinks", "()Z", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getUseSafeLinks", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "markdown"})
public class CommonMarkFlavourDescriptor
implements MarkdownFlavourDescriptor {
    private final boolean useSafeLinks;
    private final boolean absolutizeAnchorLinks;
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public CommonMarkFlavourDescriptor(boolean useSafeLinks, boolean absolutizeAnchorLinks) {
        this.useSafeLinks = useSafeLinks;
        this.absolutizeAnchorLinks = absolutizeAnchorLinks;
        this.markerProcessorFactory = CommonMarkMarkerProcessor.Factory.INSTANCE;
        this.sequentialParserManager = new SequentialParserManager(){

            @NotNull
            public List<SequentialParser> getParserSequence() {
                Object[] objectArray = new SequentialParser[6];
                objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object)MarkdownTokenTypes.AUTOLINK));
                objectArray[1] = new BacktickParser();
                objectArray[2] = new ImageParser();
                objectArray[3] = new InlineLinkParser();
                objectArray[4] = new ReferenceLinkParser();
                DelimiterParser[] delimiterParserArray = new DelimiterParser[]{new EmphStrongDelimiterParser()};
                objectArray[5] = new EmphasisLikeParser(delimiterParserArray);
                return CollectionsKt.listOf((Object[])objectArray);
            }
        };
    }

    public /* synthetic */ CommonMarkFlavourDescriptor(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    protected final boolean getUseSafeLinks() {
        return this.useSafeLinks;
    }

    protected final boolean getAbsolutizeAnchorLinks() {
        return this.absolutizeAnchorLinks;
    }

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _MarkdownLexer());
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.MARKDOWN_FILE, (Object)new SimpleTagProvider("body")), TuplesKt.to((Object)MarkdownElementTypes.HTML_BLOCK, (Object)new HtmlBlockGeneratingProvider()), TuplesKt.to((Object)MarkdownTokenTypes.HTML_TAG, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                visitor.consumeHtml(ASTUtilKt.getTextInNode(node, text));
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.BLOCK_QUOTE, (Object)new SimpleTagProvider("blockquote")), TuplesKt.to((Object)MarkdownElementTypes.ORDERED_LIST, (Object)new SimpleTagProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                String string;
                String string2;
                CharSequence charSequence;
                ASTNode aSTNode;
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String attribute = null;
                CharSequence[] charSequenceArray = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.LIST_ITEM);
                if (charSequenceArray != null && (aSTNode = ASTUtilKt.findChildOfType((ASTNode)charSequenceArray, MarkdownTokenTypes.LIST_NUMBER)) != null && (charSequence = ASTUtilKt.getTextInNode(aSTNode, text)) != null && (string2 = ((Object)charSequence).toString()) != null && (string = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                    String it = string;
                    boolean bl = false;
                    String string3 = it.substring(0, it.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    char[] cArray = new char[]{'0'};
                    String number = StringsKt.trimStart((String)string3, (char[])cArray);
                    if (!number.equals("1")) {
                        attribute = "start=\"" + (((CharSequence)number).length() == 0 ? "0" : number) + '\"';
                    }
                }
                charSequenceArray = new CharSequence[]{attribute};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "ol", charSequenceArray, false, 8, null);
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.UNORDERED_LIST, (Object)new SimpleTagProvider("ul")), TuplesKt.to((Object)MarkdownElementTypes.LIST_ITEM, (Object)new ListItemGeneratingProvider()), TuplesKt.to((Object)MarkdownTokenTypes.SETEXT_CONTENT, (Object)new TrimmingInlineHolderProvider()), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_1, (Object)new SimpleTagProvider("h1")), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_2, (Object)new SimpleTagProvider("h2")), TuplesKt.to((Object)MarkdownTokenTypes.ATX_CONTENT, (Object)new TrimmingInlineHolderProvider()), TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)new SimpleTagProvider("h1")), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)new SimpleTagProvider("h2")), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)new SimpleTagProvider("h3")), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)new SimpleTagProvider("h4")), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)new SimpleTagProvider("h5")), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)new SimpleTagProvider("h6")), TuplesKt.to((Object)MarkdownElementTypes.AUTOLINK, (Object)new GeneratingProvider(this){
            final /* synthetic */ CommonMarkFlavourDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text);
                String linkLabel = EntityConverter.INSTANCE.replaceEntities(linkText.subSequence(1, linkText.length() - 1), true, false);
                CharSequence[] charSequenceArray = LinkMap.Builder.normalizeDestination(linkText, false);
                CommonMarkFlavourDescriptor commonMarkFlavourDescriptor = this.this$0;
                CharSequence[] it = charSequenceArray;
                boolean bl = false;
                CharSequence[] linkDestination = commonMarkFlavourDescriptor.getUseSafeLinks() ? XssSafeLinksKt.makeXssSafeDestination((CharSequence)it) : it;
                charSequenceArray = new CharSequence[]{"href=\"" + linkDestination + '\"'};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "a", charSequenceArray, false, 8, null);
                visitor.consumeHtml(linkLabel);
                visitor.consumeTagClose("a");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.LINK_LABEL, (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.LINK_TEXT, (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.LINK_TITLE, (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.INLINE_LINK, (Object)XssSafeLinksKt.makeXssSafe(new InlineLinkGeneratingProvider(baseURI, this.absolutizeAnchorLinks), this.useSafeLinks)), TuplesKt.to((Object)MarkdownElementTypes.FULL_REFERENCE_LINK, (Object)XssSafeLinksKt.makeXssSafe(new ReferenceLinksGeneratingProvider(linkMap, baseURI, this.absolutizeAnchorLinks), this.useSafeLinks)), TuplesKt.to((Object)MarkdownElementTypes.SHORT_REFERENCE_LINK, (Object)XssSafeLinksKt.makeXssSafe(new ReferenceLinksGeneratingProvider(linkMap, baseURI, this.absolutizeAnchorLinks), this.useSafeLinks)), TuplesKt.to((Object)MarkdownElementTypes.IMAGE, (Object)XssSafeLinksKt.makeXssSafe(new ImageGeneratingProvider(linkMap, baseURI), this.useSafeLinks)), TuplesKt.to((Object)MarkdownElementTypes.LINK_DEFINITION, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)new CodeFenceGeneratingProvider()), TuplesKt.to((Object)MarkdownElementTypes.CODE_BLOCK, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                visitor.consumeHtml("<pre>");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "code", new CharSequence[0], false, 8, null);
                for (ASTNode child : node.getChildren()) {
                    if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.CODE_LINE)) {
                        visitor.consumeHtml(HtmlGenerator.Companion.trimIndents(HtmlGenerator.Companion.leafText(text, child, false), 4));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
                    visitor.consumeHtml("\n");
                }
                visitor.consumeHtml("\n");
                visitor.consumeTagClose("code");
                visitor.consumeHtml("</pre>");
            }
        }), TuplesKt.to((Object)MarkdownTokenTypes.HORIZONTAL_RULE, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                visitor.consumeHtml("<hr />");
            }
        }), TuplesKt.to((Object)MarkdownTokenTypes.HARD_LINE_BREAK, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                visitor.consumeHtml("<br />");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.PARAGRAPH, (Object)new TrimmingInlineHolderProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8, null);
            }

            public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                visitor.consumeTagClose("p");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.EMPH, (Object)new SimpleInlineTagProvider("em", 1, -1)), TuplesKt.to((Object)MarkdownElementTypes.STRONG, (Object)new SimpleInlineTagProvider("strong", 2, -2)), TuplesKt.to((Object)MarkdownElementTypes.CODE_SPAN, (Object)new CodeSpanGeneratingProvider())};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    public CommonMarkFlavourDescriptor() {
        this(false, false, 3, null);
    }
}

