/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.console.PyConsoleParser;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.parsing.console.PythonConsoleLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.stubs.PyFileStubBuilder;
import com.jetbrains.python.psi.impl.stubs.PyFileStubImpl;
import com.jetbrains.python.psi.stubs.PyFileStub;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFileElementType
extends IStubFileElementType<PyFileStub> {
    public static final PyFileElementType INSTANCE = new PyFileElementType((Language)PythonLanguage.getInstance());

    protected PyFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new PyFileStubBuilder();
    }

    public int getStubVersion() {
        return 105;
    }

    @Nullable
    public ASTNode parseContents(@NotNull ASTNode node) {
        PythonConsoleData consoleData;
        if (node == null) {
            PyFileElementType.$$$reportNull$$$0(0);
        }
        LanguageLevel languageLevel = PyFileElementType.getLanguageLevel(node.getPsi());
        PythonRuntimeService instance = PythonRuntimeService.getInstance();
        if (instance != null && (consoleData = instance.getPythonConsoleData(node)) != null) {
            return this.parseConsoleCode(node, consoleData);
        }
        PsiElement psi = node.getPsi();
        if (psi != null) {
            Project project = psi.getProject();
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            Language language = this.getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
            if (parserDefinition == null) {
                return null;
            }
            Lexer lexer = parserDefinition.createLexer(project);
            PsiParser parser = parserDefinition.createParser(project);
            PsiBuilder builder = factory.createBuilder(project, node, lexer, language, node.getChars());
            if (parser instanceof PyParser) {
                PyParser pythonParser = (PyParser)parser;
                pythonParser.setLanguageLevel(languageLevel);
            }
            long startTime = System.nanoTime();
            ASTNode result = parser.parse((IElementType)this, builder).getFirstChildNode();
            ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)this.getLanguage(), (long)(System.nanoTime() - startTime));
            return result;
        }
        return null;
    }

    @Nullable
    private ASTNode parseConsoleCode(@NotNull ASTNode node, PythonConsoleData consoleData) {
        if (node == null) {
            PyFileElementType.$$$reportNull$$$0(1);
        }
        Lexer lexer = this.createConsoleLexer(node, consoleData);
        PsiElement psi = node.getPsi();
        if (psi != null) {
            Project project = psi.getProject();
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            PsiBuilder builder = factory.createBuilder(project, node, lexer, this.getLanguage(), node.getChars());
            PyConsoleParser parser = new PyConsoleParser(consoleData, PyFileElementType.getLanguageLevel(psi));
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }
        return null;
    }

    @Nullable
    private Lexer createConsoleLexer(ASTNode node, PythonConsoleData consoleData) {
        if (consoleData.isIPythonEnabled()) {
            return new PythonConsoleLexer();
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        if (parserDefinition == null) {
            return null;
        }
        PsiElement psi = node.getPsi();
        if (psi == null) {
            return null;
        }
        Project project = psi.getProject();
        return parserDefinition.createLexer(project);
    }

    private static LanguageLevel getLanguageLevel(PsiElement psi) {
        PsiFile file = psi.getContainingFile();
        if (!(file instanceof PyFile)) {
            PsiElement context = file.getContext();
            if (context != null) {
                return PyFileElementType.getLanguageLevel(context);
            }
            return LanguageLevel.getDefault();
        }
        return ((PyFile)file).getLanguageLevel();
    }

    @NotNull
    public String getExternalId() {
        return "python.FILE";
    }

    public void serialize(@NotNull PyFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PyFileElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            PyFileElementType.$$$reportNull$$$0(3);
        }
        PyFileElementType.writeNullableList(dataStream, stub.getDunderAll());
        PyFileElementType.writeBitSet(dataStream, stub.getFutureFeatures());
        dataStream.writeName(stub.getDeprecationMessage());
    }

    @NotNull
    public PyFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PyFileElementType.$$$reportNull$$$0(4);
        }
        List<String> all = PyFileElementType.readNullableList(dataStream);
        BitSet future_features = PyFileElementType.readBitSet(dataStream);
        StringRef deprecationMessage = dataStream.readName();
        return new PyFileStubImpl(all, future_features, deprecationMessage);
    }

    private static BitSet readBitSet(StubInputStream dataStream) throws IOException {
        BitSet ret = new BitSet(32);
        int bits = dataStream.readInt();
        for (int i = 0; i < 32; ++i) {
            boolean bit = (bits & 1 << i) != 0;
            ret.set(i, bit);
        }
        return ret;
    }

    private static void writeBitSet(StubOutputStream dataStream, BitSet bitset) throws IOException {
        int result = 0;
        for (int i = 0; i < 32; ++i) {
            int bit = (bitset.get(i) ? 1 : 0) << i;
            result |= bit;
        }
        dataStream.writeInt(result);
    }

    public static void writeNullableList(StubOutputStream dataStream, List<String> names) throws IOException {
        if (names == null) {
            dataStream.writeBoolean(false);
        } else {
            dataStream.writeBoolean(true);
            dataStream.writeVarInt(names.size());
            for (String name : names) {
                dataStream.writeName(name);
            }
        }
    }

    @Nullable
    public static List<String> readNullableList(StubInputStream dataStream) throws IOException {
        boolean hasNames = dataStream.readBoolean();
        ArrayList<String> names = null;
        if (hasNames) {
            int size = dataStream.readVarInt();
            names = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                names.add(dataStream.readNameString());
            }
        }
        return names;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/PyFileElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseContents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseConsoleCode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

