/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.TagTreeNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import java.util.LinkedHashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
final class DefaultBytecodeScope
implements TruffleObject {
    @NeverDefault
    final BytecodeNode bytecode;
    @NeverDefault
    final TagTreeNode node;
    @NeverDefault
    final int bci;
    final Frame frame;
    private NameToIndexCache cache;

    DefaultBytecodeScope(TagTreeNode node, Frame frame, boolean nodeEnter) {
        this.bytecode = node.getBytecodeNode();
        this.node = node;
        this.frame = frame;
        this.bci = nodeEnter ? node.getEnterBytecodeIndex() : node.getReturnBytecodeIndex();
    }

    @NeverDefault
    NameToIndexCache getCache() {
        if (this.cache == null) {
            this.cache = new NameToIndexCache();
        }
        return this.cache;
    }

    @ExportMessage
    boolean accepts(@Cached.Shared @Cached(value="this.bytecode", adopt=false) BytecodeNode cachedBytecode, @Cached.Shared @Cached(value="this.node", adopt=false) TagTreeNode cachedNode, @Cached.Shared @Cached(value="this.bci") int cachedBci, @Cached.Shared @Cached(value="this.getCache()", allowUncached=true) NameToIndexCache cache) {
        return this.bytecode == cachedBytecode && this.bci == cachedBci && this.node == cachedNode;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage(@Cached.Shared @Cached(value="this.node") TagTreeNode cachedNode) {
        return cachedNode.getLanguage();
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new Members(this.bytecode, this.bci);
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasSourceLocation() {
        return this.node.getSourceSection() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        SourceSection section = this.node.getSourceSection();
        if (section == null) {
            throw UnsupportedMessageException.create();
        }
        return section;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return this.bytecode.getRootNode().getName();
    }

    public String toString() {
        return "Scope[" + String.valueOf(this.getCache().getNameToIndex(this)) + "]";
    }

    Map<String, Integer> createNameToIndex() {
        LinkedHashMap<String, Integer> locals = new LinkedHashMap<String, Integer>();
        int index = 0;
        for (Object local : this.bytecode.getLocalNames(this.bci)) {
            Object name = null;
            if (local != null) {
                try {
                    name = InteropLibrary.getUncached().asString(local);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            if (name == null) {
                name = "local" + index;
            }
            locals.put((String)name, index);
            ++index;
        }
        return locals;
    }

    @CompilerDirectives.TruffleBoundary
    private Members createMembers() {
        return new Members(this.bytecode, this.bci);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean equalsString(String a, String b) {
        return a.equals(b);
    }

    static final class NameToIndexCache {
        Map<String, Integer> lazyValue;

        NameToIndexCache() {
        }

        Map<String, Integer> getNameToIndex(DefaultBytecodeScope scope) {
            Map<String, Integer> names = this.lazyValue;
            if (names == null) {
                this.lazyValue = names = scope.createNameToIndex();
            }
            return names;
        }

        @CompilerDirectives.TruffleBoundary
        int slotToIndex(DefaultBytecodeScope scope, String member) {
            Map<String, Integer> locals = this.getNameToIndex(scope);
            Integer index = locals.get(member);
            if (index == null) {
                return -1;
            }
            return index;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Members
    implements TruffleObject {
        final BytecodeNode bytecode;
        final int bci;

        Members(BytecodeNode bytecode, int bci) {
            this.bytecode = bytecode;
            this.bci = bci;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.bytecode.getLocalCount(this.bci);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            long size = this.getArraySize();
            if (index < 0L || index >= size) {
                throw InvalidArrayIndexException.create(index);
            }
            Object localName = this.bytecode.getLocalName(this.bci, (int)index);
            if (localName == null) {
                return "local" + index;
            }
            return localName;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < this.getArraySize();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Null
    implements TruffleObject {
        static final Null INSTANCE = new Null();

        private Null() {
        }

        @ExportMessage
        boolean isNull() {
            return true;
        }
    }

    @ExportMessage
    static class WriteMember {
        WriteMember() {
        }

        @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
        static void doCached(DefaultBytecodeScope scope, String member, Object value, @Cached.Shared @Cached(value="scope.bytecode", adopt=false) BytecodeNode cachedBytecode, @Cached.Shared @Cached(value="scope.bci") int cachedBci, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache, @Cached(value="member") String cachedMember, @Cached(value="cache.slotToIndex(scope, cachedMember)") int index) throws UnknownIdentifierException, UnsupportedMessageException {
            if (index == -1 || scope.frame == null) {
                throw UnsupportedMessageException.create();
            }
            cachedBytecode.setLocalValue(cachedBci, scope.frame, index, value);
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static void doGeneric(DefaultBytecodeScope scope, String member, Object value, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache) throws UnknownIdentifierException, UnsupportedMessageException {
            WriteMember.doCached(scope, member, value, scope.bytecode, scope.bci, cache, member, cache.slotToIndex(scope, member));
        }
    }

    @ExportMessage
    static class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
        static boolean doCached(DefaultBytecodeScope scope, String member, @Cached(value="member") String cachedMember, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache, @Cached(value="cache.slotToIndex(scope, cachedMember)") int index) {
            return index != -1 && scope.frame != null;
        }

        @Specialization(replaces={"doCached"})
        static boolean doGeneric(DefaultBytecodeScope scope, String member, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache) {
            return cache.slotToIndex(scope, member) != -1 && scope.frame != null;
        }
    }

    @ExportMessage
    static class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
        static boolean doCached(DefaultBytecodeScope scope, String member, @Cached(value="member") String cachedMember, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache, @Cached(value="cache.slotToIndex(scope, cachedMember)") int index) {
            return index != -1;
        }

        @Specialization(replaces={"doCached"})
        static boolean doGeneric(DefaultBytecodeScope scope, String member, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache) {
            return cache.slotToIndex(scope, member) != -1;
        }
    }

    @ExportMessage
    static class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
        static Object doCached(DefaultBytecodeScope scope, String member, @Cached.Shared @Cached(value="scope.bytecode", adopt=false) BytecodeNode cachedBytecode, @Cached.Shared @Cached(value="scope.bci") int cachedBci, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache, @Cached(value="member") String cachedMember, @Cached(value="cache.slotToIndex(scope, cachedMember)") int index) throws UnsupportedMessageException {
            if (index == -1) {
                throw UnsupportedMessageException.create();
            }
            Frame frame = scope.frame;
            if (frame == null) {
                return Null.INSTANCE;
            }
            Object o = cachedBytecode.getLocalValue(cachedBci, frame, index);
            if (o == null) {
                o = Null.INSTANCE;
            }
            return o;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(DefaultBytecodeScope scope, String member, @Cached.Shared @Cached(value="scope.getCache()", allowUncached=true) NameToIndexCache cache) throws UnsupportedMessageException {
            return ReadMember.doCached(scope, member, scope.bytecode, scope.bci, cache, member, cache.slotToIndex(scope, member));
        }
    }
}

