/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNodeGen;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@GenerateInline(value=false)
public abstract class GetDictIfExistsNode
extends PNodeWithContext {
    public abstract PDict execute(Object var1);

    public abstract PDict execute(PythonObject var1);

    @Specialization(guards={"object.getShape() == cachedShape", "hasNoDict(cachedShape)"}, limit="1")
    static PDict getNoDictCachedShape(PythonObject object, @Cached(value="object.getShape()") Shape cachedShape) {
        assert (GetDictIfExistsNode.getDictUncached(object) == null);
        return null;
    }

    @Specialization(guards={"hasNoDict(object.getShape())"}, replaces={"getNoDictCachedShape"})
    static PDict getNoDict(PythonObject object) {
        assert (GetDictIfExistsNode.getDictUncached(object) == null);
        return null;
    }

    @Idempotent
    protected static boolean hasNoDict(Shape shape) {
        return (shape.getFlags() & 8) == 0;
    }

    @Specialization(guards={"isSingleContext()", "object == cached", "dictIsConstant(cached)", "dict != null"}, limit="1")
    static PDict getConstant(PythonObject object, @Cached(value="object", weak=true) PythonObject cached, @Cached(value="getDictUncached(object)", weak=true) PDict dict) {
        return dict;
    }

    protected boolean dictIsConstant(PythonObject object) {
        return object instanceof PythonModule || object instanceof PythonManagedClass;
    }

    protected static PDict getDictUncached(PythonObject object) {
        return (PDict)HiddenAttr.ReadNode.executeUncached(object, HiddenAttr.DICT, null);
    }

    @Specialization(replaces={"getConstant"})
    @HostCompilerDirectives.InliningCutoff
    static PDict doPythonObject(PythonObject object, @Bind Node inliningTarget, @Cached HiddenAttr.ReadNode readHiddenAttrNode) {
        return (PDict)readHiddenAttrNode.execute(inliningTarget, object, HiddenAttr.DICT, null);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static PDict doNativeObject(PythonAbstractNativeObject object, @Bind Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary lib, @Cached CApiTransitions.PythonToNativeNode toNative, @Cached CStructAccess.ReadObjectNode readObjectNode, @Cached CStructAccess.WriteObjectNewRefNode writeObjectNode, @Cached InlinedBranchProfile createDict, @Cached CExtNodes.PCallCapiFunction callGetDictPtr) {
        Object dictPtr = callGetDictPtr.call(NativeCAPISymbol.FUN_PY_OBJECT_GET_DICT_PTR, toNative.execute(object));
        if (lib.isNull(dictPtr)) {
            return null;
        }
        Object dictObject = readObjectNode.readGeneric(dictPtr, 0L);
        if (dictObject == PNone.NO_VALUE) {
            createDict.enter(inliningTarget);
            PDict dict = PFactory.createDict(PythonLanguage.get(inliningTarget));
            writeObjectNode.write(dictPtr, dict);
            return dict;
        }
        if (dictObject instanceof PDict) {
            PDict dict = (PDict)dictObject;
            return dict;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, dictObject);
    }

    @Fallback
    static PDict doOther(Object object) {
        return null;
    }

    public static GetDictIfExistsNode getUncached() {
        return GetDictIfExistsNodeGen.getUncached();
    }
}

