"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.operationOptionsToRequestParameters = operationOptionsToRequestParameters;
/**
 * Helper function to convert OperationOptions to RequestParameters
 * @param options - the options that are used by Modular layer to send the request
 * @returns the result of the conversion in RequestParameters of RLC layer
 */
function operationOptionsToRequestParameters(options) {
    return {
        allowInsecureConnection: options.requestOptions?.allowInsecureConnection,
        timeout: options.requestOptions?.timeout,
        skipUrlEncoding: options.requestOptions?.skipUrlEncoding,
        abortSignal: options.abortSignal,
        onUploadProgress: options.requestOptions?.onUploadProgress,
        onDownloadProgress: options.requestOptions?.onDownloadProgress,
        headers: { ...options.requestOptions?.headers },
        onResponse: options.onResponse,
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/@typespec/ts-http-runtime/dist/commonjs/client/operationOptionHelpers.js.map