"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsolatedCircuitError = void 0;
const BrokenCircuitError_1 = require("./BrokenCircuitError");
class IsolatedCircuitError extends BrokenCircuitError_1.BrokenCircuitError {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor() {
        super(`Execution prevented because the circuit breaker is open`);
        this.isIsolatedCircuitError = true;
    }
}
exports.IsolatedCircuitError = IsolatedCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/cockatiel/dist/errors/IsolatedCircuitError.js.map