/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.sql.task.SQLToolRunListener;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatistics;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizardPageSettings;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizardPageStatus;
import org.jkiss.dbeaver.tasks.ui.sql.internal.TasksSQLUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;

class SQLToolTaskWizard
extends TaskConfigurationWizard<SQLToolExecuteSettings> {
    private static final Log log = Log.getLog(SQLToolTaskWizard.class);
    private SQLToolExecuteSettings settings;
    private SQLToolTaskWizardPageSettings pageSettings;
    private SQLToolTaskWizardPageStatus pageStatus;
    private SQLToolExecuteHandler taskHandler;
    private List<DBSObject> objectList;

    public SQLToolTaskWizard() {
    }

    public SQLToolTaskWizard(@NotNull DBTTask task) {
        super(task);
        try {
            this.taskHandler = (SQLToolExecuteHandler)task.getType().createHandler();
        }
        catch (DBException e) {
            throw new IllegalArgumentException("Error instantiating task type handler", e);
        }
        this.settings = this.taskHandler.createToolSettings();
        this.settings.loadConfiguration(UIUtils.getDialogRunnableContext(), task.getProperties(), task.getProject());
        this.objectList = this.settings.getObjectList();
    }

    public SQLToolExecuteHandler getTaskHandler() {
        return this.taskHandler;
    }

    protected String getDefaultWindowTitle() {
        return this.getTaskType().getName();
    }

    public String getTaskTypeId() {
        return this.getCurrentTask().getType().getId();
    }

    public void addPages() {
        super.addPages();
        this.pageSettings = new SQLToolTaskWizardPageSettings(this);
        this.pageStatus = new SQLToolTaskWizardPageStatus(this);
        this.addPage((IWizardPage)this.pageSettings);
        this.addPage((IWizardPage)this.pageStatus);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageSettings) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.pageSettings.saveSettings();
        this.settings.saveConfiguration(state);
    }

    public SQLToolExecuteSettings getSettings() {
        return this.settings;
    }

    public boolean performFinish() {
        if (this.isRunTaskOnFinish()) {
            this.saveConfigurationToTask(this.getCurrentTask());
            return super.performFinish();
        }
        try {
            DBTTask task = this.getCurrentTask();
            this.saveConfigurationToTask(task);
            TaskConfigurationWizardDialog container = this.getContainer();
            container.disableButtonsOnProgress();
            container.showPage((IWizardPage)this.pageStatus);
            this.pageStatus.clearLog();
            SQLTaskExecutor executor = new SQLTaskExecutor(task);
            executor.executeTask();
            if (this.taskHandler.needsRefreshOnFinish()) {
                this.refreshOnFinish();
            }
            container.enableButtonsAfterProgress();
            container.setCompleteMarkAfterProgress();
            return false;
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(e.getMessage(), TasksSQLUIMessages.sql_tool_task_wizard_message_error_running_task, (Throwable)e);
            return false;
        }
    }

    private void refreshOnFinish() throws Exception {
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask("Object refreshing", this.objectList.size());
                for (DBSObject object : this.objectList) {
                    try {
                        DBNDatabaseNode objectNode = DBNUtils.getNodeByObject((DBSObject)object);
                        if (objectNode == null) continue;
                        objectNode.refreshNode((DBRProgressMonitor)new DefaultProgressMonitor(monitor), DBNEvent.FORCE_REFRESH);
                        if (monitor.isCanceled()) break;
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error refreshing object '" + object.getName() + "'"), (Throwable)e);
                    }
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            throw new DBCException("Refresh error", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class SQLTaskExecutor
    extends TaskWizardExecutor
    implements SQLToolRunListener {
        SQLTaskExecutor(DBTTask task) {
            super(SQLToolTaskWizard.this.getRunnableContext(), task, log, SQLToolTaskWizard.this.pageStatus.getLogWriter());
        }

        public void handleActionStatistics(DBPObject object, DBEPersistAction action, DBCSession session, List<? extends SQLToolStatistics> statistics) {
            SQLToolTaskWizard.this.pageStatus.addStatistics(object, statistics);
        }
    }
}

