/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftTable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RedshiftSchema
extends PostgreSchema {
    private static final Log log = Log.getLog(RedshiftSchema.class);

    public RedshiftSchema(PostgreDatabase database, String name, ResultSet dbResult) throws SQLException {
        super(database, name, dbResult);
    }

    public RedshiftSchema(PostgreDatabase database, String name, PostgreRole owner) {
        super(database, name, owner);
    }

    @Override
    public boolean isSystem() {
        return super.isSystem() || "catalog_history".equals(this.getName());
    }

    @Override
    public String getTableColumnsQueryExtraParameters(PostgreTableContainer owner, PostgreTableBase forTable) {
        return ",format_encoding(a.attencodingtype::integer) AS \"encoding\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT \"table\",size,tbl_rows FROM SVV_TABLE_INFO WHERE \"schema\"=?");){
                dbStat.setString(1, this.getName());
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        String tableName = dbResult.getString(1);
                        PostgreTableBase table = this.getTable(monitor, tableName);
                        if (!(table instanceof RedshiftTable)) continue;
                        RedshiftTable rsTable = (RedshiftTable)table;
                        rsTable.fetchStatistics(dbResult);
                    }
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading schema relation statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }
}

