/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.resources.components.PropertyBean;

public class NumberSliderProperty
extends PropertyBean {
    private final JSlider transparencySlider;

    public NumberSliderProperty(String name, int min, int max, int step) {
        super(name);
        this.transparencySlider = new JSlider(min, max, min);
        this.transparencySlider.setMinorTickSpacing(step);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setSnapToTicks(true);
        this.transparencySlider.setPaintTrack(true);
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                NumberSliderProperty.this.firePropertyChangeEvent();
            }
        });
    }

    @Override
    public String getValue() {
        return Integer.toString(this.transparencySlider.getValue());
    }

    @Override
    public JComponent getValueComponent() {
        return this.transparencySlider;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.transparencySlider);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.transparencySlider.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.transparencySlider.setValue(Integer.parseInt(value));
    }

    public Number getNumberValue() {
        return this.transparencySlider.getValue();
    }

    public void setValue(int value) {
        this.transparencySlider.setValue(value);
    }
}

