/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import java.util.Objects;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class InSpanGenerator
implements AdaptiveFeatureGenerator {
    private static final String W_DIC = ":w=dic";
    private static final String W_DIC_IS = ":w=dic=";
    private final String prefix;
    private final TokenNameFinder finder;
    private String[] currentSentence;
    private Span[] currentNames;

    public InSpanGenerator(String prefix, TokenNameFinder finder) {
        this.prefix = Objects.requireNonNull(prefix, "prefix must not be null");
        this.finder = Objects.requireNonNull(finder, "finder must not be null");
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentNames = this.finder.find(tokens);
        }
        for (Span currentName : this.currentNames) {
            if (!currentName.contains(index)) continue;
            features.add(this.prefix + W_DIC);
            features.add(this.prefix + W_DIC_IS + tokens[index]);
            break;
        }
    }
}

