---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: マージリクエストをCSVにエクスポートする
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プロジェクトのマージリクエストから収集されたすべてのデータを、カンマ区切り値（CSV）ファイルにエクスポートします。

マージリクエストをCSVファイルにエクスポートするには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. 検索やフィルターを追加します。これにより、CSVファイルのサイズを15 MBの制限内に抑えることができます。この制限により、ファイルがさまざまなメールプロバイダーにメールで送信されるようになります。
1. **アクション** ({{< icon name="ellipsis_v" >}}) > **CSV形式でエクスポート**を選択します。
1. エクスポートするマージリクエストの数が正しいことを確認します。
1. **マージリクエストをエクスポート**を選択します。

## CSV出力 {#csv-output}

次の表は、CSVファイルの属性を示しています。

| 列             | 説明                                                  |
|--------------------|--------------------------------------------------------------|
| タイトル              | マージリクエストのタイトル                                          |
| 説明        | マージリクエストの説明                                    |
| MR ID              | MR `iid`                                                     |
| URL                | GitLabのマージリクエストへのリンク                        |
| ステート              | Opened、Closed、Locked、またはMerged                            |
| ソースブランチ      | ソースブランチ                                                |
| ターゲットブランチ      | ターゲットブランチ                                                |
| ソースプロジェクトID  | ソースブランチのID                                     |
| ターゲットプロジェクトID  | ターゲットプロジェクトのID                                     |
| 作成者             | マージリクエストの作成者のフルネーム                        |
| 作成者のユーザー名    | 作成者のユーザー名（@記号は省略）            |
| 担当者          | マージリクエストのアサイン先のフルネーム（`,`で結合） |
| アサイン先のユーザー名 | アサイン先のユーザー名（@記号は省略）         |
| 承認者          | 承認者のフルネーム（`,`で結合）               |
| 承認者のユーザー名 | 承認者のユーザー名（@記号は省略）         |
| マージされたユーザー        | マージされたユーザーのフルネーム                                 |
| マージされたユーザー名    | マージユーザーのユーザー名（@記号は省略）        |
| マイルストーンID       | マージリクエストのマイルストーンのID                            |
| 作成日（UTC）   | `YYYY-MM-DD HH:MM:SS`の形式でフォーマット                           |
| 更新日 (UTC)   | `YYYY-MM-DD HH:MM:SS`の形式でフォーマット                           |
