import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { InlineField, Input, SecretInput } from '@grafana/ui';
import { useCommonStyles } from '../styles.js';

const BasicAuth = ({
  user,
  passwordConfigured,
  userLabel = "User",
  userTooltip = "The username of the data source account",
  userPlaceholder = "User",
  passwordLabel = "Password",
  passwordTooltip = "The password of the data source account",
  passwordPlaceholder = "Password",
  onUserChange,
  onPasswordChange,
  onPasswordReset,
  readOnly
}) => {
  const commonStyles = useCommonStyles();
  const styles = {
    lastInlineField: css({
      marginBottom: 0
    })
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      InlineField,
      {
        className: commonStyles.inlineFieldNoMarginRight,
        label: userLabel,
        labelWidth: 24,
        tooltip: userTooltip,
        required: true,
        htmlFor: "basic-auth-user-input",
        interactive: true,
        grow: true,
        disabled: readOnly,
        children: /* @__PURE__ */ jsx(
          Input,
          {
            id: "basic-auth-user-input",
            placeholder: userPlaceholder,
            value: user,
            onChange: (e) => onUserChange(e.currentTarget.value),
            required: true
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(
      InlineField,
      {
        className: cx(
          commonStyles.inlineFieldNoMarginRight,
          commonStyles.inlineFieldWithSecret,
          styles.lastInlineField
        ),
        label: passwordLabel,
        labelWidth: 24,
        tooltip: passwordTooltip,
        required: true,
        htmlFor: "basic-auth-password-input",
        interactive: true,
        grow: true,
        disabled: readOnly,
        children: /* @__PURE__ */ jsx(
          SecretInput,
          {
            id: "basic-auth-password-input",
            isConfigured: passwordConfigured,
            onReset: readOnly ? () => {
            } : onPasswordReset,
            placeholder: passwordPlaceholder,
            onChange: (e) => onPasswordChange(e.currentTarget.value),
            required: true
          }
        )
      }
    )
  ] });
};

export { BasicAuth };
//# sourceMappingURL=BasicAuth.js.map
