import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useTheme2 } from '@grafana/ui';
import { SelfSignedCertificate } from './SelfSignedCertificate.js';
import { TLSClientAuth } from './TLSClientAuth.js';
import { SkipTLSVerification } from './SkipTLSVerification.js';
import 'react';
import { ConfigSubSection } from '../../ConfigSection/ConfigSubSection.js';
import '@grafana/data';

const TLSSettings = ({ selfSignedCertificate, TLSClientAuth: TLSClientAuth$1, skipTLSVerification, readOnly }) => {
  const { spacing } = useTheme2();
  const styles = {
    container: css({
      marginTop: spacing(3)
    })
  };
  return /* @__PURE__ */ jsxs(
    ConfigSubSection,
    {
      className: styles.container,
      title: "TLS settings",
      description: "Additional security measures that can be applied on top of authentication",
      children: [
        /* @__PURE__ */ jsx(SelfSignedCertificate, { ...selfSignedCertificate, readOnly }),
        /* @__PURE__ */ jsx(TLSClientAuth, { ...TLSClientAuth$1, readOnly }),
        /* @__PURE__ */ jsx(SkipTLSVerification, { ...skipTLSVerification, readOnly })
      ]
    }
  );
};

export { TLSSettings };
//# sourceMappingURL=TLSSettings.js.map
